/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.world.gen;

import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.lootgames.block.BlockDungeonBricks;
import ru.timeconqueror.lootgames.block.BlockDungeonLamp;
import ru.timeconqueror.lootgames.registry.ModBlocks;
import ru.timeconqueror.timecore.api.auxiliary.RandHelper;

public class DungeonGenerator {
    public static final int PUZZLEROOM_CENTER_TO_BORDER = 10;
    public static final int PUZZLEROOM_HEIGHT = 8;
    public static final int PUZZLEROOM_SURFACE_DISTANCE = 2;
    public static final int PUZZLEROOM_MASTER_TE_OFFSET = 3;
    private World world;
    private int centerX;
    private int centerZ;
    private int surfaceLevel = -1;
    private int dungeonTop = -1;
    private int dungeonBottom = -1;
    private Material[] invalidMaterials = new Material[]{Material.field_151575_d, Material.field_151586_h, Material.field_151570_A, Material.field_151597_y, Material.field_151577_b, Material.field_151584_j, Material.field_151585_k, Material.field_151579_a, Material.field_151587_i, Material.field_151567_E};

    public static void resetUnbreakablePlayfield(World world, BlockPos floorPos) {
        if (!DungeonGenerator.resetUnbreakableFieldsStartingFrom(world, floorPos)) {
            DungeonGenerator.resetUnbreakableFieldsStartingFrom(world, floorPos.func_177982_a(1, 0, 0));
            DungeonGenerator.resetUnbreakableFieldsStartingFrom(world, floorPos.func_177982_a(-1, 0, 0));
            DungeonGenerator.resetUnbreakableFieldsStartingFrom(world, floorPos.func_177982_a(0, 0, 1));
            DungeonGenerator.resetUnbreakableFieldsStartingFrom(world, floorPos.func_177982_a(0, 0, -1));
        }
    }

    private static boolean resetUnbreakableFieldsStartingFrom(World world, BlockPos blockPos) {
        IBlockState state = world.func_180495_p(blockPos);
        if (state.func_177230_c() == ModBlocks.DUNGEON_BRICKS && state.func_177229_b(BlockDungeonBricks.VARIANT) == BlockDungeonBricks.EnumType.DUNGEON_FLOOR_SHIELDED) {
            world.func_175656_a(blockPos, state.func_177226_a(BlockDungeonBricks.VARIANT, (Comparable)((Object)BlockDungeonBricks.EnumType.DUNGEON_FLOOR)));
            DungeonGenerator.resetUnbreakableFieldsStartingFrom(world, blockPos.func_177982_a(1, 0, 0));
            DungeonGenerator.resetUnbreakableFieldsStartingFrom(world, blockPos.func_177982_a(-1, 0, 0));
            DungeonGenerator.resetUnbreakableFieldsStartingFrom(world, blockPos.func_177982_a(0, 0, 1));
            DungeonGenerator.resetUnbreakableFieldsStartingFrom(world, blockPos.func_177982_a(0, 0, -1));
            return true;
        }
        return false;
    }

    private boolean isValidSurfaceBlock(IBlockState block) {
        boolean result = true;
        for (Material m : this.invalidMaterials) {
            if (block.func_185904_a() != m) continue;
            result = false;
            break;
        }
        LootGames.logHelper.trace("DungeonGenerator => isValidSurfaceBlock() Result is: {}", new Object[]{result});
        return result;
    }

    private boolean setSurfaceLevel(int x, int z) {
        boolean yLevelCheckPassed = true;
        for (int surfaceY = 128; surfaceY > 20; --surfaceY) {
            yLevelCheckPassed = true;
            LootGames.logHelper.trace("DungeonGenerator => setSurfaceLevel(): Scanning y={}", new Object[]{surfaceY});
            for (int axisX = -10; axisX <= 10; ++axisX) {
                for (int axisZ = -10; axisZ <= 10; ++axisZ) {
                    IBlockState state = this.world.func_180495_p(new BlockPos(axisX + x, surfaceY, axisZ + z));
                    if (this.isValidSurfaceBlock(state)) continue;
                    LootGames.logHelper.trace("DungeonGenerator => setSurfaceLevel(): y={} has failed. Block is not valid: {} in {}", new Object[]{surfaceY, state.func_177230_c().toString(), new BlockPos(axisX + x, surfaceY, axisZ + z).toString()});
                    yLevelCheckPassed = false;
                    break;
                }
                if (!yLevelCheckPassed) break;
            }
            if (!yLevelCheckPassed) continue;
            LootGames.logHelper.trace("DungeonGenerator => setSurfaceLevel(): y={} has passed", new Object[]{surfaceY});
            this.surfaceLevel = surfaceY;
            this.dungeonTop = this.surfaceLevel - 2;
            this.dungeonBottom = this.surfaceLevel - 10;
            break;
        }
        return yLevelCheckPassed;
    }

    public boolean generateDungeon(World world, int x, int z) {
        boolean result = this.doGenDungeon(world, x, z);
        return result;
    }

    public boolean doGenDungeon(World world, int x, int z) {
        LootGames.logHelper.trace("DungeonGenerator => generateDungeon()");
        this.world = world;
        this.centerX = x;
        this.centerZ = z;
        if (!this.setSurfaceLevel(x, z)) {
            LootGames.logHelper.debug("Can't spawn PuzzleDungeon. Y level not found.");
            return false;
        }
        LootGames.logHelper.trace("DungeonGenerator => generateDungeon() : Surface level found. Dungeon bottom at: y= {}", new Object[]{this.dungeonBottom});
        if (this.checkForFreeSpace()) {
            IBlockState entrance;
            for (int axisX = -10; axisX <= 10; ++axisX) {
                for (int axisZ = -10; axisZ <= 10; ++axisZ) {
                    for (int axisY = this.dungeonBottom; axisY <= this.dungeonTop; ++axisY) {
                        BlockPos pos = new BlockPos(axisX + this.centerX, axisY, axisZ + this.centerZ);
                        this.placeBlock(pos, Blocks.field_150350_a.func_176223_P());
                        if (axisX == 0 && axisZ == 0 && axisY == this.dungeonBottom + 3) {
                            this.placeBlock(pos, ModBlocks.PUZZLE_MASTER.func_176223_P());
                            continue;
                        }
                        if (axisY == this.dungeonBottom) {
                            this.placeBlock(pos, ModBlocks.DUNGEON_BRICKS.func_176203_a((Integer)RandHelper.chance((int)10, (Object)BlockDungeonBricks.EnumType.DUNGEON_FLOOR_CRACKED.getMeta(), (Object)BlockDungeonBricks.EnumType.DUNGEON_FLOOR.getMeta())));
                            continue;
                        }
                        if (axisY == this.dungeonTop) {
                            this.placeBlock(pos, ModBlocks.DUNGEON_BRICKS.func_176203_a((Integer)RandHelper.chance((int)10, (Object)BlockDungeonBricks.EnumType.DUNGEON_CEILING_CRACKED.getMeta(), (Object)BlockDungeonBricks.EnumType.DUNGEON_CEILING.getMeta())));
                            continue;
                        }
                        if (axisY == this.dungeonBottom + 1) {
                            this.placeBlock(pos, ModBlocks.DUNGEON_BRICKS.func_176203_a(BlockDungeonBricks.EnumType.DUNGEON_FLOOR_SHIELDED.getMeta()));
                            continue;
                        }
                        if (axisX != -10 && axisX != 10 && axisZ != -10 && axisZ != 10) continue;
                        if (axisY == this.dungeonTop - (int)Math.floor(4.0)) {
                            this.placeBlock(pos, ModBlocks.DUNGEON_LAMP.func_176223_P().func_177226_a((IProperty)BlockDungeonLamp.BROKEN, (Comparable)RandHelper.chance((int)10, (Object)true, (Object)false)));
                            continue;
                        }
                        this.placeBlock(pos, ModBlocks.DUNGEON_BRICKS.func_176203_a((Integer)RandHelper.chance((int)10, (Object)BlockDungeonBricks.EnumType.DUNGEON_WALL_CRACKED.getMeta(), (Object)BlockDungeonBricks.EnumType.DUNGEON_WALL.getMeta())));
                    }
                }
            }
            LootGames.logHelper.debug("PuzzleDungeon spawned at {} {} {} in Dimension {}", new Object[]{this.centerX, this.dungeonBottom, this.centerZ, world.field_73011_w.getDimension()});
            int axisZ = 10;
            int axisY = this.dungeonBottom + 2;
            do {
                ++axisZ;
                for (int axisX = this.centerX; axisX <= this.centerX; ++axisX) {
                    BlockPos blockPos;
                    IBlockState currentBlockState;
                    for (axisY = this.dungeonBottom + 2; axisY <= this.dungeonBottom + 4 && (currentBlockState = this.world.func_180495_p(blockPos = new BlockPos(axisX, axisY + (axisZ - 10), axisZ + this.centerZ))).func_185904_a().func_76220_a(); ++axisY) {
                        this.placeBlock(blockPos, Blocks.field_150350_a.func_176223_P());
                    }
                }
                BlockPos pos = new BlockPos(this.centerX, axisY + (axisZ - 10), axisZ + this.centerZ);
                entrance = this.world.func_180495_p(pos);
            } while (axisZ - 10 < 15 && (entrance != Blocks.field_150350_a || !this.world.func_175710_j(new BlockPos(this.centerX, axisY + (axisZ - 10), axisZ + this.centerZ))));
            return true;
        }
        LootGames.logHelper.debug("PuzzleDungeon not spawned, location at X/Z {} {} is not suitable", new Object[]{x, z});
        return false;
    }

    private boolean checkForFreeSpace() {
        boolean result = true;
        LootGames.logHelper.trace("DungeonGenerator => checkForFreeSpace()");
        for (int axisX = -10; axisX <= 10; ++axisX) {
            block1: for (int axisZ = -10; axisZ <= 10; ++axisZ) {
                for (int axisY = this.dungeonBottom; axisY <= this.dungeonTop; ++axisY) {
                    BlockPos pos = new BlockPos(axisX + this.centerX, axisY, axisZ + this.centerZ);
                    TileEntity te = this.world.func_175625_s(pos);
                    if (te == null) continue;
                    LootGames.logHelper.debug("Block at {} {} {} is a TileEntity. Skipping dungeon generator.", new Object[]{axisX + this.centerX, axisY, axisZ + this.centerZ});
                    result = false;
                    continue block1;
                }
            }
        }
        LootGames.logHelper.trace("DungeonGenerator => checkForFreeSpace() : Result is {}.", new Object[]{result});
        return result;
    }

    public void placeBlock(BlockPos pos, IBlockState state) {
        this.world.func_180501_a(pos, state, 3);
    }
}

