/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import techreborn.api.Reference;
import techreborn.api.recipe.machines.ScrapboxRecipe;
import techreborn.compatmod.crafttweaker.CTGeneric;
import techreborn.compatmod.crafttweaker.CraftTweakerCompat;
import techreborn.compatmod.crafttweaker.ZenDocumentation;

@ZenClass(value="mods.techreborn.scrapbox")
public class CTScrapbox {
    @ZenMethod
    @ZenDocumentation(value="IIngredient input")
    public static void addScrapboxDrop(IIngredient input) {
        RecipeHandler.addRecipe((IBaseRecipeType)new ScrapboxRecipe(CraftTweakerMC.getItemStack((IIngredient)input), 20, 2));
    }

    @ZenMethod
    @ZenDocumentation(value="IItemStack output")
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new CTGeneric.Remove(CraftTweakerCompat.toStack(output), CTScrapbox.getMachineName()));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    public static String getMachineName() {
        return Reference.SCRAPBOX_RECIPE;
    }

    public static class RemoveAll
    implements IAction {
        public void apply() {
            RecipeHandler.recipeList.removeAll(RecipeHandler.getRecipeClassFromName((String)Reference.SCRAPBOX_RECIPE));
        }

        public String describe() {
            return "Removing all Scrapbox recipies";
        }
    }
}

