/*
 * Decompiled with CFR 0.152.
 */
package techreborn.init;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import techreborn.Core;
import techreborn.config.ConfigTechReborn;

public class ModLoot {
    public static List<ResourceLocation> lootTables = new ArrayList<ResourceLocation>();

    public static void init() {
        if (ConfigTechReborn.enableOverworldLoot) {
            lootTables.add(new ResourceLocation("techreborn", "chests/abandoned_mineshaft"));
            lootTables.add(new ResourceLocation("techreborn", "chests/desert_pyramid"));
            lootTables.add(new ResourceLocation("techreborn", "chests/igloo_chest"));
            lootTables.add(new ResourceLocation("techreborn", "chests/jungle_temple"));
            lootTables.add(new ResourceLocation("techreborn", "chests/simple_dungeon"));
            lootTables.add(new ResourceLocation("techreborn", "chests/stronghold_corridor"));
            lootTables.add(new ResourceLocation("techreborn", "chests/stronghold_crossing"));
            lootTables.add(new ResourceLocation("techreborn", "chests/stronghold_library"));
            lootTables.add(new ResourceLocation("techreborn", "chests/village_blacksmith"));
            lootTables.add(new ResourceLocation("techreborn", "chests/woodland_mansion"));
        }
        if (ConfigTechReborn.enableNetherLoot) {
            lootTables.add(new ResourceLocation("techreborn", "chests/nether_bridge"));
        }
        if (ConfigTechReborn.enableEndLoot) {
            lootTables.add(new ResourceLocation("techreborn", "chests/end_city_treasure"));
        }
        for (ResourceLocation lootTable : lootTables) {
            LootTableList.func_186375_a((ResourceLocation)lootTable);
        }
    }

    @SubscribeEvent
    public void lootLoad(LootTableLoadEvent event) {
        if (!event.getName().func_110624_b().equals("minecraft")) {
            return;
        }
        for (ResourceLocation lootTable : lootTables) {
            if (!event.getName().func_110623_a().equals(lootTable.func_110623_a())) continue;
            event.getTable().addPool(this.getLootPool(lootTable));
            if (!Core.DEV_FEATURES) continue;
            Core.logHelper.info((Object)("Loot pool injected into " + lootTable.func_110623_a()));
        }
    }

    private LootPool getLootPool(ResourceLocation lootTable) {
        LootEntryTable entry = new LootEntryTable(lootTable, 1, 0, new LootCondition[0], "lootEntry_" + lootTable.toString());
        LootPool pool = new LootPool(new LootEntry[]{entry}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "lootPool_" + lootTable.toString());
        return pool;
    }
}

