/*
 * Decompiled with CFR 0.152.
 */
package techreborn.init.recipes;

import java.security.InvalidParameterException;
import net.minecraft.item.ItemStack;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import techreborn.api.recipe.machines.DistillationTowerRecipe;
import techreborn.init.recipes.RecipeMethods;
import techreborn.items.ItemCells;
import techreborn.items.ItemDynamicCell;

public class DistillationTowerRecipes
extends RecipeMethods {
    public static void init() {
        DistillationTowerRecipes.register(ItemCells.getCellByName("oil", 16), 16000, 16, DistillationTowerRecipes.getMaterial("diesel", 16, RecipeMethods.Type.CELL), DistillationTowerRecipes.getMaterial("sulfuricAcid", 16, RecipeMethods.Type.CELL), DistillationTowerRecipes.getMaterial("glyceryl", RecipeMethods.Type.CELL), DistillationTowerRecipes.getMaterial("methane", 16, RecipeMethods.Type.CELL));
    }

    static void register(ItemStack input, int ticks, int euPerTick, boolean oreDict, ItemStack ... outputs) {
        ItemStack output1;
        ItemStack output2 = null;
        ItemStack output3 = null;
        ItemStack output4 = null;
        if (outputs.length == 3) {
            output1 = outputs[0];
            output2 = outputs[1];
            output3 = outputs[2];
        } else if (outputs.length == 2) {
            output1 = outputs[0];
            output2 = outputs[1];
        } else if (outputs.length == 1) {
            output1 = outputs[0];
        } else if (outputs.length == 4) {
            output1 = outputs[0];
            output2 = outputs[1];
            output3 = outputs[2];
            output4 = outputs[3];
        } else {
            throw new InvalidParameterException("Invalid number of distillation tower outputs: " + outputs);
        }
        int cellCount = 0;
        for (ItemStack stack : outputs) {
            if (!(stack.func_77973_b() instanceof ItemDynamicCell)) continue;
            cellCount += stack.func_190916_E();
        }
        if (input.func_77973_b() instanceof ItemDynamicCell) {
            int inputCount = input.func_190916_E();
            if (cellCount < inputCount) {
                if (output2 == null) {
                    output2 = ItemDynamicCell.getEmptyCell(inputCount - cellCount);
                } else if (output3 == null) {
                    output3 = ItemDynamicCell.getEmptyCell(inputCount - cellCount);
                } else if (output4 == null) {
                    output4 = ItemDynamicCell.getEmptyCell(inputCount - cellCount);
                }
            }
            cellCount -= inputCount;
        }
        if (cellCount < 0) {
            cellCount = 0;
        }
        ItemStack cells = null;
        if (cellCount > 0) {
            if (cellCount > 64) {
                throw new InvalidParameterException("Invalid distillation tower outputs: " + outputs + "(Recipe requires > 64 cells)");
            }
            cells = ItemDynamicCell.getEmptyCell(cellCount);
        }
        RecipeHandler.addRecipe((IBaseRecipeType)new DistillationTowerRecipe(input, cells, output1, output2, output3, output4, ticks, euPerTick, oreDict));
    }

    static void register(ItemStack input, int ticks, int euPerTick, ItemStack ... outputs) {
        DistillationTowerRecipes.register(input, ticks, euPerTick, true, outputs);
    }
}

