/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.util.ChatUtils;
import reborncore.common.util.ItemUtils;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;
import techreborn.items.tools.ItemDrill;
import techreborn.lib.MessageIDs;

public class ItemAdvancedDrill
extends ItemDrill {
    public ItemAdvancedDrill() {
        super(Item.ToolMaterial.DIAMOND, "techreborn.advancedDrill", ConfigTechReborn.AdvancedDrillCharge, 2.0f, 10.0f);
        this.cost = 250;
        this.transferLimit = 1000.0;
    }

    public Set<BlockPos> getTargetBlocks(World worldIn, BlockPos pos, @Nullable EntityPlayer playerIn) {
        HashSet<BlockPos> targetBlocks;
        block9: {
            EnumFacing enumfacing;
            block10: {
                block8: {
                    targetBlocks = new HashSet<BlockPos>();
                    if (!(playerIn instanceof EntityPlayer)) {
                        return new HashSet<BlockPos>();
                    }
                    RayTraceResult raytrace = this.func_77621_a(worldIn, playerIn, false);
                    if (raytrace == null || raytrace.field_178784_b == null) {
                        return Collections.emptySet();
                    }
                    enumfacing = raytrace.field_178784_b;
                    if (enumfacing != EnumFacing.SOUTH && enumfacing != EnumFacing.NORTH) break block8;
                    for (int i = -1; i < 2; ++i) {
                        for (int j = -1; j < 2; ++j) {
                            BlockPos newPos = pos.func_177982_a(i, j, 0);
                            if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                            targetBlocks.add(newPos);
                        }
                    }
                    break block9;
                }
                if (enumfacing != EnumFacing.EAST && enumfacing != EnumFacing.WEST) break block10;
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        BlockPos newPos = pos.func_177982_a(0, j, i);
                        if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                        targetBlocks.add(newPos);
                    }
                }
                break block9;
            }
            if (enumfacing != EnumFacing.DOWN && enumfacing != EnumFacing.UP) break block9;
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    BlockPos newPos = pos.func_177982_a(j, 0, i);
                    if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                    targetBlocks.add(newPos);
                }
            }
        }
        return targetBlocks;
    }

    public void breakBlock(BlockPos pos, World world, EntityPlayer playerIn, ItemStack drill) {
        IBlockState blockState = world.func_180495_p(pos);
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(drill);
        if (capEnergy.getEnergyStored() > this.cost) {
            capEnergy.extractEnergy(this.cost, false);
            ExternalPowerSystems.requestEnergyFromArmor((ForgePowerItemManager)capEnergy, (EntityLivingBase)playerIn);
            blockState.func_177230_c().removedByPlayer(blockState, world, pos, playerIn, true);
            blockState.func_177230_c().func_180657_a(world, playerIn, pos, blockState, world.func_175625_s(pos), drill);
            world.func_175698_g(pos);
            world.func_175713_t(pos);
        }
    }

    private boolean shouldBreak(EntityPlayer playerIn, World worldIn, BlockPos originalPos, BlockPos pos) {
        if (originalPos.equals((Object)pos)) {
            return false;
        }
        IBlockState blockState = worldIn.func_180495_p(pos);
        if (blockState.func_185904_a() == Material.field_151579_a) {
            return false;
        }
        if (blockState.func_185904_a().func_76224_d()) {
            return false;
        }
        float blockHardness = blockState.func_185903_a(playerIn, worldIn, pos);
        if (blockHardness == -1.0f) {
            return false;
        }
        float originalHardness = worldIn.func_180495_p(originalPos).func_185903_a(playerIn, worldIn, originalPos);
        return !(originalHardness / blockHardness > 10.0f);
    }

    @Override
    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        EntityPlayer playerIn = null;
        if (entityLiving instanceof EntityPlayer) {
            playerIn = (EntityPlayer)entityLiving;
        }
        if (ItemUtils.isActive((ItemStack)stack)) {
            for (BlockPos additionalPos : this.getTargetBlocks(worldIn, pos, playerIn)) {
                this.breakBlock(additionalPos, worldIn, playerIn, stack);
            }
        }
        return super.func_179218_a(stack, worldIn, blockIn, pos, entityLiving);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (new ForgePowerItemManager(stack).getEnergyStored() < this.cost) {
                ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.func_135052_a((String)"techreborn.message.nanosaberEnergyErrorTo", (Object[])new Object[0]) + " " + TextFormatting.GOLD + I18n.func_135052_a((String)"techreborn.message.nanosaberActivate", (Object[])new Object[0])));
            } else if (!ItemUtils.isActive((ItemStack)stack)) {
                if (stack.func_77978_p() == null) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74757_a("isActive", true);
                if (world.field_72995_K) {
                    ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.func_135052_a((String)"techreborn.message.setTo", (Object[])new Object[0]) + " " + TextFormatting.GOLD + I18n.func_135052_a((String)"techreborn.message.nanosaberActive", (Object[])new Object[0])));
                }
            } else {
                stack.func_77978_p().func_74757_a("isActive", false);
                if (world.field_72995_K) {
                    ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.func_135052_a((String)"techreborn.message.setTo", (Object[])new Object[0]) + " " + TextFormatting.GOLD + I18n.func_135052_a((String)"techreborn.message.nanosaberInactive", (Object[])new Object[0])));
                }
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (ItemUtils.isActive((ItemStack)stack) && new ForgePowerItemManager(stack).getEnergyStored() < this.cost) {
            if (worldIn.field_72995_K) {
                ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.func_135052_a((String)"techreborn.message.nanosaberEnergyError", (Object[])new Object[0]) + " " + TextFormatting.GOLD + I18n.func_135052_a((String)"techreborn.message.nanosaberDeactivating", (Object[])new Object[0])));
            }
            stack.func_77978_p().func_74757_a("isActive", false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!ItemUtils.isActive((ItemStack)stack)) {
            tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"techreborn.message.nanosaberInactive", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"techreborn.message.nanosaberActive", (Object[])new Object[0]));
        }
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return (Items.field_151046_w.func_150897_b(blockIn) || Items.field_151047_v.func_150897_b(blockIn)) && !Items.field_151056_x.func_150897_b(blockIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> itemList) {
        if (!this.func_194125_a(par2CreativeTabs)) {
            return;
        }
        ItemStack stack = new ItemStack(ModItems.ADVANCED_DRILL);
        ItemStack charged = stack.func_77946_l();
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(charged);
        capEnergy.setEnergyStored(capEnergy.getMaxEnergyStored());
        itemList.add((Object)stack);
        itemList.add((Object)charged);
    }
}

