/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.processing;

import java.util.ArrayDeque;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.IToolDrop;
import reborncore.api.praescriptum.recipes.Recipe;
import reborncore.api.praescriptum.recipes.RecipeHandler;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;

public abstract class TileMachine
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider,
IContainerProvider {
    public final String name;
    public final int maxInput;
    public final int maxEnergy;
    public final Inventory inventory;
    public final RecipeHandler recipeHandler;
    public final Block drop;
    protected final int energySlot;
    protected final int[] inputSlots;
    protected final int[] outputSlots;
    protected int progress = 0;
    protected int operationLength = 0;
    protected int energyPerTick = 0;
    protected ItemStack[] itemOutputsBuffer = new ItemStack[0];
    protected Recipe lastRecipe = null;

    public TileMachine(String name, int maxInput, int maxEnergy, int energySlot, int slots, RecipeHandler recipeHandler, Block drop) {
        this(name, maxInput, maxEnergy, energySlot, slots, 64, recipeHandler, drop);
    }

    public TileMachine(String name, int maxInput, int maxEnergy, int energySlot, int slots, int slotSize, RecipeHandler recipeHandler, Block drop) {
        this(name, maxInput, maxEnergy, energySlot, slots, slotSize, new int[]{0}, new int[]{1}, recipeHandler, drop);
    }

    public TileMachine(String name, int maxInput, int maxEnergy, int energySlot, int slots, int slotSize, int[] inputSlots, int[] outputSlots, RecipeHandler recipeHandler, Block drop) {
        this.name = "Tile" + name;
        this.maxInput = maxInput;
        this.maxEnergy = maxEnergy;
        this.energySlot = energySlot;
        this.inventory = new Inventory(slots, name, slotSize, (TileEntity)this);
        this.inputSlots = inputSlots;
        this.outputSlots = outputSlots;
        this.recipeHandler = recipeHandler;
        this.drop = drop;
        this.checkTeir();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound data = tag.func_74775_l("TileMachine");
        this.progress = data.func_74764_b("progress") ? data.func_74762_e("progress") : 0;
        this.operationLength = data.func_74764_b("operationLength") ? data.func_74762_e("operationLength") : 0;
        this.energyPerTick = data.func_74764_b("energyPerTick") ? data.func_74762_e("energyPerTick") : 0;
        this.itemOutputsBuffer = new ItemStack[this.outputSlots.length];
        for (int index = 0; index < this.itemOutputsBuffer.length; ++index) {
            this.itemOutputsBuffer[index] = data.func_74764_b("outputs." + index) ? new ItemStack(data.func_74775_l("outputs." + index)) : null;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("progress", this.progress);
        data.func_74768_a("operationLength", this.operationLength);
        data.func_74768_a("energyPerTick", this.energyPerTick);
        for (int index = 0; index < this.itemOutputsBuffer.length; ++index) {
            ItemStack output = this.itemOutputsBuffer[index];
            if (ItemUtils.isEmpty((ItemStack)output)) continue;
            NBTTagCompound outputTag = output.func_77955_b(new NBTTagCompound());
            data.func_74782_a("outputs." + index, (NBTBase)outputTag);
        }
        tag.func_74782_a("TileMachine", (NBTBase)data);
        return tag;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.charge(this.energySlot);
        boolean needsInventoryUpdate = false;
        if (this.operationLength > 0) {
            int progressNeeded = Math.max((int)((double)this.operationLength * (1.0 - this.getSpeedMultiplier())), 1);
            if (this.progress < progressNeeded) {
                this.doWork();
            }
            if (this.progress >= progressNeeded) {
                this.finishWork();
                needsInventoryUpdate = true;
            }
        } else if (this.startWork()) {
            needsInventoryUpdate = true;
            if (!this.active) {
                this.setActive(true);
            }
        } else if (this.active) {
            this.setActive(false);
        }
        if (needsInventoryUpdate) {
            super.func_70296_d();
        }
    }

    public double getBaseMaxPower() {
        return this.maxEnergy;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return this.maxInput;
    }

    protected boolean startWork() {
        ArrayDeque<ItemStack> inputs = new ArrayDeque<ItemStack>();
        for (int index : this.inputSlots) {
            ItemStack input = this.inventory.func_70301_a(index);
            if (ItemUtils.isEmpty((ItemStack)input)) continue;
            inputs.add(input);
        }
        if (inputs.isEmpty()) {
            this.reset();
            return false;
        }
        Recipe recipe = this.recipeHandler.findAndApply(inputs, true);
        if (recipe == null) {
            this.reset();
            return false;
        }
        if (!this.canUseEnergy(this.getEuPerTick(recipe.getEnergyCostPerTick()))) {
            this.reset();
            return false;
        }
        ItemStack[] itemOutputs = recipe.getItemOutputs();
        if (this.addToOutputs(itemOutputs, true) != 0) {
            this.reset();
            return false;
        }
        this.recipeHandler.apply(recipe, inputs, false);
        this.operationLength = recipe.getOperationDuration();
        this.energyPerTick = recipe.getEnergyCostPerTick();
        this.itemOutputsBuffer = itemOutputs;
        return true;
    }

    protected void doWork() {
        if (this.canUseEnergy(this.getEuPerTick(this.energyPerTick))) {
            this.useEnergy(this.getEuPerTick(this.energyPerTick));
            ++this.progress;
        }
    }

    protected void finishWork() {
        this.addToOutputs(this.itemOutputsBuffer, false);
        this.reset();
    }

    protected void reset() {
        this.progress = 0;
        this.operationLength = 0;
        this.energyPerTick = 0;
        Arrays.fill(this.itemOutputsBuffer, null);
        this.lastRecipe = null;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public ItemStack getToolDrop(EntityPlayer player) {
        return new ItemStack(this.drop, 1);
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getOperationLength() {
        return this.operationLength;
    }

    public void setOperationLength(int operationLength) {
        this.operationLength = operationLength;
    }

    public int getProgressScaled(int scale) {
        return this.progress == 0 || this.operationLength == 0 ? 0 : this.progress * scale / this.operationLength;
    }

    protected int addToOutputs(ItemStack stack, boolean simulate) {
        return this.addToOutputs(new ItemStack[]{stack}, simulate);
    }

    protected int addToOutputs(ItemStack[] stacks, boolean simulate) {
        if (stacks == null || stacks.length == 0) {
            return 0;
        }
        ItemStack[] copy = simulate ? this.createCopyOfSlots(this.outputSlots) : null;
        int totalAmount = 0;
        for (ItemStack stack : stacks) {
            int amount = ItemUtils.getSize((ItemStack)stack);
            if (amount <= 0) continue;
            block1: for (int type = 0; type < 2; ++type) {
                for (int outputSlot : this.outputSlots) {
                    ItemStack existingStack = this.inventory.func_70301_a(outputSlot);
                    int space = this.inventory.func_70297_j_();
                    if (!ItemUtils.isEmpty((ItemStack)existingStack)) {
                        space = Math.min(space, existingStack.func_77976_d()) - ItemUtils.getSize((ItemStack)existingStack);
                    }
                    if (space <= 0) continue;
                    if (type == 0 && !ItemUtils.isEmpty((ItemStack)existingStack) && ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)existingStack, (boolean)true, (boolean)true)) {
                        if (space >= amount) {
                            this.inventory.func_70299_a(outputSlot, ItemUtils.increaseSize((ItemStack)existingStack, (int)amount));
                            amount = 0;
                            break block1;
                        }
                        this.inventory.func_70299_a(outputSlot, ItemUtils.increaseSize((ItemStack)existingStack, (int)space));
                        amount -= space;
                        continue;
                    }
                    if (type != 1 || !ItemUtils.isEmpty((ItemStack)existingStack)) continue;
                    if (space >= amount) {
                        this.inventory.func_70299_a(outputSlot, ItemUtils.copyWithSize((ItemStack)stack, (int)amount));
                        amount = 0;
                        break block1;
                    }
                    this.inventory.func_70299_a(outputSlot, ItemUtils.copyWithSize((ItemStack)stack, (int)space));
                    amount -= space;
                }
            }
            totalAmount += amount;
        }
        if (simulate) {
            this.loadCopyOfSlots(this.outputSlots, copy);
        }
        return totalAmount;
    }

    protected ItemStack[] createCopyOfSlots(int[] slots) {
        ItemStack[] ret = new ItemStack[slots.length];
        for (int index = 0; index < slots.length; ++index) {
            ItemStack contents = this.inventory.func_70301_a(slots[index]);
            ret[index] = ItemUtils.isEmpty((ItemStack)contents) ? ItemStack.field_190927_a : contents.func_77946_l();
        }
        return ret;
    }

    protected void loadCopyOfSlots(int[] slots, ItemStack[] copy) {
        if (slots.length != copy.length) {
            throw new IllegalArgumentException("The number of slots does not match the size of the copy");
        }
        for (int index = 0; index < slots.length; ++index) {
            this.inventory.func_70299_a(slots[index], copy[index]);
        }
    }
}

