/*
 * Decompiled with CFR 0.152.
 */
package electroblob.tfspellpack.spell;

import electroblob.tfspellpack.registry.TFSPItems;
import electroblob.tfspellpack.registry.TFSPSpells;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import twilightforest.TwilightForestMod;
import twilightforest.client.particle.TFParticleType;

@Mod.EventBusSubscriber
public class ChariotOfIce
extends Spell {
    public static final String SPEED = "speed";
    public static final String ACCELERATION = "acceleration";
    public static final String HOVER_HEIGHT = "hover_height";
    public static final String MAX_HOVER_HEIGHT = "max_hover_height";
    public static final String KNOCKBACK_STRENGTH = "knockback_strength";
    public static final String MAX_CRUSH_DAMAGE = "max_crush_damage";
    private static final float VERTICAL_MOVEMENT_FACTOR = 0.25f;
    private static final float VERTICAL_ACCELERATION_FACTOR = 0.2f;
    private static final float HOVER_ANIMATION_PERIOD = 5.0f;
    private static final double HOVER_ANIMATION_MAGNITUDE = 0.1;
    private static final float SLAM_HEIGHT_FRACTION = 0.7f;
    private static final float BLOCK_BREAK_RADIUS_FRACTION = 0.6f;
    private static final double SLAM_SPEED = 1.5;

    public ChariotOfIce() {
        super("tfspellpack", "chariot_of_ice", EnumAction.NONE, true);
        this.addProperties(new String[]{SPEED, ACCELERATION, HOVER_HEIGHT, MAX_HOVER_HEIGHT, "damage", KNOCKBACK_STRENGTH, "blast_radius", MAX_CRUSH_DAMAGE});
    }

    public boolean applicableForItem(Item item) {
        return item == TFSPItems.twilight_spell_book || item == TFSPItems.twilight_scroll;
    }

    protected SoundEvent[] createSounds() {
        return this.createSoundsWithSuffixes(new String[]{"ambient", "hit", "ground_slam", "rumble"});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        float direction;
        float speed = this.getProperty(SPEED).floatValue() * modifiers.get("potency");
        float acceleration = this.getProperty(ACCELERATION).floatValue() * modifiers.get("potency");
        float damage = this.getProperty("damage").floatValue() * modifiers.get("potency");
        float knockback = this.getProperty(KNOCKBACK_STRENGTH).floatValue();
        Vec3d hLookVec = WizardryUtilities.replaceComponent((Vec3d)caster.func_70040_Z(), (EnumFacing.Axis)EnumFacing.Axis.Y, (double)0.0).func_72432_b();
        double hSpeedSquared = caster.field_70159_w * caster.field_70159_w + caster.field_70179_y * caster.field_70179_y;
        if (caster.field_191988_bg != 0.0f) {
            direction = Math.signum(caster.field_191988_bg);
            if (hSpeedSquared < (double)(speed * speed)) {
                caster.func_70024_g((double)direction * hLookVec.field_72450_a * (double)acceleration, 0.0, (double)direction * hLookVec.field_72449_c * (double)acceleration);
            }
        }
        if (caster.field_70702_br != 0.0f) {
            direction = Math.signum(caster.field_70702_br);
            if (hSpeedSquared < (double)(speed * speed)) {
                caster.func_70024_g((double)direction * hLookVec.field_72449_c * (double)acceleration, 0.0, (double)direction * -hLookVec.field_72450_a * (double)acceleration);
            }
        }
        List targets = world.func_72872_a(EntityLivingBase.class, caster.func_174813_aQ().func_72321_a(-1.0, -1.0, -1.0).func_72321_a(1.0, 0.0, 1.0));
        targets.remove(caster);
        for (EntityLivingBase target : targets) {
            target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.FROST), damage);
            target.func_70024_g((target.field_70165_t - caster.field_70165_t) * (double)knockback, (double)0.2f, (target.field_70161_v - caster.field_70161_v) * (double)knockback);
        }
        if (!targets.isEmpty()) {
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[]{"hit"});
        }
        float minHoverHeight = this.getProperty(HOVER_HEIGHT).floatValue();
        float maxHoverHeight = this.getProperty(MAX_HOVER_HEIGHT).floatValue();
        if (caster.func_70093_af()) {
            caster.field_70181_x = -1.5;
        } else {
            caster.field_70143_R = 0.0f;
            float hoverHeight = caster instanceof EntityPlayerSP && ((EntityPlayerSP)caster).field_71158_b.field_78901_c ? maxHoverHeight : minHoverHeight;
            hoverHeight = (float)((double)hoverHeight + (double)MathHelper.func_76126_a((float)((float)ticksInUse / 5.0f)) * 0.1);
            Integer floor = WizardryUtilities.getNearestFloor((World)world, (BlockPos)caster.func_180425_c(), (int)(MathHelper.func_76123_f((float)hoverHeight) + 1));
            if (floor != null) {
                caster.field_70181_x = Math.min(((double)((float)floor.intValue() + hoverHeight) - caster.field_70163_u) * (double)0.2f, (double)(speed * 0.25f));
            }
        }
        if (world.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                double x = caster.field_70165_t + (double)caster.field_70130_N * (world.field_73012_v.nextDouble() - 0.5);
                double y = caster.field_70163_u + (double)caster.field_70131_O * world.field_73012_v.nextDouble() - 0.3;
                double z = caster.field_70161_v + (double)caster.field_70130_N * (world.field_73012_v.nextDouble() - 0.5);
                TwilightForestMod.proxy.spawnParticle(TFParticleType.SNOW, x, y, z, 0.0, 0.0, 0.0);
            }
        }
        if (ticksInUse % 100 == 0) {
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[]{"ambient"});
        }
        return true;
    }

    private void slamGround(EntityPlayer caster) {
        World world = caster.field_70170_p;
        SpellModifiers modifiers = WizardData.get((EntityPlayer)caster).itemCastingModifiers;
        float radius = this.getProperty("blast_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
        float minHoverHeight = this.getProperty(HOVER_HEIGHT).floatValue();
        float maxHoverHeight = this.getProperty(MAX_HOVER_HEIGHT).floatValue();
        if (caster.field_70122_E && caster.field_70143_R > minHoverHeight + (maxHoverHeight - minHoverHeight) * 0.7f) {
            float maxDamage = this.getProperty(MAX_CRUSH_DAMAGE).floatValue() * modifiers.get("potency");
            List targets = WizardryUtilities.getEntitiesWithinRadius((double)radius, (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)world);
            for (EntityLivingBase target : targets) {
                if (target != caster) {
                    float damage1 = maxDamage * Math.min(1.0f, (radius - target.func_70032_d((Entity)caster)) / radius * 2.0f);
                    target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.FROST), damage1);
                }
                if (!world.field_72995_K || !(target instanceof EntityPlayer)) continue;
                Wizardry.proxy.shakeScreen((EntityPlayer)target, 10.0f);
            }
            if (!world.field_72995_K && WizardryUtilities.canDamageBlocks((EntityLivingBase)caster, (World)world) && ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)TFSPItems.ring_aurora)) {
                double radius1 = radius * 0.6f;
                WizardryUtilities.getBlockSphere((BlockPos)caster.func_180425_c(), (double)radius1).forEach(pos -> {
                    if (!WizardryUtilities.isBlockUnbreakable((World)world, (BlockPos)pos) && world.field_73012_v.nextDouble() > WizardryUtilities.getCentre((BlockPos)pos).func_72438_d(caster.func_174791_d()) / radius1 - 0.3) {
                        world.func_175655_b(pos, true);
                    }
                });
            }
            if (world.field_72995_K) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPHERE).clr(0.7f, 0.9f, 1.0f).scale(4.0f).entity((Entity)caster).spawn(world);
                for (int i = 0; i < 40; ++i) {
                    double x = caster.field_70165_t - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                    double z = caster.field_70161_v - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                    IBlockState block = WizardryUtilities.getBlockEntityIsStandingOn((Entity)caster);
                    if (block == null) continue;
                    world.func_175688_a(EnumParticleTypes.BLOCK_DUST, x, caster.func_174813_aQ().field_72338_b, z, x - caster.field_70165_t, 0.0, z - caster.field_70161_v, new int[]{Block.func_176210_f((IBlockState)block)});
                }
            }
            this.playSound(world, (EntityLivingBase)caster, 0, -1, modifiers, new String[]{"rumble"});
            this.playSound(world, (EntityLivingBase)caster, 0, -1, modifiers, new String[]{"ground_slam"});
        }
    }

    @SubscribeEvent
    public static void onPlayerFlyableFallEvent(PlayerFlyableFallEvent event) {
        if (WizardryUtilities.isCasting((EntityLivingBase)event.getEntityLiving(), (Spell)TFSPSpells.chariot_of_ice)) {
            ((ChariotOfIce)TFSPSpells.chariot_of_ice).slamGround(event.getEntityPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingFallEvent(LivingFallEvent event) {
        if (event.getEntity() instanceof EntityPlayer && WizardryUtilities.isCasting((EntityLivingBase)event.getEntityLiving(), (Spell)TFSPSpells.chariot_of_ice)) {
            ((ChariotOfIce)TFSPSpells.chariot_of_ice).slamGround((EntityPlayer)event.getEntity());
            event.setCanceled(true);
        }
    }
}

