/*
 * Decompiled with CFR 0.152.
 */
package electroblob.tfspellpack.spell;

import electroblob.tfspellpack.registry.TFSPItems;
import electroblob.wizardry.spell.SpellBuff;
import electroblob.wizardry.util.SpellModifiers;
import java.util.function.Supplier;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;

public class HydrasVigour
extends SpellBuff {
    public static final String HUNGER_POINTS = "hunger_points";
    public static final String SATURATION_MODIFIER = "saturation_modifier";

    public HydrasVigour() {
        super("tfspellpack", "hydras_vigour", 0.82f, 0.36f, 0.46f, new Supplier[]{() -> MobEffects.field_76428_l});
        this.addProperties(new String[]{HUNGER_POINTS, SATURATION_MODIFIER});
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    public boolean applicableForItem(Item item) {
        return item == TFSPItems.twilight_spell_book || item == TFSPItems.twilight_scroll;
    }

    protected boolean applyEffects(EntityLivingBase caster, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer && ((EntityPlayer)caster).func_71024_bL().func_75121_c()) {
            int foodAmount = (int)(this.getProperty(HUNGER_POINTS).floatValue() * modifiers.get("potency"));
            ((EntityPlayer)caster).func_71024_bL().func_75122_a(foodAmount, this.getProperty(SATURATION_MODIFIER).floatValue());
            super.applyEffects(caster, modifiers);
            return true;
        }
        return super.applyEffects(caster, modifiers);
    }
}

