/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.gasconduits.common.network;

import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.conduits.network.AbstractConduitPacket;
import gg.galaxygaming.gasconduits.common.conduit.IGasConduit;
import gg.galaxygaming.gasconduits.common.conduit.ender.EnderGasConduit;
import gg.galaxygaming.gasconduits.common.filter.GasFilter;
import gg.galaxygaming.gasconduits.common.filter.IGasFilter;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGasFilter
extends AbstractConduitPacket.Sided<IGasConduit> {
    private boolean isInput;
    @Nonnull
    private IGasFilter filter = new GasFilter();

    public PacketGasFilter() {
    }

    public PacketGasFilter(EnderGasConduit eConduit, @Nonnull EnumFacing dir, @Nonnull IGasFilter filter, boolean isInput) {
        super((IConduit)eConduit, dir);
        this.filter = filter;
        this.isInput = isInput;
    }

    public void write(@Nonnull ByteBuf buf) {
        super.write(buf);
        buf.writeBoolean(this.isInput);
        NBTTagCompound tag = new NBTTagCompound();
        this.filter.writeToNBT(tag);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public void read(@Nonnull ByteBuf buf) {
        super.read(buf);
        this.isInput = buf.readBoolean();
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        if (tag != null) {
            this.filter.readFromNBT(tag);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketGasFilter, IMessage> {
        public IMessage onMessage(PacketGasFilter message, MessageContext ctx) {
            IGasConduit conduit = (IGasConduit)message.getConduit(ctx);
            if (conduit instanceof EnderGasConduit) {
                ((EnderGasConduit)conduit).setFilter(message.dir, message.filter, message.isInput);
                World world = message.getWorld(ctx);
                IBlockState bs = world.func_180495_p(message.getPos());
                world.func_184138_a(message.getPos(), bs, bs, 3);
            }
            return null;
        }
    }
}

