/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.toolleveling;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.events.TinkerEvent;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.toolleveling.TinkerToolLeveling;
import slimeknights.toolleveling.Tooltips;
import slimeknights.toolleveling.config.Config;

public final class EventHandler {
    public static EventHandler INSTANCE = new EventHandler();

    @SubscribeEvent
    public void onToolBuild(TinkerEvent.OnItemBuilding event) {
        ArrayList materials = Lists.newArrayList();
        for (int i = 0; i < event.tool.getRequiredComponents().size(); ++i) {
            materials.add(Material.UNKNOWN);
        }
        NBTTagCompound baseTag = event.tool.buildTag((List)materials);
        int modifiers = baseTag.func_74762_e("FreeModifiers");
        int modifierDelta = Config.getStartingModifiers() - modifiers;
        NBTTagCompound toolTag = TagUtil.getToolTag((NBTTagCompound)event.tag);
        modifiers = toolTag.func_74762_e("FreeModifiers");
        modifiers += modifierDelta;
        modifiers = Math.max(0, modifiers);
        toolTag.func_74768_a("FreeModifiers", modifiers);
        TagUtil.setToolTag((NBTTagCompound)event.tag, (NBTTagCompound)toolTag);
        if (TinkerUtil.getModifierTag((NBTTagCompound)event.tag, (String)TinkerToolLeveling.modToolLeveling.getModifierIdentifier()).func_82582_d()) {
            TinkerToolLeveling.modToolLeveling.apply(event.tag);
        }
        if (!TinkerUtil.hasModifier((NBTTagCompound)event.tag, (String)TinkerToolLeveling.modToolLeveling.getModifierIdentifier())) {
            TinkerToolLeveling.modToolLeveling.apply(event.tag);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        Tooltips.addTooltips(event.getItemStack(), event.getToolTip());
    }

    private EventHandler() {
    }
}

