/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.util;

import gollorum.signpost.util.MyBlockPos;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class BaseInfo {
    private static final String VERSION = "Version2:";
    private String name;
    public MyBlockPos blockPos;
    public MyBlockPos pos;
    public UUID owner;

    public BaseInfo(String name, MyBlockPos pos, UUID owner) {
        this.name = "" + name;
        this.blockPos = pos;
        this.pos = pos == null ? null : new MyBlockPos(pos);
        this.owner = owner;
    }

    public BaseInfo(String name, MyBlockPos blockPos, MyBlockPos telePos, UUID owner) {
        --telePos.y;
        this.name = "" + name;
        this.blockPos = blockPos;
        this.pos = telePos;
        this.owner = owner;
    }

    public static BaseInfo loadBaseInfo(String name, MyBlockPos blockPos, MyBlockPos telePos, UUID owner) {
        ++telePos.y;
        return new BaseInfo(name, blockPos, telePos, owner);
    }

    public void writeToNBT(NBTTagCompound tC) {
        tC.func_74778_a("name", "" + this.name);
        NBTTagCompound posComp = new NBTTagCompound();
        this.pos.writeToNBT(posComp);
        tC.func_74782_a("pos", (NBTBase)posComp);
        NBTTagCompound blockPosComp = new NBTTagCompound();
        this.pos.writeToNBT(blockPosComp);
        this.blockPos.writeToNBT(blockPosComp);
        tC.func_74782_a("blockPos", (NBTBase)blockPosComp);
        this.pos.writeToNBT(tC);
        tC.func_74778_a("UUID", "" + this.owner);
    }

    public static BaseInfo readFromNBT(NBTTagCompound tC) {
        String name = tC.func_74779_i("name");
        if (tC.func_74764_b("blockPos")) {
            MyBlockPos pos = MyBlockPos.readFromNBT(tC.func_74775_l("pos"));
            MyBlockPos blockPos = MyBlockPos.readFromNBT(tC.func_74775_l("blockPos"));
            UUID owner = BaseInfo.uuidFromString(tC.func_74779_i("UUID"));
            return BaseInfo.loadBaseInfo(name, blockPos, pos, owner);
        }
        MyBlockPos pos = MyBlockPos.readFromNBT(tC);
        UUID owner = BaseInfo.uuidFromString(tC.func_74779_i("UUID"));
        return new BaseInfo(name, pos, owner);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)("" + this.name));
        this.pos.toBytes(buf);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(VERSION + this.owner));
        this.blockPos.toBytes(buf);
    }

    public static BaseInfo fromBytes(ByteBuf buf) {
        String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        MyBlockPos pos = MyBlockPos.fromBytes(buf);
        String o = ByteBufUtils.readUTF8String((ByteBuf)buf);
        if (o.startsWith(VERSION)) {
            UUID owner;
            o = o.replaceFirst(VERSION, "");
            try {
                owner = BaseInfo.uuidFromString(o);
            }
            catch (Exception e) {
                owner = null;
            }
            MyBlockPos blockPos = MyBlockPos.fromBytes(buf);
            return BaseInfo.loadBaseInfo(name, blockPos, pos, owner);
        }
        UUID owner = BaseInfo.uuidFromString(o);
        return new BaseInfo(name, pos, owner);
    }

    public boolean equals(Object other) {
        if (!(other instanceof BaseInfo)) {
            return super.equals(other);
        }
        return ((BaseInfo)other).blockPos.equals(this.blockPos);
    }

    public void setAll(BaseInfo newWS) {
        this.name = "" + newWS.name;
        this.pos.update(newWS.pos);
        this.blockPos.update(newWS.blockPos);
        this.owner = newWS.owner;
    }

    public boolean update(BaseInfo newWS) {
        if (this.equals(newWS)) {
            this.setAll(newWS);
            return true;
        }
        return false;
    }

    public String toString() {
        return "" + this.name;
    }

    public boolean hasName() {
        return this.name != null && !this.name.equals("null") && !this.name.equals("");
    }

    public String getName() {
        return this.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNative() {
        return this.blockPos.modID.equals("signpost");
    }

    public static BaseInfo fromExternal(String name, int x, int y, int z, int dimension, String modId) {
        String worldString;
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimension);
        try {
            worldString = world.func_72912_H().func_76065_j();
        }
        catch (Exception e) {
            worldString = "";
        }
        MyBlockPos pos = new MyBlockPos(worldString, x, y, z, dimension, modId);
        return new BaseInfo(name, pos, null);
    }

    public static BaseInfo fromExternal(String name, int blockX, int blockY, int blockZ, int teleX, int teleY, int teleZ, int dimension, String modId) {
        String worldString;
        try {
            WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimension);
            worldString = world.func_72912_H().func_76065_j();
        }
        catch (Exception e) {
            worldString = "";
        }
        MyBlockPos blockPos = new MyBlockPos(worldString, blockX, blockY, blockZ, dimension, modId);
        MyBlockPos telePos = new MyBlockPos(worldString, teleX, teleY, teleZ, dimension, modId);
        return new BaseInfo(name, blockPos, telePos, null);
    }

    private static UUID uuidFromString(String string) {
        try {
            return UUID.fromString(string);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

