/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.util.math;

import java.util.Collection;

public class MatrixD {
    protected double[][] values;
    protected int rows;
    protected int columns;

    public MatrixD(int i, int j) {
        this.values = new double[i][j];
        this.rows = i;
        this.columns = j;
    }

    public MatrixD(double[][] values) {
        this.values = (double[][])values.clone();
        this.repair();
    }

    public MatrixD(Collection<? extends Collection<Double>> values) {
        this.values = new double[values.size()][];
        int i = 0;
        for (Collection<Double> collection : values) {
            this.columns = Math.max(this.columns, collection.size());
            this.values[i] = new double[this.columns];
            int j = 0;
            for (Double val : collection) {
                this.values[i][j] = val;
                ++j;
            }
            ++i;
        }
        this.repair();
    }

    public double get(int i, int j) {
        this.checkBounds(i, j);
        return this.values[i][j];
    }

    public void set(double value, int i, int j) {
        this.checkBounds(i, j);
        this.values[i][j] = value;
    }

    public void gaussAlgorithm() {
        int offset = 0;
        for (int i = 0; i < this.columns && offset < this.rows; ++i) {
            this.sortColumnBy0(i, offset);
            if (!this.test0(this.values[offset][i])) {
                int j;
                this.divideRow(offset, this.values[offset][i]);
                for (j = 0; j < offset; ++j) {
                    this.substractRows(j, offset, this.values[j][i]);
                }
                for (j = offset + 1; j < this.rows; ++j) {
                    this.substractRows(j, offset, this.values[j][i]);
                }
                ++offset;
                continue;
            }
            this.values[offset][i] = 0.0;
        }
    }

    public boolean check() {
        boolean ret = true;
        for (int i = 0; i < this.rows; ++i) {
            ret = ret && this.checkRow(i);
        }
        return ret;
    }

    private boolean checkRow(int row) {
        int n0c = 0;
        for (int i = 0; i < this.columns - 1; ++i) {
            if (!this.test0(this.values[row][i])) {
                ++n0c;
                continue;
            }
            this.values[row][i] = 0.0;
        }
        return n0c <= 1 && (n0c != 0 || this.test0(this.values[row][this.columns - 1]));
    }

    private void substractRows(int targetRow, int otherRow, double factor) {
        for (int i = 0; i < this.columns; ++i) {
            double[] dArray = this.values[targetRow];
            int n = i;
            dArray[n] = dArray[n] - this.values[otherRow][i] * factor;
        }
    }

    private void divideRow(int row, double divident) {
        int i = 0;
        while (i < this.columns) {
            double[] dArray = this.values[row];
            int n = i++;
            dArray[n] = dArray[n] / divident;
        }
    }

    private void sortColumnBy0(int col, int offset) {
        int row;
        for (int j = row = this.rows - 1; j >= offset; --j) {
            if (!this.test0(this.values[j][col])) continue;
            this.swapRows(j, row--);
        }
    }

    private void repair() {
        this.rows = this.values.length;
        for (double[] now : this.values) {
            this.columns = Math.max(this.columns, now.length);
        }
        for (int i = 0; i < this.rows; ++i) {
            if (this.values[i].length == this.columns) continue;
            double[] vals = new double[this.columns];
            for (int j = 0; j < this.values[i].length; ++j) {
                vals[j] = this.values[i][j];
            }
            this.values[i] = vals;
        }
    }

    private void checkBounds(int i, int j) {
        if (i < 0 || j < 0 || i >= this.rows || j >= this.columns) {
            throw new IndexOutOfBoundsException("Out of matrix bounds: " + i + "|" + j + " (" + this.rows + "x" + this.columns + ")");
        }
    }

    private void swapRows(int i, int j) {
        double[] org = this.values[i];
        this.values[i] = this.values[j];
        this.values[j] = org;
    }

    public void print() {
        for (double[] row : this.values) {
            System.out.print("|");
            for (double x : row) {
                System.out.print(x + " ");
            }
            System.out.print("|");
            System.out.println();
        }
    }

    private boolean test0(double var) {
        return -1.0E-11 < var && var < 1.0E-11;
    }

    private void addRows(int targetRow, int otherRow, double factor) {
        for (int i = 0; i < this.columns; ++i) {
            double[] dArray = this.values[targetRow];
            int n = i;
            dArray[n] = dArray[n] + this.values[otherRow][i] * factor;
        }
    }

    private void multiplyRow(int row, double factor) {
        int i = 0;
        while (i < this.columns) {
            double[] dArray = this.values[row];
            int n = i++;
            dArray[n] = dArray[n] * factor;
        }
    }

    private void swapColumns(int i, int j) {
        for (int k = 0; k < this.rows; ++k) {
            double val = this.values[k][i];
            this.values[k][i] = this.values[k][j];
            this.values[k][j] = val;
        }
    }
}

