/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.worldGen.villages;

import gollorum.signpost.Signpost;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.util.code.MinecraftIndependent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.IOUtils;

@MinecraftIndependent
public class NameLibrary {
    private static NameLibrary INSTANCE;
    private static final int MAX_TRIES = 50;
    private final List<String> first;
    private final List<String> second;
    private final List<String> third;

    public static NameLibrary getInstance() {
        return INSTANCE;
    }

    public static void init(String configFolder) {
        try {
            INSTANCE = new NameLibrary(configFolder);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private NameLibrary(String configFolder) {
        this.assureFileExists(configFolder, "first");
        this.first = this.readNameParts(configFolder, "first");
        this.assureFileExists(configFolder, "second");
        this.second = this.readNameParts(configFolder, "second");
        this.assureFileExists(configFolder, "third");
        this.third = this.readNameParts(configFolder, "third");
    }

    private File getFile(String folder, String index) {
        return new File(folder, "villagenames" + index + ".txt");
    }

    private void assureFileExists(String configFolder, String index) {
        try {
            if (!this.getFile(configFolder, index).exists()) {
                this.copyFile(configFolder, index);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void copyFile(String configFolder, String index) throws IOException {
        InputStream in = Signpost.proxy.getResourceInputStream("signpost:worldgen/villagenames" + index + ".txt");
        if (in == null) {
            in = Signpost.proxy.getResourceInputStream("/assets/signpost/worldgen/villagenames" + index + ".txt");
        }
        FileOutputStream out = new FileOutputStream(this.getFile(configFolder, index));
        IOUtils.copy((InputStream)in, (OutputStream)out);
        in.close();
        ((OutputStream)out).close();
    }

    private List<String> readNameParts(String configFolder, String index) {
        LinkedList<String> possibleNames = new LinkedList<String>();
        try {
            possibleNames.addAll(Files.readAllLines(this.getFile(configFolder, index).toPath()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return possibleNames;
    }

    public boolean namesLeft() {
        for (int i = 0; i < this.first.size(); ++i) {
            for (int j = 0; j < this.second.size(); ++j) {
                for (int k = 0; k < this.third.size(); ++k) {
                    if (PostHandler.getNativeWaystones().nameTaken(this.getName(i, j, k))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getName(Random random) {
        for (int i = 0; i < 50; ++i) {
            String name = this.getName(random.nextInt(this.first.size()), random.nextInt(this.second.size()), random.nextInt(this.third.size()));
            if (PostHandler.getNativeWaystones().nameTaken(name)) continue;
            return name;
        }
        return null;
    }

    private String getName(int i, int j, int k) {
        String a = this.first.get(i);
        String b = this.second.get(j);
        String c = this.third.get(k);
        if (a.endsWith(" ")) {
            b = b.substring(0, 1).toUpperCase() + b.substring(1);
        }
        if (b.endsWith(" ")) {
            c = c.substring(0, 1).toUpperCase() + c.substring(1);
        }
        return a + b + c;
    }
}

