/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.worldGen.villages.signpost;

import gollorum.signpost.BlockHandler;
import gollorum.signpost.Signpost;
import gollorum.signpost.util.MyBlockPos;
import gollorum.signpost.util.code.MinecraftDependent;
import gollorum.signpost.worldGen.villages.GenerateStructureHelper;
import gollorum.signpost.worldGen.villages.VillageLibrary;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;

@MinecraftDependent
public class VillageComponentSignpost
extends StructureVillagePieces.Village {
    private boolean built = false;
    private StructureVillagePieces.Start start;
    private EnumFacing facing;

    public VillageComponentSignpost() {
    }

    public VillageComponentSignpost(StructureVillagePieces.Start start, int type, StructureBoundingBox boundingBox, EnumFacing facing) {
        super(start, type);
        this.field_74887_e = boundingBox;
        this.start = start;
        this.facing = facing;
    }

    @Nullable
    public static StructureVillagePieces.Village buildComponent(StructureVillagePieces.Start startPiece, List<StructureComponent> pieces, Random random, int x, int y, int z, EnumFacing facing, int type) {
        StructureBoundingBox boundingBox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)3, (int)3, (int)3, (EnumFacing)facing);
        if (VillageComponentSignpost.func_74895_a((StructureBoundingBox)boundingBox) && VillageComponentSignpost.func_74883_a(pieces, (StructureBoundingBox)boundingBox) == null) {
            return new VillageComponentSignpost(startPiece, type, boundingBox, facing.func_176734_d());
        }
        return null;
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox boundingBox) {
        BlockPos postPos;
        if (this.built || this.start == null) {
            return true;
        }
        this.built = true;
        int x = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
        int z = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
        try {
            postPos = GenerateStructureHelper.getInstance().getTopSolidOrLiquidBlock(world, new BlockPos(x, 0, z));
        }
        catch (Exception e) {
            postPos = new BlockPos(x, this.field_74887_e.field_78894_e, z);
        }
        BlockHandler cfr_ignored_0 = Signpost.proxy.blockHandler;
        world.func_175656_a(postPos, BlockHandler.post_oak.func_176223_P());
        BlockHandler cfr_ignored_1 = Signpost.proxy.blockHandler;
        world.func_175656_a(postPos.func_177982_a(0, 1, 0), BlockHandler.post_oak.func_176223_P());
        if (world.func_180495_p(postPos.func_177982_a(0, -1, 0)).func_185904_a().func_76224_d()) {
            IBlockState block = this.func_175847_a(Blocks.field_150344_f.func_176223_P());
            world.func_175656_a(postPos.func_177982_a(0, -1, 0), block);
            world.func_175656_a(postPos.func_177982_a(-1, -1, -1), block);
            world.func_175656_a(postPos.func_177982_a(-1, -1, 0), block);
            world.func_175656_a(postPos.func_177982_a(-1, -1, 1), block);
            world.func_175656_a(postPos.func_177982_a(0, -1, -1), block);
            world.func_175656_a(postPos.func_177982_a(0, -1, 1), block);
            world.func_175656_a(postPos.func_177982_a(1, -1, -1), block);
            world.func_175656_a(postPos.func_177982_a(1, -1, 0), block);
            world.func_175656_a(postPos.func_177982_a(1, -1, 1), block);
        }
        StructureBoundingBox villageBox = this.start.func_74874_b();
        MyBlockPos villagePos = new MyBlockPos(world, villageBox.field_78897_a, 0, villageBox.field_78896_c);
        MyBlockPos blockPos = new MyBlockPos(world, postPos.func_177982_a(0, 1, 0));
        VillageLibrary.getInstance().putSignpost(villagePos, blockPos, this.optimalRot(this.facing));
        return true;
    }

    private double optimalRot(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 0.0;
            }
            case EAST: {
                return 4.71238898038469;
            }
            case SOUTH: {
                return Math.PI;
            }
            case WEST: {
                return 1.5707963267948966;
            }
        }
        return 0.0;
    }
}

