/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api.satellite;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.ISatelliteIdItem;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.satellite.SatelliteProperties;
import zmaster587.advancedRocketry.item.ItemSatellite;

public abstract class SatelliteBase {
    protected SatelliteProperties satelliteProperties = new SatelliteProperties();
    private int dimId = -2147483647;
    protected ItemStack satellite;
    private boolean isDead;

    public SatelliteBase() {
        this.satelliteProperties.setSatelliteType(SatelliteRegistry.getKey(this.getClass()));
        this.isDead = false;
        this.satellite = ItemStack.field_190927_a;
    }

    public boolean acceptsItemInConstruction(ItemStack item) {
        int flag = SatelliteRegistry.getSatelliteProperty(item).getPropertyFlag();
        return SatelliteProperties.Property.MAIN.isOfType(flag);
    }

    public abstract String getInfo(World var1);

    public abstract String getName();

    public abstract boolean performAction(EntityPlayer var1, World var2, BlockPos var3);

    public abstract double failureChance();

    public ItemStack getContollerItemStack(ItemStack satIdChip, SatelliteProperties properties) {
        ISatelliteIdItem idChipItem = (ISatelliteIdItem)satIdChip.func_77973_b();
        idChipItem.setSatellite(satIdChip, properties);
        return satIdChip;
    }

    public boolean isAcceptableControllerItemStack(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == AdvancedRocketryItems.itemSatelliteIdChip;
    }

    public boolean canTick() {
        return false;
    }

    public void tickEntity() {
    }

    public long getId() {
        return this.satelliteProperties.getId();
    }

    public void setDead() {
        this.isDead = true;
    }

    public boolean isDead() {
        return this.isDead;
    }

    public void setDimensionId(World world) {
        int newId = world.field_73011_w.getDimension();
        if (this.dimId != -2147483647) {
            // empty if block
        }
        this.dimId = newId;
    }

    public void setDimensionId(int world) {
        int newId = world;
        if (this.dimId != -2147483647) {
            // empty if block
        }
        this.dimId = newId;
    }

    public void setProperties(ItemStack stack) {
        this.satelliteProperties = ((ItemSatellite)stack.func_77973_b()).getSatellite(stack);
        this.satellite = stack;
    }

    public ItemStack getItemStackFromSatellite() {
        return this.satellite;
    }

    public int getDimensionId() {
        return this.dimId;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("dataType", SatelliteRegistry.getKey(this.getClass()));
        NBTTagCompound properties = new NBTTagCompound();
        this.satelliteProperties.writeToNBT(properties);
        nbt.func_74782_a("properties", (NBTBase)properties);
        nbt.func_74768_a("dimId", this.dimId);
        NBTTagCompound itemNBT = new NBTTagCompound();
        if (!this.satellite.func_190926_b()) {
            this.satellite.func_77955_b(itemNBT);
        }
        nbt.func_74782_a("item", (NBTBase)itemNBT);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.satelliteProperties.readFromNBT(nbt.func_74775_l("properties"));
        this.dimId = nbt.func_74762_e("dimId");
        this.satellite = new ItemStack(nbt.func_74775_l("item"));
    }

    public void writeDataToNetwork(ByteBuf out, byte packetId) {
    }

    public void readDataToNetwork(byte packetId, ByteBuf in) {
    }

    public void useNetworkData(EntityPlayer player, Side client, byte packetId, NBTTagCompound nbt) {
    }

    public int numberChangesToSend() {
        return 0;
    }

    public void onChangeRecieved(int slot, int value) {
    }

    public boolean isUpdateRequired(int localId) {
        return false;
    }

    public void sendChanges(Container container, IContainerListener crafter, int variableId, int localId) {
    }
}

