/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import zmaster587.advancedRocketry.network.PacketFluidParticle;
import zmaster587.libVulpes.cap.FluidCapability;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.tile.TileEntityRFConsumer;

public class TilePump
extends TileEntityRFConsumer
implements IFluidHandler,
IModularInventory {
    private FluidTank tank = new FluidTank(16000);
    private List<BlockPos> cache = new LinkedList<BlockPos>();
    private final int RANGE = 64;

    public TilePump() {
        super(1000);
    }

    public int getPowerPerOperation() {
        return 100;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidCapability((IFluidHandler)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.tank.getFluid() != null) {
            for (EnumFacing direction : EnumFacing.values()) {
                BlockPos newBlock = this.func_174877_v().func_177972_a(direction);
                TileEntity tile = this.field_145850_b.func_175625_s(newBlock);
                if (tile == null || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d())) continue;
                IFluidHandler cap = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d());
                FluidStack stack = this.tank.getFluid().copy();
                stack.amount = Math.min(this.tank.getFluid().amount, 1000);
                cap.fill(this.tank.drain(cap.fill(stack, false), true), true);
                if (this.tank.getFluid() == null) break;
            }
        }
    }

    private int getFrequencyFromPower() {
        float ratio = (float)this.energy.getUniversalEnergyStored() / (float)this.energy.getMaxEnergyStored();
        if ((double)ratio > 0.5) {
            return 1;
        }
        return 10;
    }

    public void performFunction() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.tank.getCapacity() - 1000 < this.tank.getFluidAmount()) {
                return;
            }
            BlockPos nextPos = this.getNextBlockLocation();
            if (nextPos != null && this.canFitFluid(nextPos)) {
                Block worldBlock = this.field_145850_b.func_180495_p(nextPos).func_177230_c();
                Material mat = this.field_145850_b.func_180495_p(nextPos).func_185904_a();
                if (worldBlock instanceof IFluidBlock) {
                    FluidStack stack = ((IFluidBlock)worldBlock).drain(this.field_145850_b, nextPos, true);
                    if (stack != null) {
                        this.tank.fill(stack, true);
                    }
                    int colour = ((IFluidBlock)worldBlock).getFluid().getColor();
                    if (mat == Material.field_151587_i) {
                        colour = -4376808;
                    }
                    PacketHandler.sendToNearby((BasePacket)new PacketFluidParticle(nextPos, this.field_174879_c, 200, colour), (int)this.field_145850_b.field_73011_w.getDimension(), (BlockPos)this.field_174879_c, (double)128.0);
                }
            }
        }
    }

    private boolean canFitFluid(BlockPos pos) {
        Block worldBlock = this.field_145850_b.func_180495_p(pos).func_177230_c();
        return worldBlock instanceof IFluidBlock && (this.tank.getFluid() == null || this.tank.getFluid().getFluid() == ((IFluidBlock)worldBlock).getFluid());
    }

    private BlockPos getNextBlockLocation() {
        if (!this.cache.isEmpty()) {
            return this.cache.remove(0);
        }
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos(this.func_174877_v().func_177977_b());
        while (this.field_145850_b.func_175623_d((BlockPos)currentPos)) {
            currentPos = currentPos.func_177977_b();
        }
        Block worldBlock = this.field_145850_b.func_180495_p((BlockPos)currentPos).func_177230_c();
        if (this.canFitFluid((BlockPos)currentPos)) {
            this.findFluidAtOrAbove((BlockPos)currentPos, ((IFluidBlock)worldBlock).getFluid());
        }
        if (!this.cache.isEmpty()) {
            return this.cache.remove(0);
        }
        return null;
    }

    private List<BlockPos> findFluidAtOrAbove(BlockPos pos, Fluid fluid) {
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        queue.add(pos);
        while (!queue.isEmpty()) {
            Block worldBlock;
            BlockPos nextElement = (BlockPos)queue.poll();
            if (visited.contains(nextElement) || nextElement.func_185332_f(pos.func_177958_n(), nextElement.func_177956_o(), pos.func_177952_p()) > 64.0 || !((worldBlock = this.field_145850_b.func_180495_p(nextElement).func_177230_c()) instanceof IFluidBlock) || fluid != null && ((IFluidBlock)worldBlock).getFluid() != fluid) continue;
            if (((IFluidBlock)worldBlock).canDrain(this.field_145850_b, nextElement)) {
                this.cache.add(0, nextElement);
            }
            visited.add(nextElement);
            queue.add(nextElement.func_177976_e());
            queue.add(nextElement.func_177974_f());
            queue.add(nextElement.func_177978_c());
            queue.add(nextElement.func_177968_d());
            queue.add(nextElement.func_177984_a());
        }
        return this.cache;
    }

    public boolean canPerformFunction() {
        return this.tank.getFluidAmount() <= this.tank.getCapacity() && this.field_145850_b.func_72820_D() % (long)this.getFrequencyFromPower() == 0L;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.tank.drain(resource, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public List<ModuleBase> getModules(int id, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        return modules;
    }

    public String getModularInventoryName() {
        return "tile.pump.name";
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return false;
    }
}

