/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.unit;

import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.item.ItemStationChip;
import zmaster587.advancedRocketry.tile.TileRocketBuilder;
import zmaster587.advancedRocketry.unit.BaseTest;
import zmaster587.advancedRocketry.unit.IngameTestOrchestrator;
import zmaster587.advancedRocketry.world.provider.WorldProviderSpace;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.block.RotatableBlock;

public class BuildRocketTest
extends BaseTest {
    BlockPos rocketBuilderPos;
    int originalWorldId;
    BlockPos originalPos;

    BuildRocketTest() {
        this.name = "Basic Rocket Tests";
    }

    public void Phase1(World world, EntityPlayer player) {
        this.originalWorldId = world.field_73011_w.getDimension();
        this.teleportPlayerToStart(player);
        this.clearLandscape(world);
        this.buildBasicRocketPlatform(world, player);
        this.buildBasicRocketStructure(world, player, new BlockPos(3, 65, 3));
        this.buildRocket(world, player);
        try {
            IngameTestOrchestrator.scheduleEvent(world, 150L, BuildRocketTest.class.getDeclaredMethod("Phase2", World.class, EntityPlayer.class), this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void Phase2(World world, EntityPlayer player) {
        EntityRocket rocket = this.findRocketOnPad(world);
        this.originalPos = rocket.func_180425_c();
        this.FuelRocket(rocket);
        this.putStationIntoRocket(rocket, 1);
        this.mountPlayerToRocket(player, rocket);
        rocket.prepareLaunch();
        try {
            IngameTestOrchestrator.scheduleEvent(world, 1500L, BuildRocketTest.class.getDeclaredMethod("Phase3", World.class, EntityPlayer.class), this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void Phase3(World world, EntityPlayer player) {
        if (!(player.field_70170_p.field_73011_w instanceof WorldProviderSpace)) {
            throw new AssertionError((Object)"Expected to be on space station!");
        }
        if (!(player.func_184187_bx() instanceof EntityRocket)) {
            throw new AssertionError((Object)"Expected player to be riding a rocket!");
        }
        ((EntityRocket)player.func_184187_bx()).prepareLaunch();
        try {
            IngameTestOrchestrator.scheduleEvent(world, 1600L, BuildRocketTest.class.getDeclaredMethod("Phase4", World.class, EntityPlayer.class), this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void Phase4(World world, EntityPlayer player) {
        if (player.field_70170_p.field_73011_w.getDimension() != this.originalWorldId) {
            throw new AssertionError((Object)"Expected to return to the same world we started from");
        }
        if (!(player.func_184187_bx() instanceof EntityRocket)) {
            throw new AssertionError((Object)"Expected player to be riding a rocket");
        }
        if (!player.func_184187_bx().func_180425_c().equals((Object)this.originalPos)) {
            throw new AssertionError((Object)"Expected to land near where we took off!");
        }
        this.success();
    }

    public void teleportPlayerToStart(EntityPlayer player) {
        player.func_70634_a(0.0, 100.0, 0.0);
    }

    public void clearLandscape(World world) {
        for (int x = -20; x < 20; ++x) {
            for (int z = -20; z <= 20; ++z) {
                for (int y = 62; y < 250; ++y) {
                    world.func_175698_g(new BlockPos(x, y, z));
                }
            }
        }
    }

    public void buildBasicRocketPlatform(World world, EntityPlayer player) {
        BlockPos builderPos;
        int padSize = 5;
        int height = 6;
        this.rocketBuilderPos = builderPos = new BlockPos(2, 65, -1);
        for (int x = 0; x <= 5; ++x) {
            for (int z = 0; z <= 5; ++z) {
                world.func_175656_a(new BlockPos(x, 64, z), AdvancedRocketryBlocks.blockLaunchpad.func_176223_P());
            }
        }
        for (int y = 0; y <= 6; ++y) {
            world.func_175656_a(new BlockPos(-1, 64 + y, 3), AdvancedRocketryBlocks.blockStructureTower.func_176223_P());
        }
        world.func_175656_a(builderPos, AdvancedRocketryBlocks.blockRocketBuilder.func_176223_P().func_177226_a((IProperty)RotatableBlock.FACING, (Comparable)EnumFacing.NORTH));
        world.func_175656_a(builderPos.func_177984_a(), LibVulpesBlocks.blockCreativeInputPlug.func_176223_P());
        TileEntity tile = world.func_175625_s(builderPos);
        if (!(tile instanceof TileRocketBuilder)) {
            throw new AssertionError((Object)"Expected tile rocket builder!");
        }
        if (((TileRocketBuilder)tile).getRocketPadBounds(world, builderPos) == null) {
            throw new AssertionError((Object)"Invalid Rocket pad!");
        }
    }

    public void buildBasicRocketStructure(World world, EntityPlayer player, BlockPos centerBottom) {
        int centerX = centerBottom.func_177958_n();
        int bottomY = centerBottom.func_177956_o();
        int centerZ = centerBottom.func_177952_p();
        world.func_175656_a(new BlockPos(centerX - 1, bottomY, centerZ), AdvancedRocketryBlocks.blockAdvEngine.func_176223_P());
        world.func_175656_a(new BlockPos(centerX + 1, bottomY, centerZ), AdvancedRocketryBlocks.blockAdvEngine.func_176223_P());
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int yOffset = 1; yOffset <= 2; ++yOffset) {
                world.func_175656_a(new BlockPos(centerX + xOffset, bottomY + yOffset, centerZ), AdvancedRocketryBlocks.blockFuelTank.func_176223_P());
            }
        }
        world.func_175656_a(new BlockPos(centerX, bottomY + 3, centerZ), AdvancedRocketryBlocks.blockGuidanceComputer.func_176223_P());
        world.func_175656_a(new BlockPos(centerX, bottomY + 4, centerZ), AdvancedRocketryBlocks.blockGenericSeat.func_176223_P());
    }

    public void buildRocket(World world, EntityPlayer player) {
        this.buildRocket(world, player, this.rocketBuilderPos);
    }

    public void buildRocket(World world, EntityPlayer player, BlockPos tilePos) {
        TileEntity tile = world.func_175625_s(tilePos);
        if (!(tile instanceof TileRocketBuilder)) {
            throw new AssertionError((Object)"Expected tile rocket builder!");
        }
        if (((TileRocketBuilder)tile).getRocketPadBounds(world, tilePos) == null) {
            throw new AssertionError((Object)"Invalid Rocket pad!");
        }
        ((TileRocketBuilder)tile).useNetworkData(player, Side.SERVER, (byte)1, new NBTTagCompound());
    }

    public void mountPlayerToRocket(EntityPlayer player, EntityRocket rocket) {
        player.func_184220_m((Entity)rocket);
    }

    public void putStationIntoRocket(EntityRocket rocket, int stationId) {
        ItemStack stack = new ItemStack(AdvancedRocketryItems.itemSpaceStationChip);
        ItemStationChip.setUUID(stack, stationId);
        rocket.storage.getGuidanceComputer().func_70299_a(0, stack);
    }

    public void FuelRocket(EntityRocket rocket) {
        rocket.setFuelAmount(rocket.getFuelCapacity());
    }

    public EntityRocket findRocketOnPad(World world) {
        EntityRocket rocket = this.finishBuildingRocket(world);
        return rocket;
    }

    public EntityRocket finishBuildingRocket(World world) {
        List list = world.func_72872_a(EntityRocket.class, new AxisAlignedBB(new BlockPos(0, 64, 0), new BlockPos(6, 72, 6)));
        if (list.size() != 1) {
            throw new AssertionError((Object)"Cannot find rocket!");
        }
        return (EntityRocket)list.get(0);
    }
}

