/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.ore;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.util.OreGenProperties;

public class CustomizableOreGen
implements IWorldGenerator {
    IBlockState oreToGen;
    int numPerChunk;
    int clumpSize;
    int heightLevel;
    int difference;

    public CustomizableOreGen(IBlockState oreToGen, int numPerChunk, int clumpSize, int minHeight, int maxHeight) {
        this.oreToGen = oreToGen;
        this.numPerChunk = numPerChunk;
        this.clumpSize = clumpSize;
        this.difference = maxHeight - minHeight;
        this.heightLevel = minHeight;
    }

    public CustomizableOreGen(OreGenProperties.OreEntry genProps) {
        this.oreToGen = genProps.getBlockState();
        this.clumpSize = genProps.getClumpSize();
        this.heightLevel = genProps.getMinHeight();
        this.difference = genProps.getMaxHeight() - this.heightLevel;
        this.numPerChunk = genProps.getChancePerChunk();
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        IBlockState state;
        CustomPredicate predicate = null;
        if (DimensionManager.getInstance().isDimensionCreated(world.field_73011_w.getDimension()) && (state = DimensionManager.getInstance().getDimensionProperties(world.field_73011_w.getDimension()).getStoneBlock()) != null) {
            predicate = new CustomPredicate(state);
        }
        for (int i = 0; i < this.numPerChunk; ++i) {
            int coordX = 16 * chunkX + random.nextInt(16);
            int coordY = this.heightLevel + random.nextInt(this.difference);
            int coordZ = 16 * chunkZ + random.nextInt(16);
            if (predicate != null) {
                new WorldGenMinable(this.oreToGen, this.clumpSize, (Predicate)predicate).func_180709_b(world, random, new BlockPos(coordX, coordY, coordZ));
                continue;
            }
            new WorldGenMinable(this.oreToGen, this.clumpSize).func_180709_b(world, random, new BlockPos(coordX, coordY, coordZ));
        }
    }

    static class CustomPredicate
    implements Predicate<IBlockState> {
        IBlockState state;

        public CustomPredicate(IBlockState state) {
            this.state = state;
        }

        public boolean apply(IBlockState p_apply_1_) {
            if (p_apply_1_ != null) {
                if (p_apply_1_.func_177230_c() == Blocks.field_150348_b) {
                    BlockStone.EnumType blockstone$enumtype = (BlockStone.EnumType)p_apply_1_.func_177229_b((IProperty)BlockStone.field_176247_a);
                    return blockstone$enumtype.func_190912_e();
                }
                if (p_apply_1_.func_177230_c() == this.state.func_177230_c()) {
                    return true;
                }
            }
            return false;
        }
    }
}

