/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.api.network;

import com.google.common.collect.Lists;
import fluxnetworks.api.tiles.IFluxConnector;
import fluxnetworks.api.tiles.IFluxController;
import fluxnetworks.api.tiles.IFluxPlug;
import fluxnetworks.api.tiles.IFluxPoint;
import fluxnetworks.api.tiles.IFluxStorage;
import java.util.ArrayList;
import java.util.List;

public class FluxCacheTypes<T extends IFluxConnector> {
    public static final FluxCacheTypes flux = new FluxCacheTypes<IFluxConnector>(IFluxConnector.class);
    public static final FluxCacheTypes plug = new FluxCacheTypes<IFluxPlug>(IFluxPlug.class);
    public static final FluxCacheTypes point = new FluxCacheTypes<IFluxPoint>(IFluxPoint.class);
    public static final FluxCacheTypes storage = new FluxCacheTypes<IFluxStorage>(IFluxStorage.class);
    public static final FluxCacheTypes controller = new FluxCacheTypes<IFluxController>(IFluxController.class);
    public Class<T> clazz;
    public static final List<FluxCacheTypes> types = Lists.newArrayList((Object[])new FluxCacheTypes[]{flux, plug, point, storage, controller});

    public FluxCacheTypes(Class<T> clazz) {
        this.clazz = clazz;
    }

    public static List<FluxCacheTypes> getValidTypes(IFluxConnector tile) {
        ArrayList<FluxCacheTypes> valid = new ArrayList<FluxCacheTypes>();
        for (FluxCacheTypes handler : types) {
            if (!handler.clazz.isInstance(tile)) continue;
            valid.add(handler);
        }
        return valid;
    }
}

