/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.network;

import fluxnetworks.api.tiles.ITileByteBuf;
import fluxnetworks.common.handler.PacketHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketByteBuf
implements IMessageHandler<ByteBufMessage, IMessage> {
    public IMessage onMessage(ByteBufMessage message, MessageContext ctx) {
        ITileByteBuf tile;
        EntityPlayer player = PacketHandler.getPlayer(ctx);
        if (player != null && (tile = (ITileByteBuf)player.func_130014_f_().func_175625_s(message.pos)) != null) {
            PacketHandler.handlePacket(() -> {
                tile.readPacket(message.buf, message.id);
                message.buf.release();
            }, ctx.netHandler);
        }
        return null;
    }

    public static class ByteBufMessage
    implements IMessage {
        public ITileByteBuf tile;
        public BlockPos pos;
        public int id;
        public ByteBuf buf;

        public ByteBufMessage() {
        }

        public ByteBufMessage(ITileByteBuf tile, BlockPos pos, int id) {
            this.tile = tile;
            this.pos = pos;
            this.id = id;
        }

        public void fromBytes(ByteBuf buf) {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.id = buf.readInt();
            this.buf = buf.retain();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.pos.func_177958_n());
            buf.writeInt(this.pos.func_177956_o());
            buf.writeInt(this.pos.func_177952_p());
            buf.writeInt(this.id);
            this.tile.writePacket(buf, this.id);
        }
    }
}

