/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.tileentity;

import fluxnetworks.FluxConfig;
import fluxnetworks.api.network.EnumConnectionType;
import fluxnetworks.api.network.ITransferHandler;
import fluxnetworks.api.tiles.IFluxEnergy;
import fluxnetworks.api.tiles.IFluxStorage;
import fluxnetworks.api.utils.NBTType;
import fluxnetworks.common.connection.handler.SingleTransferHandler;
import fluxnetworks.common.connection.transfer.StorageTransfer;
import fluxnetworks.common.data.FluxNetworkData;
import fluxnetworks.common.registry.RegistryBlocks;
import fluxnetworks.common.tileentity.TileFluxCore;
import java.util.HashMap;
import li.cil.oc.api.machine.Arguments;
import mcjty.lib.api.power.IBigPower;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="mcjty.lib.api.power.IBigPower", modid="theoneprobe")
public class TileFluxStorage
extends TileFluxCore
implements IFluxStorage,
IFluxEnergy,
IBigPower {
    public final SingleTransferHandler handler = new SingleTransferHandler(this, new StorageTransfer(this));
    public static final int C = 1000000;
    public static final int D = -10000;
    public int energyStored;
    public int maxEnergyStorage;
    private boolean needSyncEnergy = false;
    public ItemStack stack = ItemStack.field_190927_a;

    public TileFluxStorage() {
        this(FluxConfig.basicCapacity);
        this.customName = "Basic Storage";
        this.limit = FluxConfig.basicTransfer;
        this.stack = new ItemStack(RegistryBlocks.FLUX_STORAGE_1);
    }

    private TileFluxStorage(int maxEnergyStorage) {
        this.maxEnergyStorage = maxEnergyStorage;
    }

    @Override
    public EnumConnectionType getConnectionType() {
        return EnumConnectionType.STORAGE;
    }

    @Override
    public ITransferHandler getTransferHandler() {
        return this.handler;
    }

    @Override
    public NBTTagCompound writeCustomNBT(NBTTagCompound tag, NBTType type) {
        super.writeCustomNBT(tag, type);
        tag.func_74768_a("energy", this.energyStored);
        return tag;
    }

    @Override
    public long addEnergy(long amount, boolean simulate) {
        long energyReceived = Math.min((long)(this.maxEnergyStorage - this.energyStored), amount);
        if (!simulate) {
            this.energyStored = (int)((long)this.energyStored + energyReceived);
            this.needSyncEnergy = true;
        }
        return energyReceived;
    }

    @Override
    public long removeEnergy(long amount, boolean simulate) {
        long energyExtracted = Math.min((long)this.energyStored, amount);
        if (!simulate) {
            this.energyStored = (int)((long)this.energyStored - energyExtracted);
            this.needSyncEnergy = true;
        }
        return energyExtracted;
    }

    public void sendPacketIfNeeded() {
        if (this.needSyncEnergy && (this.field_145850_b.func_72820_D() & 3L) == 0L) {
            this.sendPackets();
            this.needSyncEnergy = false;
        }
    }

    @Override
    public long getEnergy() {
        return this.energyStored;
    }

    @Override
    public long getCurrentLimit() {
        return this.disableLimit ? (long)this.maxEnergyStorage : Math.min(this.limit, (long)this.maxEnergyStorage);
    }

    @Override
    public int getPriority() {
        return this.surgeMode ? -10000 : Math.min(this.priority - 1000000, -10000);
    }

    @Override
    public long getMaxTransferLimit() {
        return this.maxEnergyStorage;
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag, NBTType type) {
        super.readCustomNBT(tag, type);
        this.energyStored = tag.func_74762_e("energy");
    }

    public ItemStack writeStorageToDisplayStack(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound subTag = new NBTTagCompound();
        subTag.func_74768_a("energy", this.energyStored);
        subTag.func_74768_a(FluxNetworkData.NETWORK_ID, this.networkID);
        tag.func_74782_a("FluxData", (NBTBase)subTag);
        tag.func_74757_a("GuiColor", true);
        stack.func_77982_d(tag);
        return stack;
    }

    @Override
    public ItemStack getDisplayStack() {
        return this.writeStorageToDisplayStack(this.stack);
    }

    @Optional.Method(modid="theoneprobe")
    public long getStoredPower() {
        return this.energyStored;
    }

    @Optional.Method(modid="theoneprobe")
    public long getCapacity() {
        return this.maxEnergyStorage;
    }

    @Override
    public String getPeripheralName() {
        return "flux_storage";
    }

    @Override
    public Object[] invokeMethods(String method, Arguments arguments) {
        if (method.equals("getFluxInfo")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("customName", this.customName);
            map.put("priority", this.priority);
            map.put("transferLimit", this.limit);
            map.put("surgeMode", this.surgeMode);
            map.put("unlimited", this.disableLimit);
            map.put("energyStored", this.getTransferHandler().getEnergyStored());
            map.put("maxStorage", this.maxEnergyStorage);
            return new Object[]{map};
        }
        return super.invokeMethods(method, arguments);
    }

    public static class Gargantuan
    extends TileFluxStorage {
        public Gargantuan() {
            super(FluxConfig.gargantuanCapacity);
            this.customName = "Gargantuan Storage";
            this.limit = FluxConfig.gargantuanTransfer;
            this.stack = new ItemStack(RegistryBlocks.FLUX_STORAGE_3);
        }
    }

    public static class Herculean
    extends TileFluxStorage {
        public Herculean() {
            super(FluxConfig.herculeanCapacity);
            this.customName = "Herculean Storage";
            this.limit = FluxConfig.herculeanTransfer;
            this.stack = new ItemStack(RegistryBlocks.FLUX_STORAGE_2);
        }
    }
}

