/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors;

import java.util.HashMap;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.IRegisterable;
import net.malisis.core.registry.MalisisRegistry;
import net.malisis.core.util.modmessage.ModMessage;
import net.malisis.doors.DoorRegistry;
import net.malisis.doors.block.Door;
import net.malisis.doors.item.DoorItem;
import net.malisis.doors.movement.IDoorMovement;
import net.malisis.doors.movement.RotatingDoorMovement;
import net.malisis.doors.sound.IDoorSound;
import net.malisis.doors.sound.WoodenDoorSound;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DoorDescriptor {
    protected Block block;
    protected Item item;
    protected Material material = Material.field_151575_d;
    protected float hardness = 3.0f;
    protected SoundType soundType = SoundType.field_185848_a;
    protected String registryName;
    protected String unlocalizedName;
    protected int autoCloseTime = 0;
    protected String modid;
    protected String textureName;
    protected Class<? extends DoorTileEntity> tileEntityClass = DoorTileEntity.class;
    protected IDoorMovement movement;
    protected IDoorSound sound;
    protected int openingTime = 6;
    protected boolean doubleDoor = true;
    protected boolean proximityDetection = false;
    protected RedstoneBehavior redstoneBehavior = RedstoneBehavior.STANDARD;
    protected CreativeTabs tab;
    protected int maxStackSize = 64;
    protected String code = null;

    public DoorDescriptor() {
        this.movement = DoorRegistry.getMovement(RotatingDoorMovement.class);
        this.sound = DoorRegistry.getSound(WoodenDoorSound.class);
    }

    public DoorDescriptor(NBTTagCompound nbt) {
        if (nbt != null) {
            this.readNBT(nbt);
        } else {
            this.movement = DoorRegistry.getMovement(RotatingDoorMovement.class);
            this.sound = DoorRegistry.getSound(WoodenDoorSound.class);
        }
    }

    public Block getBlock() {
        return this.block;
    }

    public Item getItem() {
        return this.item;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public float getHardness() {
        return this.hardness;
    }

    public void setHardness(float hardness) {
        this.hardness = hardness;
    }

    public SoundType getSoundType() {
        return this.soundType;
    }

    public void setSoundType(SoundType soundType) {
        this.soundType = soundType;
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public void setName(String name) {
        this.setRegistryName(name);
        this.setUnlocalizedName(name);
    }

    public void setRegistryName(String name) {
        this.registryName = name;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public void setUnlocalizedName(String name) {
        this.unlocalizedName = name;
    }

    public String getModId() {
        return this.modid;
    }

    public String getTextureName() {
        return this.textureName;
    }

    public void setTextureName(String modid, String textureName) {
        this.modid = modid;
        this.textureName = textureName;
    }

    public Class<? extends DoorTileEntity> getTileEntityClass() {
        return this.tileEntityClass;
    }

    public void setTileEntityClass(Class<? extends DoorTileEntity> clazz) {
        this.tileEntityClass = clazz;
    }

    public IDoorMovement getMovement() {
        return this.movement;
    }

    public void setMovement(IDoorMovement movement) {
        this.movement = movement;
    }

    public IDoorSound getSound() {
        return this.sound;
    }

    public void setSound(IDoorSound sound) {
        this.sound = sound;
    }

    public int getOpeningTime() {
        return this.openingTime;
    }

    public void setOpeningTime(int openingTime) {
        this.openingTime = openingTime;
    }

    public boolean isDoubleDoor() {
        return this.doubleDoor;
    }

    public void setDoubleDoor(boolean doubleDoor) {
        this.doubleDoor = doubleDoor;
    }

    public boolean hasProximityDetection() {
        return this.proximityDetection;
    }

    public void setProximityDetection(boolean proximity) {
        this.proximityDetection = proximity;
    }

    public RedstoneBehavior getRedstoneBehavior() {
        return this.redstoneBehavior;
    }

    public void setRedstoneBehavior(RedstoneBehavior redstoneBehavior) {
        this.redstoneBehavior = redstoneBehavior;
    }

    public int getAutoCloseTime() {
        return this.autoCloseTime;
    }

    public void setAutoCloseTime(int autoCloseTime) {
        this.autoCloseTime = autoCloseTime;
    }

    public CreativeTabs getTab() {
        return this.tab;
    }

    public void setTab(CreativeTabs tab) {
        this.tab = tab;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public boolean hasCode() {
        return !StringUtils.isEmpty((CharSequence)this.code);
    }

    public void readNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("name")) {
            this.registryName = nbt.func_74779_i("name");
        }
        if (nbt.func_74764_b("modid")) {
            this.modid = nbt.func_74779_i("modid");
        }
        if (nbt.func_74764_b("textureName")) {
            this.textureName = nbt.func_74779_i("textureName");
        }
        if (nbt.func_74764_b("hardness")) {
            this.hardness = nbt.func_74760_g("hardness");
        }
        if (nbt.func_74764_b("block")) {
            this.block = Block.func_149729_e((int)nbt.func_74762_e("block"));
        }
        if (nbt.func_74764_b("item")) {
            this.item = Item.func_150899_d((int)nbt.func_74762_e("item"));
        }
        if (nbt.func_74764_b("movement")) {
            this.setMovement(DoorRegistry.getMovement(nbt.func_74779_i("movement")));
        }
        if (nbt.func_74764_b("sound")) {
            this.setSound(DoorRegistry.getSound(nbt.func_74779_i("sound")));
        }
        if (nbt.func_74764_b("openingTime")) {
            this.setOpeningTime(nbt.func_74762_e("openingTime"));
        }
        if (nbt.func_74764_b("redstone")) {
            this.setRedstoneBehavior(nbt.func_74767_n("redstone") ? RedstoneBehavior.REDSTONE_ONLY : RedstoneBehavior.STANDARD);
        }
        if (nbt.func_74764_b("redstoneBehavior")) {
            this.setRedstoneBehavior(RedstoneBehavior.values()[nbt.func_74762_e("redstoneBehavior")]);
        }
        if (nbt.func_74764_b("doubleDoor")) {
            this.setDoubleDoor(nbt.func_74767_n("doubleDoor"));
        }
        if (nbt.func_74764_b("proximityDetection")) {
            this.setProximityDetection(nbt.func_74767_n("proximityDetection"));
        }
        if (nbt.func_74764_b("autoCloseTime")) {
            this.setAutoCloseTime(nbt.func_74762_e("autoCloseTime"));
        }
        if (nbt.func_74764_b("code")) {
            this.setCode(nbt.func_74779_i("code"));
        }
    }

    public void writeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("block", Block.func_149682_b((Block)this.block));
        nbt.func_74768_a("item", Item.func_150891_b((Item)this.item));
        if (this.getMovement() != null) {
            nbt.func_74778_a("movement", DoorRegistry.getId(this.getMovement()));
        }
        if (this.getSound() != null) {
            nbt.func_74778_a("sound", DoorRegistry.getId(this.getSound()));
        }
        nbt.func_74768_a("openingTime", this.getOpeningTime());
        nbt.func_74768_a("redstoneBehavior", this.getRedstoneBehavior().ordinal());
        nbt.func_74757_a("doubleDoor", this.isDoubleDoor());
        nbt.func_74757_a("proximityDetection", this.hasProximityDetection());
        nbt.func_74768_a("autoCloseTime", this.getAutoCloseTime());
        if (this.hasCode()) {
            nbt.func_74778_a("code", this.getCode());
        } else {
            nbt.func_82580_o("code");
        }
    }

    public void set(Block block, Item item) {
        this.block = block;
        this.item = item;
    }

    public void create() {
        this.block = new Door(this);
        this.item = new DoorItem(this);
    }

    public DoorDescriptor register() {
        if (this.block == null || this.item == null) {
            this.create();
        }
        if (this.block instanceof IRegisterable) {
            MalisisRegistry.register((IRegisterable)((IRegisterable)this.block));
        } else {
            ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this.block);
        }
        if (this.item instanceof IRegisterable) {
            MalisisRegistry.register((IRegisterable)((IRegisterable)this.item));
        } else {
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.item);
        }
        return this;
    }

    @ModMessage(value="createDoor")
    public static Pair<Block, Item> createDoor(HashMap<String, Object> map) {
        if (Loader.instance().getLoaderState() != LoaderState.PREINITIALIZATION) {
            MalisisCore.log.error("Tried to create and register a new door during wrong loader phase (was {}, expected {}).", (Object)Loader.instance().getLoaderState(), (Object)LoaderState.PREINITIALIZATION);
            return null;
        }
        DoorDescriptor desc = new DoorDescriptor();
        if (map.containsKey("name")) {
            desc.setRegistryName((String)map.get("name"));
        }
        if (map.containsKey("modid") && map.containsKey("textureName")) {
            desc.setTextureName((String)map.get("modid"), (String)map.get("textureName"));
        }
        if (map.containsKey("hardness")) {
            desc.setRegistryName((String)map.get("name"));
        }
        if (map.containsKey("movement")) {
            IDoorMovement mvt = DoorRegistry.getMovement((String)map.get("movement"));
            if (mvt.isSpecial()) {
                MalisisCore.log.error("{} is marked as 'special' and cannot be used for regular doors. Defaulting to 'rotating' movement", map.get("movement"));
                mvt = DoorRegistry.getMovement(RotatingDoorMovement.class);
            }
            desc.setMovement(mvt);
        }
        if (map.containsKey("sound")) {
            desc.setSound(DoorRegistry.getSound((String)map.get("sound")));
        }
        if (map.containsKey("openingTime")) {
            desc.setOpeningTime((Integer)map.get("openingTime"));
        }
        if (map.containsKey("redstoneBehavior")) {
            desc.setRedstoneBehavior(RedstoneBehavior.values()[(Integer)map.get("redstoneBehavior")]);
        }
        if (map.containsKey("doubleDoor")) {
            desc.setDoubleDoor((Boolean)map.get("doubleDoor"));
        }
        if (map.containsKey("proximityDetection")) {
            desc.setProximityDetection((Boolean)map.get("proximityDetection"));
        }
        if (map.containsKey("autoCloseTime")) {
            desc.setAutoCloseTime((Integer)map.get("autoCloseTime"));
        }
        if (map.containsKey("code")) {
            desc.setCode((String)map.get("code"));
        }
        if (map.containsKey("tab")) {
            desc.setTab((CreativeTabs)map.get("tab"));
        }
        desc.register();
        return Pair.of((Object)desc.getBlock(), (Object)desc.getItem());
    }

    public static enum RedstoneBehavior {
        STANDARD,
        REDSTONE_ONLY,
        REDSTONE_LOCK,
        HAND_ONLY;

    }
}

