/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment;

import baubles.api.BaublesApi;
import baubles.api.IBauble;
import com.bewitchment.Bewitchment;
import com.bewitchment.api.BewitchmentAPI;
import com.bewitchment.api.capability.extendedworld.ExtendedWorld;
import com.bewitchment.api.message.TeleportPlayerClient;
import com.bewitchment.api.registry.AltarUpgrade;
import com.bewitchment.api.registry.Contract;
import com.bewitchment.api.registry.Curse;
import com.bewitchment.common.block.BlockFrostfire;
import com.bewitchment.common.block.BlockGlyph;
import com.bewitchment.common.block.BlockHellfire;
import com.bewitchment.common.block.BlockPlacedItem;
import com.bewitchment.common.block.BlockSaltBarrier;
import com.bewitchment.common.block.BlockSigil;
import com.bewitchment.common.block.BlockStatue;
import com.bewitchment.common.block.plants.BlockSpanishMoss;
import com.bewitchment.common.block.tile.entity.TileEntityPlacedItem;
import com.bewitchment.common.block.tile.entity.TileEntityPoppetShelf;
import com.bewitchment.registry.ModObjects;
import com.bewitchment.registry.ModRegistries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Util {
    public static <T extends Block> void registerBlock(T block, String name, Material mat, SoundType sound, float hardness, float resistance, String tool, int level, String ... oreDictionaryNames) {
        ResourceLocation loc = new ResourceLocation("bewitchment", name);
        block.setRegistryName(loc);
        block.func_149663_c(loc.toString().replace(":", "."));
        block.func_149647_a(Bewitchment.tab);
        ObfuscationReflectionHelper.setPrivateValue(Block.class, block, (Object)sound, (String[])new String[]{"blockSoundType", "field_149762_H"});
        block.func_149711_c(hardness);
        block.func_149752_b(resistance);
        block.setHarvestLevel(tool, level);
        if (mat == Material.field_151593_r) {
            Blocks.field_150480_ab.func_180686_a(block, 60, 20);
        }
        if (mat == Material.field_151580_n || mat == Material.field_151584_j) {
            Blocks.field_150480_ab.func_180686_a(block, 30, 60);
        }
        if (mat == Material.field_151585_k) {
            Blocks.field_150480_ab.func_180686_a(block, 60, 100);
        }
        if (mat == Material.field_151590_u || mat == Material.field_151582_l) {
            Blocks.field_150480_ab.func_180686_a(block, 15, 100);
        }
        if (mat == Material.field_151575_d) {
            Blocks.field_150480_ab.func_180686_a(block, 5, 20);
        }
        if (mat == Material.field_151588_w) {
            block.setDefaultSlipperiness(0.98f);
        }
        if (!(block instanceof BlockPlacedItem || block instanceof BlockGlyph || block instanceof BlockFrostfire || block instanceof BlockSaltBarrier || block instanceof BlockCrops || block instanceof BlockDoor || block instanceof BlockSlab || block instanceof IFluidBlock || block instanceof BlockHellfire || block instanceof BlockSigil || block instanceof BlockStatue.BlockFiller || block instanceof BlockSpanishMoss && ((BlockSpanishMoss)block).isTerminalPiece())) {
            Item item = ((Item)new ItemBlock(block).setRegistryName(loc)).func_77655_b(block.func_149739_a());
            if (block instanceof BlockStatue) {
                Bewitchment.proxy.setStatueTEISR(item);
            }
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
            Bewitchment.proxy.registerTexture(item, block instanceof BlockBush || block instanceof BlockStatue ? "inventory" : "normal");
        }
        for (String ore : oreDictionaryNames) {
            OreDictionary.registerOre((String)ore, block);
        }
    }

    public static <T extends Block> void registerBlock(T block, String name, T base, String ... oreDictionaryNames) {
        Util.registerBlock(block, name, base.func_176223_P().func_185904_a(), base.func_185467_w(), base.func_176195_g(null, null, null), base.func_149638_a(null) * 5.0f, base.getHarvestTool(base.func_176223_P()), base.getHarvestLevel(base.func_176223_P()), oreDictionaryNames);
    }

    public static <T extends Item> T registerItem(T item, String name, List<Predicate<ItemStack>> predicates, String ... oreDictionaryNames) {
        ResourceLocation loc = new ResourceLocation("bewitchment", name);
        item.setRegistryName(loc);
        item.func_77655_b(loc.toString().replace(":", "."));
        item.func_77637_a(Bewitchment.tab);
        ModRegistries.MODEL_PREDICATES.put(item, predicates);
        ModRegistries.ORE_DICTIONARY_ENTRIES.put(item, oreDictionaryNames);
        return item;
    }

    public static Item registerItem(Item item, String name, String ... oreDictionaryNames) {
        return Util.registerItem(item, name, Arrays.asList(new Predicate[0]), oreDictionaryNames);
    }

    public static Item registerItem(String name, String ... oreDictionaryNames) {
        return Util.registerItem(new Item(), name, oreDictionaryNames);
    }

    public static EntityPlayer findPlayer(UUID uuid) {
        for (WorldServer ws : DimensionManager.getWorlds()) {
            EntityPlayer player = ws.func_152378_a(uuid);
            if (player == null) continue;
            return player;
        }
        return null;
    }

    public static EntityPlayer findPlayer(String uuid) {
        return Util.findPlayer(UUID.fromString(uuid));
    }

    public static Ingredient get(Object ... objects) {
        ArrayList<Ingredient> list = new ArrayList<Ingredient>();
        for (Object obj : objects) {
            if (obj instanceof String) {
                for (ItemStack stack : OreDictionary.getOres((String)((String)obj))) {
                    list.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack}));
                }
                continue;
            }
            if (obj instanceof ItemStack) {
                list.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)obj}));
                continue;
            }
            if (obj instanceof Item) {
                list.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)obj, 1, ((Item)obj).func_77645_m() ? Short.MAX_VALUE : 0)}));
                continue;
            }
            if (obj instanceof Block) {
                list.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)obj)}));
                continue;
            }
            throw new IllegalArgumentException(obj + " is not a valid parameter.");
        }
        return Ingredient.merge(list);
    }

    public static boolean areISListsEqual(List<Ingredient> ings, ItemStackHandler handler) {
        if (ings == null) {
            return false;
        }
        ArrayList<ItemStack> checklist = new ArrayList<ItemStack>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            checklist.add(stack);
        }
        if (ings.size() != checklist.size()) {
            return false;
        }
        for (Ingredient ing : ings) {
            boolean found = false;
            for (ItemStack stack : checklist) {
                if (!ing.apply(stack)) continue;
                found = true;
                checklist.remove(stack);
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean canMerge(ItemStack stack0, ItemStack stack1) {
        return stack0.func_190926_b() || OreDictionary.itemMatches((ItemStack)stack0, (ItemStack)stack1, (boolean)true) && stack0.func_190916_E() + stack1.func_190916_E() <= stack0.func_77976_d();
    }

    public static boolean hasBauble(EntityLivingBase living, IBauble item) {
        if (living instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)living;
            for (int i = 0; i < BaublesApi.getBaublesHandler((EntityPlayer)player).getSlots(); ++i) {
                if (BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(i).func_77973_b() != item) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRelated(boolean armor, Item item, String ... names) {
        for (String name : names) {
            if (armor) {
                if (!(item instanceof ItemArmor) || !((ItemArmor)item).func_82812_d().name().toLowerCase().contains(name)) continue;
                return true;
            }
            if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().toLowerCase().contains(name)) {
                return true;
            }
            if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().toLowerCase().contains(name)) {
                return true;
            }
            if (!(item instanceof ItemHoe) || !((ItemHoe)item).func_77842_f().toLowerCase().contains(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTransparent(IBlockState state) {
        return state.func_185904_a() == Material.field_151592_s || state.func_185904_a() == Material.field_151588_w;
    }

    public static int getArmorPieces(EntityLivingBase living, ItemArmor.ArmorMaterial mat) {
        int fin = 0;
        for (ItemStack stack : living.func_184193_aE()) {
            ItemArmor armor;
            if (!(stack.func_77973_b() instanceof ItemArmor) || (armor = (ItemArmor)stack.func_77973_b()).func_82812_d() != mat) continue;
            ++fin;
        }
        return fin;
    }

    public static void convertEntity(EntityLiving to, EntityLiving from) {
        if (!to.field_70170_p.field_72995_K && !to.field_70128_L) {
            from.func_70012_b(to.field_70165_t, to.field_70163_u, to.field_70161_v, to.field_70177_z, to.field_70125_A);
            from.func_94061_f(to.func_175446_cd());
            if (to.func_145818_k_()) {
                from.func_96094_a(to.func_95999_t());
                from.func_174805_g(to.func_174833_aM());
            }
            to.field_70170_p.func_72838_d((Entity)from);
            to.func_70106_y();
        }
    }

    public static void giveAndConsumeItem(EntityPlayer player, EnumHand hand, ItemStack stack) {
        Util.giveItem(player, stack);
        if (!player.func_184812_l_()) {
            player.func_184586_b(hand).func_190918_g(1);
        }
    }

    public static void replaceAndConsumeItem(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (!player.func_184812_l_()) {
            player.func_184586_b(hand).func_190918_g(1);
        }
        if (player.func_184586_b(hand).func_190926_b()) {
            player.func_184611_a(hand, stack);
        } else {
            Util.giveItem(player, stack);
        }
    }

    public static void giveItem(EntityPlayer player, ItemStack stack) {
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
        }
    }

    public static void teleportPlayer(EntityPlayer player, double x, double y, double z) {
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).field_71135_a.func_147364_a(x, y, z, player.field_70177_z, player.field_70125_A);
            Bewitchment.network.sendTo((IMessage)new TeleportPlayerClient(x, y, z), (EntityPlayerMP)player);
        }
    }

    public static boolean attemptDamagePoppet(EntityLivingBase entity, Item poppet) {
        World world = entity.func_130014_f_();
        ExtendedWorld ext = ExtendedWorld.get(world);
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack.func_77973_b() != poppet || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("boundId")) continue;
                String uuid = stack.func_77978_p().func_74779_i("boundId");
                if (!entity.func_110124_au().toString().equals(uuid)) continue;
                stack.func_77972_a(1, entity);
                if (stack.func_77952_i() == stack.func_77973_b().func_77612_l()) {
                    stack.func_77972_a(1, entity);
                }
                return true;
            }
        }
        for (NBTTagCompound poppetShelves : ext.storedPoppetShelves) {
            TileEntityPoppetShelf te;
            BlockPos pos = BlockPos.func_177969_a((long)poppetShelves.func_74763_f("position"));
            if (!(world.func_175625_s(pos) instanceof TileEntityPoppetShelf) || (te = (TileEntityPoppetShelf)world.func_175625_s(pos)) == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) continue;
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack itemStack = handler.getStackInSlot(slot);
                if (itemStack.func_77973_b() != poppet || !itemStack.func_77942_o() || !itemStack.func_77978_p().func_74764_b("boundId")) continue;
                String uuid = itemStack.func_77978_p().func_74779_i("boundId");
                if (!entity.func_110124_au().toString().equals(uuid)) continue;
                te.damageSlot(entity, slot);
                return true;
            }
        }
        return false;
    }

    public static ItemStack getRandomContract(Random rand) {
        List contracts = GameRegistry.findRegistry(Curse.class).getValuesCollection().stream().filter(c -> c instanceof Contract).collect(Collectors.toList());
        Contract contract = (Contract)((Object)contracts.get(rand.nextInt(contracts.size())));
        ItemStack itemstack = new ItemStack(ModObjects.contract);
        itemstack.func_77982_d(new NBTTagCompound());
        itemstack.func_77978_p().func_74778_a("contract", contract.getRegistryName().toString());
        int mobCount = rand.nextInt(5) + 6;
        if (contract.requiresEntities()) {
            itemstack.func_77978_p().func_74768_a("mobsTotal", mobCount);
        }
        if (contract.requiresEntities()) {
            itemstack.func_77978_p().func_74768_a("mobsComplete", 0);
        }
        if (contract.requiresItems()) {
            NBTTagList list = new NBTTagList();
            for (Item item : contract.items) {
                NBTTagCompound couple = new NBTTagCompound();
                int amount = 6 + rand.nextInt(6);
                if (item == Items.field_151131_as) {
                    amount = 1;
                }
                couple.func_74778_a("item", item.getRegistryName().toString());
                couple.func_74768_a("amountTotal", amount);
                couple.func_74768_a("amountComplete", 0);
                list.func_74742_a((NBTBase)couple);
            }
            itemstack.func_77978_p().func_74782_a("items", (NBTBase)list);
        }
        return itemstack;
    }

    public static void registerAltarUpgradeItemStack(ItemStack stack, AltarUpgrade upgrade) {
        BewitchmentAPI.ALTAR_UPGRADES.put(s -> s.func_177509_a().func_177230_c() == ModObjects.placed_item && s.func_177507_b() instanceof TileEntityPlacedItem && OreDictionary.itemMatches((ItemStack)stack, (ItemStack)((TileEntityPlacedItem)s.func_177507_b()).getInventories()[0].getStackInSlot(0), (boolean)stack.func_77981_g()), upgrade);
    }

    public static void registerAltarUpgradeItem(Item item, AltarUpgrade upgrade) {
        Util.registerAltarUpgradeItemStack(new ItemStack(item, 1, item.func_77645_m() ? Short.MAX_VALUE : 0), upgrade);
    }

    public static void registerAltarUpgradeOreDict(String ore, AltarUpgrade upgrade) {
        for (ItemStack stack : OreDictionary.getOres((String)ore)) {
            Util.registerAltarUpgradeItemStack(stack, upgrade);
        }
    }
}

