/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.block;

import com.bewitchment.api.capability.extendedworld.ExtendedWorld;
import com.bewitchment.common.block.tile.entity.TileEntityPoppetShelf;
import com.bewitchment.common.block.util.ModBlockContainer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockPoppetShelf
extends ModBlockContainer {
    private static final AxisAlignedBB BOX_S = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.25);
    private static final AxisAlignedBB BOX_E = new AxisAlignedBB(0.0, 0.0, 0.0, 0.25, 1.0, 1.0);
    private static final AxisAlignedBB BOX_N = new AxisAlignedBB(0.0, 0.0, 1.0, 1.0, 1.0, 0.75);
    private static final AxisAlignedBB BOX_W = new AxisAlignedBB(1.0, 0.0, 0.0, 0.75, 1.0, 1.0);

    public BlockPoppetShelf(String type) {
        super(null, "poppet_shelf_" + type, Blocks.field_150344_f, -1);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityPoppetShelf();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.field_176754_o[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176736_b();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        switch (((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176736_b()) {
            case 0: {
                return BOX_S;
            }
            case 1: {
                return BOX_W;
            }
            case 2: {
                return BOX_N;
            }
            case 3: {
                return BOX_E;
            }
        }
        return null;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockHorizontal.field_185512_D});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase living, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.func_176733_a((double)living.field_70177_z).func_176734_d());
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityPoppetShelf) {
            TileEntityPoppetShelf tile = (TileEntityPoppetShelf)world.func_175625_s(pos);
            IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            }
            ExtendedWorld ext = ExtendedWorld.get(world);
            for (NBTTagCompound poppet : ext.storedPoppetShelves) {
                if (poppet.func_74762_e("dimension") != world.field_73011_w.getDimension() || poppet.func_74763_f("position") != pos.func_177986_g()) continue;
                ext.storedPoppetShelves.remove(poppet);
                ext.func_76185_a();
                break;
            }
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        int gridPos = this.getGridPosition(state, hitX, hitY, hitZ);
        if (!world.field_72995_K && hand == EnumHand.MAIN_HAND && world.func_175625_s(pos) instanceof TileEntityPoppetShelf) {
            TileEntityPoppetShelf tile = (TileEntityPoppetShelf)world.func_175625_s(pos);
            tile.interact(player, gridPos);
        }
        return true;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        NBTTagCompound poppet = new NBTTagCompound();
        poppet.func_74772_a("position", pos.func_177986_g());
        poppet.func_74768_a("dimension", placer.field_71093_bK);
        ExtendedWorld ext = ExtendedWorld.get(world);
        ext.storedPoppetShelves.add(poppet);
        ext.func_76185_a();
        super.func_180633_a(world, pos, state, placer, stack);
    }

    private int getGridPosition(IBlockState state, float hitX, float hitY, float hitZ) {
        int[][] GRID = new int[][]{{6, 7, 8}, {3, 4, 5}, {0, 1, 2}};
        float x = 0.0f;
        float y = 0.0f;
        switch (((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176736_b()) {
            case 0: {
                x = hitX;
                y = hitY;
                break;
            }
            case 2: {
                x = 1.0f - hitX;
                y = hitY;
                break;
            }
            case 1: {
                x = hitZ;
                y = hitY;
                break;
            }
            case 3: {
                x = 1.0f - hitZ;
                y = hitY;
            }
        }
        int xPos = (int)Math.floor((double)x * 3.0);
        int yPos = (int)Math.floor((double)y * 3.0);
        if (xPos >= 2) {
            xPos = 2;
        }
        if (yPos >= 2) {
            yPos = 2;
        }
        return GRID[yPos][xPos];
    }
}

