/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.handler;

import com.bewitchment.registry.ModObjects;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BlockDropHandler {
    private static int getFortuneDropAmount(Random rand, int fortuneLevel) {
        return fortuneLevel > 0 ? Math.max(1, rand.nextInt(fortuneLevel + 2)) : 1;
    }

    public static void replaceDrop(BlockEvent.HarvestDropsEvent event, Predicate<IBlockState> predicate, ItemStack out, int chance, int replaceFlag, boolean ignoreSilkTouch) {
        if (predicate.test(event.getState()) && (ignoreSilkTouch || !event.isSilkTouching())) {
            if (replaceFlag == 1) {
                event.getDrops().clear();
            }
            if (event.getWorld().field_73012_v.nextInt(100) < chance) {
                if (replaceFlag == 2) {
                    event.getDrops().clear();
                }
                event.getDrops().add(out);
            }
        }
    }

    @SubscribeEvent
    public void harvestDrops(BlockEvent.HarvestDropsEvent event) {
        BlockDropHandler.replaceDrop(event, s -> s.func_177230_c() == ModObjects.elder_leaves, new ItemStack(ModObjects.elderberries), 2, 0, false);
        BlockDropHandler.replaceDrop(event, s -> s.func_177230_c() == ModObjects.juniper_leaves, new ItemStack(ModObjects.juniper_berries), 2, 0, false);
        BlockDropHandler.replaceDrop(event, s -> s.func_177230_c() == Blocks.field_150330_I, new ItemStack(ModObjects.white_sage_seeds), 15, 2, false);
        BlockDropHandler.replaceDrop(event, s -> s.func_177230_c() == Blocks.field_150328_O && s.func_177229_b(Blocks.field_150328_O.func_176494_l()) == BlockFlower.EnumFlowerType.ALLIUM, new ItemStack(ModObjects.garlic_seeds), 15, 2, false);
        BlockDropHandler.replaceDrop(event, s -> s.func_177230_c() == Blocks.field_150362_t && s.func_177229_b((IProperty)BlockOldLeaf.field_176239_P) == BlockPlanks.EnumType.OAK || s.func_177230_c() == Blocks.field_150361_u && s.func_177229_b((IProperty)BlockNewLeaf.field_176240_P) == BlockPlanks.EnumType.DARK_OAK, new ItemStack(ModObjects.oak_apple_gall), 2, 0, false);
    }
}

