/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.integration.dynamictrees;

import com.bewitchment.ModConfig;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeDataBasePopulator
implements IBiomeDataBasePopulator {
    private static Species cypress;
    private static Species elder;
    private static Species juniper;

    private static void createStaticAliases() {
        cypress = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("bewitchment", "cypress"));
        elder = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("bewitchment", "elder"));
        juniper = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("bewitchment", "juniper"));
    }

    public void populate(BiomeDataBase dbase) {
        if (cypress == null) {
            BiomeDataBasePopulator.createStaticAliases();
        }
        int cypressWeight = (int)(ModConfig.worldGen.treeGen.cypressChance * 500.0);
        int elderWeight = (int)(ModConfig.worldGen.treeGen.elderChance * 500.0);
        int juniperWeight = (int)(ModConfig.worldGen.treeGen.juniperChance * 500.0);
        BiomePropertySelectors.RandomSpeciesSelector cypressSelector = cypressWeight == 0 ? null : new BiomePropertySelectors.RandomSpeciesSelector().add(1000 - cypressWeight).add(cypress, cypressWeight);
        BiomePropertySelectors.RandomSpeciesSelector elderSelector = elderWeight == 0 ? null : new BiomePropertySelectors.RandomSpeciesSelector().add(1000 - elderWeight).add(elder, elderWeight);
        BiomePropertySelectors.RandomSpeciesSelector juniperSelector = juniperWeight == 0 ? null : new BiomePropertySelectors.RandomSpeciesSelector().add(1000 - juniperWeight).add(juniper, juniperWeight);
        Biome.field_185377_q.forEach(b -> {
            boolean juniperSplice;
            boolean cypressSplice = cypressSelector != null && BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && (BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY));
            boolean elderSplice = elderSelector != null && BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && !BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.COLD);
            boolean bl = juniperSplice = juniperSelector != null && (BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA) || BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL));
            if (cypressSplice || elderSplice || juniperSplice) {
                dbase.setSpeciesSelector(b, (BiomePropertySelectors.ISpeciesSelector)(cypressSplice ? cypressSelector : (elderSplice ? elderSelector : juniperSelector)), BiomeDataBase.Operation.SPLICE_BEFORE);
            }
        });
    }
}

