/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.integration.dynamictrees;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.systems.dropcreators.DropCreator;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DropCreatorFruit
extends DropCreator {
    private final Item fruit;
    private final int chance;

    public DropCreatorFruit(Item item, int chance) {
        super(new ResourceLocation("bewitchment", item.getRegistryName().func_110623_a()));
        this.fruit = item;
        this.chance = chance;
    }

    public List<ItemStack> getHarvestDrop(World world, Species species, BlockPos leafPos, Random random, List<ItemStack> dropList, int soilLife, int fortune) {
        return this.getLeafDrops((IBlockAccess)world, species, leafPos, random, dropList, fortune);
    }

    public List<ItemStack> getVoluntaryDrop(World world, Species species, BlockPos rootPos, Random random, List<ItemStack> dropList, int soilLife) {
        BlockPos treePos = rootPos.func_177984_a();
        IBlockState trunk = world.func_180495_p(treePos);
        BlockBranch branch = TreeHelper.getBranch((IBlockState)trunk);
        if (branch != null && branch.getRadius(trunk) >= 8 && 0.33f > random.nextFloat()) {
            dropList.add(new ItemStack(this.fruit, 1, 0));
        }
        return dropList;
    }

    public List<ItemStack> getLeavesDrop(IBlockAccess access, Species species, BlockPos breakPos, Random random, List<ItemStack> dropList, int fortune) {
        return this.getLeafDrops(access, species, breakPos, random, dropList, fortune);
    }

    protected List<ItemStack> getLeafDrops(IBlockAccess access, Species species, BlockPos leafPos, Random random, List<ItemStack> dropList, int fortune) {
        int chance = this.chance;
        if (fortune > 0 && (chance -= fortune) < 2) {
            chance = 2;
        }
        if (random.nextInt(chance) == 0) {
            dropList.add(new ItemStack(this.fruit, 1, 0));
        }
        return dropList;
    }
}

