/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.integration.dynamictrees;

import com.bewitchment.common.integration.dynamictrees.DynamicTreesCompat;
import com.bewitchment.registry.ModObjects;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.growthlogic.ConiferLogic;
import com.ferreusveritas.dynamictrees.growthlogic.IGrowthLogicKit;
import com.ferreusveritas.dynamictrees.systems.dropcreators.DropCreatorSeed;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenClearVolume;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TreeCypress
extends TreeFamily {
    private final BlockSurfaceRoot surfaceRootBlock;

    public TreeCypress() {
        super(new ResourceLocation("bewitchment", "cypress"));
        IBlockState primLog = ModObjects.cypress_wood.func_176223_P();
        this.setPrimitiveLog(primLog, new ItemStack(ModObjects.cypress_wood));
        DynamicTreesCompat.cypressLeavesProperties.setTree((TreeFamily)this);
        this.surfaceRootBlock = new BlockSurfaceRoot(Material.field_151575_d, this.getName() + "root");
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesCypress(this));
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add((Block)this.surfaceRootBlock);
        return super.getRegisterableBlocks(blockList);
    }

    public boolean isThick() {
        return false;
    }

    public BlockSurfaceRoot getSurfaceRoots() {
        return this.surfaceRootBlock;
    }

    public class SpeciesCypress
    extends Species {
        SpeciesCypress(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, DynamicTreesCompat.cypressLeavesProperties);
            this.setBasicGrowingParameters(0.3f, 14.0f, 4, 4, 1.0f);
            this.setGrowthLogicKit((IGrowthLogicKit)new ConiferLogic(6.0f).setHorizontalLimiter(1.6f).setHeightVariation(4));
            this.envFactor(BiomeDictionary.Type.COLD, 1.05f);
            this.envFactor(BiomeDictionary.Type.CONIFEROUS, 1.05f);
            this.generateSeed();
            this.addDropCreator((IDropCreator)new DropCreatorSeed(5.0f));
            this.addGenFeature((IGenFeature)new FeatureGenClearVolume(6));
        }

        public boolean isThick() {
            return false;
        }

        public boolean isBiomePerfect(Biome biome) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST);
        }
    }
}

