/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.world;

import com.bewitchment.Bewitchment;
import com.bewitchment.api.capability.extendedworld.ExtendedWorld;
import com.bewitchment.common.network.PacketChangeBiome;
import com.google.common.collect.HashMultimap;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BiomeChangingUtils {
    public static void setMultiBiome(World world, Biome biome, BlockPos ... poses) {
        byte id = (byte)Biome.func_185362_a((Biome)biome);
        HashMultimap changes = HashMultimap.create();
        for (BlockPos blockPos : poses) {
            changes.put((Object)new ChunkPos(blockPos), (Object)blockPos);
        }
        for (BlockPos blockPos : changes.keySet().toArray(new ChunkPos[changes.keySet().size()])) {
            Chunk chunk = world.func_72964_e(blockPos.field_77276_a, blockPos.field_77275_b);
            byte[] biomeArray = chunk.func_76605_m();
            Set changeSet = changes.get((Object)blockPos);
            Iterator iterator = changeSet.iterator();
            while (iterator.hasNext()) {
                BlockPos pos = (BlockPos)iterator.next();
                int i = pos.func_177958_n() & 0xF;
                int j = pos.func_177952_p() & 0xF;
                if (biomeArray[j << 4 | i] == id) {
                    iterator.remove();
                    continue;
                }
                biomeArray[j << 4 | i] = id;
            }
        }
    }

    public static void resetRandomOverriddenBiome(World world) {
        ExtendedWorld extendedWorld = ExtendedWorld.get(world);
        BlockPos randomPos = extendedWorld.STORED_OVERRIDE_BIOMES.keySet().toArray(new BlockPos[extendedWorld.STORED_OVERRIDE_BIOMES.size()])[world.field_73012_v.nextInt(extendedWorld.STORED_OVERRIDE_BIOMES.size())];
        BiomeChangingUtils.setBiome(world, extendedWorld.STORED_OVERRIDE_BIOMES.get(randomPos), randomPos);
        extendedWorld.STORED_OVERRIDE_BIOMES.remove(randomPos);
        extendedWorld.func_76186_a(true);
    }

    public static void setBiome(World world, Biome biome, BlockPos pos) {
        int chunkZ;
        int chunkX;
        PlayerChunkMap playerChunkMap;
        PlayerChunkMapEntry entry;
        Chunk chunk = world.func_175726_f(pos);
        int i = pos.func_177958_n() & 0xF;
        int j = pos.func_177952_p() & 0xF;
        byte id = (byte)Biome.func_185362_a((Biome)biome);
        byte b = chunk.func_76605_m()[j << 4 | i];
        if (b == id) {
            return;
        }
        chunk.func_76605_m()[j << 4 | i] = id;
        chunk.func_76630_e();
        if (world instanceof WorldServer && (entry = (playerChunkMap = ((WorldServer)world).func_184164_w()).func_187301_b(chunkX = pos.func_177958_n() >> 4, chunkZ = pos.func_177952_p() >> 4)) != null) {
            Bewitchment.network.sendToAll((IMessage)new PacketChangeBiome(biome, pos));
        }
    }
}

