/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2;

import com.someguyssoftware.dungeons2.builder.DungeonBuilderTopDown;
import com.someguyssoftware.dungeons2.builder.LevelBuilder;
import com.someguyssoftware.dungeons2.graph.Wayline;
import com.someguyssoftware.dungeons2.model.Dungeon;
import com.someguyssoftware.dungeons2.model.DungeonConfig;
import com.someguyssoftware.dungeons2.model.Level;
import com.someguyssoftware.dungeons2.model.LevelConfig;
import com.someguyssoftware.dungeons2.model.Room;
import com.someguyssoftware.gottschcore.Quantity;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.List;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class LevelVisualizer {
    private static final Logger logger = LogManager.getLogger(LevelVisualizer.class);
    DungeonBuilderTopDown dungeonBuilder = new DungeonBuilderTopDown();
    LevelBuilder builder = new LevelBuilder();
    LevelConfig config = new LevelConfig();
    long seed = new Random().nextInt(10000) - 5000;
    ICoords startPoint = new Coords(500, 100, 500);
    static LevelVisualizer test;

    public static void main(String[] args) {
        logger.info("Starting...");
        test = new LevelVisualizer();
        if (args.length == 1) {
            LevelVisualizer.test.seed = Long.valueOf(args[0]);
        }
        Random random = new Random(LevelVisualizer.test.seed);
        LevelVisualizer.test.config.setNumberOfRooms(new Quantity(25.0, 50.0));
        double factor = 3.2;
        LevelVisualizer.test.config.setWidth(new Quantity(7.0 * factor, 15.0 * factor));
        LevelVisualizer.test.config.setDepth(new Quantity(7.0 * factor, 15.0 * factor));
        LevelVisualizer.test.config.setHeight(new Quantity(7.0, 6.0));
        LevelVisualizer.test.config.setDegrees(new Quantity(2.0, 4.0));
        LevelVisualizer.test.config.setXDistance(new Quantity(-(60.0 * factor) * 0.6, 60.0 * factor * 1.4));
        LevelVisualizer.test.config.setZDistance(new Quantity(-5.0 * factor, 5.0 * factor));
        int r = RandomHelper.randomInt((int)15, (int)25);
        LevelVisualizer.test.config.setYVariance(new Quantity(0.0, 0.0));
        LevelVisualizer.test.config.setMinecraftConstraintsOn(false);
        LevelVisualizer.test.config.setSupportOn(false);
        LevelVisualizer.test.builder.setConfig(LevelVisualizer.test.config);
        LevelVisualizer.test.dungeonBuilder.setLevelBuilder(LevelVisualizer.test.builder);
        DungeonConfig dConfig = new DungeonConfig();
        dConfig.setUseSupport(false);
        dConfig.setNumberOfLevels(new Quantity(1.0, 1.0));
        Level level = null;
        Dungeon dungeon = null;
        if (dungeon == DungeonBuilderTopDown.EMPTY_DUNGEON) {
            logger.warn("Empty Dungeon");
            return;
        }
        level = dungeon.getLevels().get(0);
        JFrame window = new JFrame();
        LevelVisualizer levelVisualizer = new LevelVisualizer();
        levelVisualizer.getClass();
        Me panel = levelVisualizer.new Me(level);
        window.setDefaultCloseOperation(3);
        window.setBounds(0, 0, 1000, 1000);
        window.add(panel);
        window.setVisible(true);
    }

    class Me
    extends JPanel {
        List<Room> rooms;
        Level level;

        public Me(Level level) {
            this.rooms = level.getRooms();
            this.level = level;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g.create();
            RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            rh.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHints(rh);
            g2d.setFont(new Font("Verdana", 1, 14));
            String title = "Dungeons2! Level Visualizer";
            g2d.drawString(title, 200, 15);
            g2d.setFont(new Font("Verdana", 1, 10));
            g2d.drawString("Config Properties", 10, 10);
            g2d.setFont(new Font("Verdana", 0, 9));
            g2d.setColor(Color.BLACK);
            g2d.drawString("# of Rooms: " + LevelVisualizer.test.config.getNumberOfRooms().getMinInt() + " to " + LevelVisualizer.test.config.getNumberOfRooms().getMaxInt(), 10, 20);
            g2d.drawString("Width (X): " + LevelVisualizer.test.config.getWidth().getMinInt() + " to " + LevelVisualizer.test.config.getWidth().getMaxInt(), 10, 30);
            g2d.drawString("Height (Y): " + LevelVisualizer.test.config.getHeight().getMinInt() + " to " + LevelVisualizer.test.config.getHeight().getMaxInt(), 10, 40);
            g2d.drawString("Depth (Z): " + LevelVisualizer.test.config.getDepth().getMinInt() + " to " + LevelVisualizer.test.config.getDepth().getMaxInt(), 10, 50);
            g2d.drawString("XDistance: " + LevelVisualizer.test.config.getXDistance().getMinInt() + " to " + LevelVisualizer.test.config.getXDistance().getMaxInt(), 10, 60);
            g2d.drawString("ZDistance: " + LevelVisualizer.test.config.getZDistance().getMinInt() + " to " + LevelVisualizer.test.config.getZDistance().getMaxInt(), 10, 70);
            g2d.drawString("YVariance: " + LevelVisualizer.test.config.getYVariance().getMinInt() + " to " + LevelVisualizer.test.config.getYVariance().getMaxInt(), 10, 100);
            g2d.drawString("Random Seed: " + LevelVisualizer.test.seed, 10, 120);
            g2d.drawString("Start Point: " + this.level.getStartPoint().toShortString(), 10, 130);
            g2d.setFont(new Font("Verdana", 1, 10));
            g2d.drawString("Generated Properties", 10, 150);
            g2d.setFont(new Font("Verdana", 0, 9));
            g2d.drawString("# of Rooms: " + this.level.getRooms().size(), 10, 160);
            g2d.setColor(Color.BLACK);
            g2d.fillRoundRect(10, 440, 10, 10, 3, 3);
            g2d.setColor(Color.CYAN);
            g2d.fillRoundRect(10, 452, 10, 10, 3, 3);
            g2d.setColor(Color.YELLOW);
            g2d.fillRoundRect(10, 464, 10, 10, 3, 3);
            g2d.setColor(Color.MAGENTA);
            g2d.fillRoundRect(10, 476, 10, 10, 3, 3);
            g2d.setColor(Color.RED);
            g2d.fillRoundRect(10, 488, 10, 10, 3, 3);
            g2d.setColor(Color.BLACK);
            g2d.drawString("y = base", 23, 447);
            g2d.drawString("y = +1", 23, 459);
            g2d.drawString("y = +2", 23, 471);
            g2d.drawString("y = +3", 23, 483);
            g2d.drawString("y = >+3", 23, 495);
            g2d.drawLine(10, 200, 10, 400);
            g2d.drawLine(200, 500, 400, 500);
            g2d.drawString("-100", 12, 200);
            g2d.drawString("0", 12, 300);
            g2d.drawString("100", 12, 400);
            g2d.drawString("-100", 200, 510);
            g2d.drawString("0", 300, 510);
            g2d.drawString("100", 400, 510);
            g2d.drawOval(495, 495, 10, 10);
            List<Room> rooms = this.level.getRooms();
            for (Room room : rooms) {
                if (room.isStart()) {
                    g2d.setColor(Color.GREEN);
                } else if (room.isEnd()) {
                    g2d.setColor(Color.RED);
                } else {
                    g2d.setColor(new Color(130, 100, 84));
                }
                g2d.fillRoundRect(room.getCoords().getX(), room.getCoords().getZ(), room.getWidth(), room.getDepth(), 3, 3);
                if (room.getCoords().getY() == LevelVisualizer.this.startPoint.getY()) {
                    g2d.setColor(Color.BLACK);
                } else if (room.getCoords().getY() == LevelVisualizer.this.startPoint.getY() + 1) {
                    g2d.setColor(Color.CYAN);
                } else if (room.getCoords().getY() == LevelVisualizer.this.startPoint.getY() + 2) {
                    g2d.setColor(Color.YELLOW);
                } else if (room.getCoords().getY() == LevelVisualizer.this.startPoint.getY() + 3) {
                    g2d.setColor(Color.MAGENTA);
                } else {
                    g2d.setColor(Color.RED);
                }
                g2d.drawRoundRect(room.getCoords().getX(), room.getCoords().getZ(), room.getWidth(), room.getDepth(), 3, 3);
                g2d.setColor(Color.BLACK);
                g2d.drawString(String.valueOf(room.getId()), room.getCoords().getX() + 3, room.getCoords().getZ() + 11);
                g2d.setColor(Color.WHITE);
                g2d.drawString(String.valueOf(room.getId()), room.getCoords().getX() + 2, room.getCoords().getZ() + 10);
                g2d.setColor(Color.BLACK);
                g2d.drawString(String.valueOf(room.getDegrees()), room.getCoords().getX() + 3, room.getCoords().getZ() + 23);
                g2d.setColor(Color.CYAN);
                g2d.drawString(String.valueOf(room.getDegrees()), room.getCoords().getX() + 2, room.getCoords().getZ() + 22);
            }
            g2d.setColor(Color.BLUE);
            for (Wayline w : this.level.getWaylines()) {
                g2d.drawLine(w.getPoint1().getX(), w.getPoint1().getZ(), w.getPoint2().getX(), w.getPoint2().getZ());
            }
        }
    }
}

