/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.style.Alias;
import com.someguyssoftware.dungeons2.style.Frame;
import com.someguyssoftware.dungeons2.style.Layout;
import com.someguyssoftware.dungeons2.style.Style;
import com.someguyssoftware.dungeons2.style.StyleSheet;
import com.someguyssoftware.dungeons2.style.Theme;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class StyleTester {
    public static void main(String[] args) {
        GsonBuilder builder = new GsonBuilder();
        Type themeType = new TypeToken<Map<String, Theme>>(){}.getType();
        builder.registerTypeAdapter(themeType, (Object)new ThemeDeserializer());
        Type styleType = new TypeToken<Map<String, Style>>(){}.getType();
        builder.registerTypeAdapter(styleType, (Object)new StyleDeserializer());
        Type layoutType = new TypeToken<Map<String, Layout>>(){}.getType();
        builder.registerTypeAdapter(layoutType, (Object)new LayoutDeserializer());
        JsonSerializer<Theme> themeSerializer = new JsonSerializer<Theme>(){

            public JsonElement serialize(Theme src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject themeObj = new JsonObject();
                JsonObject aliasMapObj = new JsonObject();
                for (Map.Entry<String, Alias> entry : src.getAliases().entrySet()) {
                    JsonObject aliasObj = new JsonObject();
                    aliasObj.addProperty("style", entry.getValue().getStyle());
                    aliasMapObj.add(entry.getKey(), (JsonElement)aliasObj);
                }
                themeObj.add("aliases", (JsonElement)aliasMapObj);
                return themeObj;
            }
        };
        JsonSerializer<Style> styleSerializer = new JsonSerializer<Style>(){

            public JsonElement serialize(Style src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject styleObj = new JsonObject();
                styleObj.addProperty("block", src.getBlock());
                styleObj.addProperty("category", src.getCategory());
                styleObj.addProperty("decay", (Number)src.getDecay());
                JsonArray blockArray = new JsonArray();
                for (String s : src.getDecayBlocks()) {
                    blockArray.add((JsonElement)new JsonPrimitive(s));
                }
                styleObj.add("decayBlocks", (JsonElement)blockArray);
                return styleObj;
            }
        };
        JsonSerializer<Layout> layoutSerializer = new JsonSerializer<Layout>(){

            public JsonElement serialize(Layout src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject obj = new JsonObject();
                obj.addProperty("ref", src.getRef());
                obj.addProperty("category", src.getCategory());
                obj.addProperty("useAll", Boolean.valueOf(src.isUseAll()));
                obj.addProperty("__comment", src.getComment());
                Type frameType = new TypeToken<Map<String, Frame>>(){}.getType();
                JsonElement frames = context.serialize(src.getFrames(), frameType);
                obj.add("frames", frames);
                return obj;
            }
        };
        builder.registerTypeAdapter(Theme.class, (Object)themeSerializer);
        builder.registerTypeAdapter(Style.class, (Object)styleSerializer);
        builder.registerTypeAdapter(Layout.class, (Object)layoutSerializer);
        builder.setPrettyPrinting();
        Gson gson = builder.create();
        InputStream is = ((Object)((Object)Dungeons2.instance)).getClass().getResourceAsStream("/resources/stylesheet2.json");
        InputStreamReader r = new InputStreamReader(is);
        JsonReader reader = null;
        try {
            reader = new JsonReader((Reader)r);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StyleSheet sheet0 = (StyleSheet)gson.fromJson(reader, StyleSheet.class);
        System.out.println("sheet0: " + sheet0);
        String json = gson.toJson((Object)sheet0);
        System.out.println("json: " + json);
    }

    public static class LayoutDeserializer
    implements JsonDeserializer<Map<String, Layout>> {
        public Map<String, Layout> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            HashMap<String, Layout> map = new HashMap<String, Layout>();
            JsonObject jsonObj = json.getAsJsonObject();
            for (Map.Entry entry : jsonObj.entrySet()) {
                JsonObject element = ((JsonElement)entry.getValue()).getAsJsonObject();
                Layout layout = new Layout();
                layout.setName((String)entry.getKey());
                if (element.get("ref") != null) {
                    layout.setRef(element.get("ref").getAsString());
                }
                if (element.get("category") != null) {
                    layout.setCategory(element.get("category").getAsString());
                }
                if (element.get("useAll") != null) {
                    layout.setUseAll(element.get("useAll").getAsBoolean());
                }
                if (element.get("__comment") != null) {
                    layout.setComment(element.get("__comment").getAsString());
                }
                JsonObject frameMap = element.get("frames").getAsJsonObject();
                HashMap<String, Frame> frames = new HashMap<String, Frame>();
                for (Map.Entry frameEntry : frameMap.entrySet()) {
                    JsonObject frameElement = ((JsonElement)frameEntry.getValue()).getAsJsonObject();
                    Frame frame = (Frame)context.deserialize((JsonElement)frameElement, Frame.class);
                    frames.put((String)frameEntry.getKey(), frame);
                }
                layout.setFrames(frames);
                map.put(layout.getName(), layout);
            }
            return map;
        }
    }

    public static class StyleDeserializer
    implements JsonDeserializer<Map<String, Style>> {
        public Map<String, Style> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            HashMap<String, Style> map = new HashMap<String, Style>();
            JsonObject jsonObj = json.getAsJsonObject();
            for (Map.Entry entry : jsonObj.entrySet()) {
                JsonObject element = ((JsonElement)entry.getValue()).getAsJsonObject();
                Style style = new Style();
                style.setName((String)entry.getKey());
                style.setCategory(element.get("category").getAsString());
                style.setBlock(element.get("block").getAsString());
                style.setDecay(element.get("decay").getAsDouble());
                JsonArray array = element.getAsJsonArray("decayBlocks");
                ArrayList<String> blocks = new ArrayList<String>();
                for (JsonElement e : array) {
                    blocks.add(e.getAsString());
                }
                style.setDecayBlocks(blocks);
                map.put((String)entry.getKey(), style);
            }
            return map;
        }
    }

    public static class ThemeDeserializer
    implements JsonDeserializer<Map<String, Theme>> {
        public Map<String, Theme> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            HashMap<String, Theme> map = new HashMap<String, Theme>();
            JsonObject jsonObj = json.getAsJsonObject();
            for (Map.Entry entry : jsonObj.entrySet()) {
                JsonObject element = ((JsonElement)entry.getValue()).getAsJsonObject();
                Theme theme = new Theme();
                theme.setName((String)entry.getKey());
                JsonObject aliasMap = element.get("aliases").getAsJsonObject();
                HashMap<String, Alias> aliases = new HashMap<String, Alias>();
                for (Map.Entry aliasEntry : aliasMap.entrySet()) {
                    JsonObject aliasElement = ((JsonElement)aliasEntry.getValue()).getAsJsonObject();
                    Alias alias = new Alias();
                    alias.setAlias((String)aliasEntry.getKey());
                    alias.setStyle(aliasElement.get("style").getAsString());
                    aliases.put(alias.getAlias(), alias);
                }
                theme.setAliases(aliases);
                map.put((String)entry.getKey(), theme);
            }
            return map;
        }
    }
}

