/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;

public class UpdateBlockStateJson {
    public static void main(String[] args) {
        GsonBuilder builder = new GsonBuilder();
        builder.disableHtmlEscaping();
        builder.setPrettyPrinting();
        Gson gson = builder.create();
        Wrapper wrapper = null;
        UpdateBlockStateJson x = new UpdateBlockStateJson();
        boolean i = false;
        boolean addUp = false;
        boolean addDown = false;
        String filepath = "E:/Development/workspace/mars/Dungeons2-194/src/resources/assets/dungeons2/blockstates";
        File dir = new File(filepath);
        File[] directoryListing = dir.listFiles();
        if (directoryListing != null) {
            for (File child : directoryListing) {
                if (child.isDirectory()) continue;
                System.out.println("File:" + child.getAbsolutePath());
                JsonReader reader = null;
                try {
                    reader = new JsonReader((Reader)new FileReader(child));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                wrapper = (Wrapper)gson.fromJson(reader, Wrapper.class);
                if (wrapper.getVariants().containsKey("facing=north")) {
                    if (!wrapper.getVariants().containsKey("facing=up")) {
                        addUp = true;
                    }
                    if (!wrapper.getVariants().containsKey("facing=down")) {
                        addDown = true;
                    }
                }
                if (addUp) {
                    System.out.println("Adding UP");
                    wrapper.getVariants().put("facing=up", new BlockStates(wrapper.getVariants().get("facing=north").getModel()));
                }
                if (addDown) {
                    System.out.println("Adding Down");
                    wrapper.getVariants().put("facing=down", new BlockStates(wrapper.getVariants().get("facing=north").getModel()));
                }
                if (!addUp && !addDown) continue;
                for (Map.Entry<String, BlockStates> s : wrapper.getVariants().entrySet()) {
                    System.out.println(s.getKey());
                }
                try (FileWriter writer = new FileWriter(filepath + "/" + child.getName());){
                    gson.toJson((Object)wrapper, (Appendable)writer);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
                addUp = false;
                addDown = false;
            }
        }
    }

    public static class BlockStates {
        String model;
        Integer x;
        Integer y;
        Boolean uvlock;

        public BlockStates() {
        }

        public BlockStates(String model) {
            this.model = model;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public String toString() {
            return "BlockStates [model=" + this.model + "]";
        }

        public Integer getX() {
            return this.x;
        }

        public void setX(Integer x) {
            this.x = x;
        }

        public Integer getY() {
            return this.y;
        }

        public void setY(Integer y) {
            this.y = y;
        }

        public Boolean isUvlock() {
            return this.uvlock;
        }

        public Boolean getUvlock() {
            return this.uvlock;
        }

        public void setUvlock(Boolean uvlock) {
            this.uvlock = uvlock;
        }
    }

    public class Wrapper {
        LinkedHashMap<String, BlockStates> variants;

        public LinkedHashMap<String, BlockStates> getVariants() {
            return this.variants;
        }

        public void setVariants(LinkedHashMap<String, BlockStates> variants) {
            this.variants = variants;
        }
    }
}

