/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.chest;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.chest.ChestContainer;
import com.someguyssoftware.dungeons2.chest.ChestItem;
import com.someguyssoftware.dungeons2.chest.ChestItemEnchantment;
import com.someguyssoftware.dungeons2.chest.ChestItemGroup;
import com.someguyssoftware.dungeons2.chest.ChestSheet;
import com.someguyssoftware.dungeons2.chest.RandomGroup;
import com.someguyssoftware.dungeons2.chest.RandomItem;
import com.someguyssoftware.gottschcore.inventory.InventoryUtil;
import com.someguyssoftware.gottschcore.item.util.ItemUtil;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.IRandomProbabilityItem;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.random.RandomProbabilityCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;

public class ChestPopulator {
    private static final String POTION_ITEM_NAME = "minecraft:potion";
    private static final String SPLASH_POTION_ITEM_NAME = "minecraft:splash_potion";
    private static final String LINGERING_POTION_ITEM_NAME = "minecraft:lingering_potion";
    private ChestSheet chestSheet;
    private Multimap<String, ChestContainer> map = ArrayListMultimap.create();

    public ChestPopulator(ChestSheet sheet) {
        this.chestSheet = sheet;
        this.loadChestSheet(this.chestSheet);
    }

    public void loadChestSheet(ChestSheet chestSheet) {
        this.map.clear();
        for (Map.Entry<String, ChestContainer> e : chestSheet.getContainers().entrySet()) {
            ChestContainer container = e.getValue();
            if (container.getCategory() != null && !container.getCategory().equals("")) {
                this.map.put((Object)container.getCategory().toLowerCase(), (Object)container);
                continue;
            }
            this.map.put((Object)"common", (Object)container);
        }
    }

    public TileEntityChest getChestTileEntity(World world, ICoords chestCoords) {
        TileEntity te = world.func_175625_s(chestCoords.toPos());
        if (te == null) {
            Dungeons2.log.warn("Unable to locate Chest TileEntity @: " + chestCoords.toShortString());
            return null;
        }
        if (!(te instanceof TileEntityChest)) {
            Dungeons2.log.warn(String.format("TileEntity is not an instance of TileEntityChest @ %s", chestCoords.toShortString()));
        }
        return (TileEntityChest)te;
    }

    public void populate(Random random, IInventory inventory, ChestContainer container) {
        ArrayList<RandomItem> allItems = new ArrayList<RandomItem>(container.getRandomItems());
        for (RandomGroup randomGroup : container.getRandomGroups()) {
            ChestItemGroup group = this.getChestSheet().getGroups().get(randomGroup.getRef());
            RandomProbabilityCollection col = new RandomProbabilityCollection();
            for (RandomItem ri : group.getItems()) {
                col.add((int)ri.getWeight(), (IRandomProbabilityItem)ri);
            }
            int numberOfItems = RandomHelper.randomInt((int)((int)(randomGroup.getQuantity().getMin() * randomGroup.getItemsFactor())), (int)((int)(randomGroup.getQuantity().getMax() * randomGroup.getItemsFactor())));
            for (int i = 0; i < numberOfItems; ++i) {
                RandomItem ri = (RandomItem)col.next();
                allItems.add(ri);
            }
            List slots = InventoryUtil.getAvailableSlots((IInventory)inventory);
            if (slots == null || slots.isEmpty()) {
                Dungeons2.log.warn("Slots is null or empty.");
                return;
            }
            for (RandomItem randomItem : allItems) {
                ItemStack itemStack = ChestPopulator.toItemStack(random, randomItem, randomGroup.getChanceFactor(), this.getChestSheet());
                if (itemStack == null || itemStack == null) continue;
                InventoryUtil.addItemToInventory((IInventory)inventory, (ItemStack)itemStack, (Random)random, (List)slots);
                if (slots != null && slots.size() != 0) continue;
                break;
            }
            allItems.clear();
        }
    }

    public static ItemStack toItemStack(Random random, RandomItem randomItem, double chanceFactor, ChestSheet sheet) {
        ChestItem chestItem = sheet.getItems().get(randomItem.getRef());
        if (chestItem == null) {
            Dungeons2.log.warn("Unable to locate chest item in sheet: " + randomItem.getRef());
            return null;
        }
        Item item = null;
        ItemStack stack = null;
        try {
            double chance;
            double r;
            boolean checkProbability = true;
            if (randomItem.getChance() < 100.0 && (r = random.nextDouble() * 100.0) > (chance = randomItem.getChance() * chanceFactor)) {
                checkProbability = false;
            }
            if (checkProbability) {
                if (chestItem.getName().equalsIgnoreCase(POTION_ITEM_NAME) || chestItem.getName().equalsIgnoreCase(SPLASH_POTION_ITEM_NAME) || chestItem.getName().equalsIgnoreCase(LINGERING_POTION_ITEM_NAME)) {
                    stack = ChestPopulator.toPotion(chestItem);
                    return stack;
                }
                item = ChestPopulator.toItem(chestItem.getName());
                if (item == null) {
                    Dungeons2.log.warn("Unable to convert ChestItem to minecraft item: ", (Object)chestItem.getName());
                    return null;
                }
                int size = RandomHelper.randomInt((Random)random, (int)randomItem.getQuantity().getMinInt(), (int)randomItem.getQuantity().getMaxInt());
                stack = chestItem.getDamage() > 0 ? new ItemStack(item, size, chestItem.getDamage()) : new ItemStack(item, size);
                int enchants = 0;
                if (randomItem.getEnchants().getQuantity().getMaxInt() > 0) {
                    enchants = RandomHelper.randomInt((Random)random, (int)randomItem.getEnchants().getQuantity().getMinInt(), (int)randomItem.getEnchants().getQuantity().getMaxInt());
                    for (int i = 0; i < enchants; ++i) {
                        stack = ItemUtil.addEnchantment((ItemStack)stack);
                    }
                }
                if (randomItem.getEnchants().getEnchantments() != null && randomItem.getEnchants().getEnchantments().size() > 0) {
                    for (ChestItemEnchantment chestItemEnchantment : randomItem.getEnchants().getEnchantments()) {
                    }
                }
            }
        }
        catch (Exception e) {
            Dungeons2.log.error("Error generating item from RandomItem:", (Throwable)e);
        }
        return stack;
    }

    public static ItemStack toPotion(ChestItem chestItem) {
        try {
            Item item = ItemUtil.getItemFromName((String)chestItem.getName());
            PotionType type = PotionType.func_185168_a((String)chestItem.getType());
            ItemStack stack = PotionUtils.func_185188_a((ItemStack)new ItemStack(item), (PotionType)type);
            return stack;
        }
        catch (Exception e) {
            Dungeons2.log.error("toItem error:", (Throwable)e);
            return null;
        }
    }

    public static Item toItem(String itemName) {
        try {
            Item item = ItemUtil.getItemFromName((String)itemName);
            return item;
        }
        catch (Exception e) {
            Dungeons2.log.error("toItem error:", (Throwable)e);
            return null;
        }
    }

    public ChestSheet getChestSheet() {
        return this.chestSheet;
    }

    public void setChestSheet(ChestSheet chestSheet) {
        this.chestSheet = chestSheet;
    }

    public Multimap<String, ChestContainer> getMap() {
        return this.map;
    }

    public void setMap(Multimap<String, ChestContainer> map) {
        this.map = map;
    }
}

