/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.command;

import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.builder.DungeonBuilderTopDown;
import com.someguyssoftware.dungeons2.builder.LevelBuilder;
import com.someguyssoftware.dungeons2.chest.ChestSheet;
import com.someguyssoftware.dungeons2.chest.ChestSheetLoader;
import com.someguyssoftware.dungeons2.config.ModConfig;
import com.someguyssoftware.dungeons2.generator.DungeonGenerator;
import com.someguyssoftware.dungeons2.model.Dungeon;
import com.someguyssoftware.dungeons2.model.LevelConfig;
import com.someguyssoftware.dungeons2.spawner.SpawnSheet;
import com.someguyssoftware.dungeons2.spawner.SpawnSheetLoader;
import com.someguyssoftware.dungeons2.style.StyleSheet;
import com.someguyssoftware.dungeons2.style.StyleSheetLoader;
import com.someguyssoftware.dungeons2.style.Theme;
import com.someguyssoftware.dungeonsengine.config.DungeonConfig;
import com.someguyssoftware.dungeonsengine.config.IDungeonConfig;
import com.someguyssoftware.gottschcore.Quantity;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import java.util.List;
import java.util.Random;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class BuildCommand
extends CommandBase {
    public String func_71517_b() {
        return "dgn2build";
    }

    public String func_71518_a(ICommandSender var1) {
        return "/dgn2build <x> <y> <z> [pattern] [size] [terrianCheck] : generates the dungeon structure at location (x,y,z)";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) {
        EntityPlayer player = (EntityPlayer)commandSender.func_174793_f();
        try {
            int z = 0;
            int x = Integer.parseInt(args[0]);
            int y = Integer.parseInt(args[1]);
            z = Integer.parseInt(args[2]);
            String pattern = "";
            if (args.length > 3) {
                pattern = args[3];
            }
            String size = "";
            if (args.length > 4) {
                size = args[4];
            }
            String terrainCheck = "0";
            if (args.length > 5) {
                terrainCheck = args[5];
            }
            if (player != null) {
                World world = commandSender.func_130014_f_();
                Dungeons2.log.debug("Starting to build Dungeons2! dungeon ...");
                Random random = new Random();
                LevelConfig config = new LevelConfig();
                config.setMinecraftConstraintsOn(false);
                config.setSupportOn(false);
                config.setNumberOfRooms(new Quantity(10.0, 25.0));
                config.setWidth(new Quantity(5.0, 15.0));
                config.setDepth(new Quantity(5.0, 15.0));
                config.setHeight(new Quantity(5.0, 8.0));
                config.setYVariance(new Quantity(0.0, 0.0));
                config.setXDistance(new Quantity(-25.0, 25.0));
                config.setZDistance(new Quantity(-25.0, 25.0));
                Coords startPoint = new Coords(x, y, z);
                Biome biome = world.func_180494_b(startPoint.toPos());
                Integer biomeID = Biome.func_185362_a((Biome)biome);
                List<IDungeonConfig> dcList = Dungeons2.CONFIG_MANAGER.getByBiome(biomeID);
                IDungeonConfig dc = dcList.get(random.nextInt(dcList.size()));
                Dungeons2.log.debug("selected dungeon config -> {}", (Object)dc);
                LevelBuilder levelBuilder = new LevelBuilder(config);
                DungeonConfig dConfig = new DungeonConfig();
                dConfig.setNumLevels(new Quantity(2.0, 5.0));
                AxisAlignedBB dungeonField = new AxisAlignedBB(startPoint.toPos()).func_186662_g(80.0);
                DungeonBuilderTopDown dungeonBuilder = new DungeonBuilderTopDown();
                dungeonBuilder.withBoundary(dungeonField).withStartPoint((ICoords)startPoint).setLevelBuilder(levelBuilder);
                Dungeon dungeon = dungeonBuilder.build(world, random, (ICoords)startPoint, dConfig);
                if (dungeon == DungeonBuilderTopDown.EMPTY_DUNGEON) {
                    Dungeons2.log.warn("Empty Dungeon");
                    return;
                }
                StyleSheet styleSheet = StyleSheetLoader.load();
                ChestSheet chestSheet = ChestSheetLoader.load();
                SpawnSheet spawnSheet = SpawnSheetLoader.load();
                Theme theme = styleSheet.getThemes().get(styleSheet.getThemes().keySet().toArray()[random.nextInt(styleSheet.getThemes().size())]);
                Dungeons2.log.debug("theme:" + theme);
                dungeon.setTheme(theme);
                DungeonGenerator gen = new DungeonGenerator();
                gen.generate(world, random, dungeon, styleSheet, chestSheet, spawnSheet);
                if (dungeon != null && dungeon.getLevels() != null && dungeon.getLevels().size() > 0) {
                    Dungeons2.log.info(String.format("Dungeons2! dungeon generated @ %d %d %d", x, y, z));
                    player.func_145747_a((ITextComponent)new TextComponentString(String.format("Dungeons2! dungeon generated @ %d %d %d", x, y, z)));
                    if (ModConfig.enableDumps) {
                        try {
                            Dungeons2.dungeonsWorldGen.dump(dungeon);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        catch (Exception e) {
            player.func_145747_a((ITextComponent)new TextComponentString("Error:  " + e.getMessage()));
            Dungeons2.log.error("Error generating Dungeons2! dungeon:", (Throwable)e);
            e.printStackTrace();
        }
    }
}

