/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.command;

import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.chest.ChestContainer;
import com.someguyssoftware.dungeons2.chest.ChestPopulator;
import com.someguyssoftware.dungeons2.chest.ChestSheet;
import com.someguyssoftware.dungeons2.chest.ChestSheetLoader;
import com.someguyssoftware.dungeons2.config.ModConfig;
import com.someguyssoftware.gottschcore.random.RandomProbabilityCollection;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ChestCommand
extends CommandBase {
    public String func_71517_b() {
        return "dgn2chest";
    }

    public String func_71518_a(ICommandSender var1) {
        return "/dgn2chest <x> <y> <z> [category | -n <name>]: generates a dungeon chest at location (x,y,z)";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) {
        EntityPlayer player = (EntityPlayer)commandSender.func_174793_f();
        try {
            int z = 0;
            int x = Integer.parseInt(args[0]);
            int y = Integer.parseInt(args[1]);
            z = Integer.parseInt(args[2]);
            String category = "";
            if (args.length > 3) {
                category = args[3];
            }
            if (category.equals("")) {
                category = "common";
            }
            if (player != null) {
                World world = commandSender.func_130014_f_();
                Dungeons2.log.debug("Starting to build Dungeons2! chest ...");
                BlockPos pos = new BlockPos(x, y, z);
                world.func_175656_a(pos, Blocks.field_150486_ae.func_176223_P());
                TileEntityChest chest = (TileEntityChest)world.func_175625_s(pos);
                if (chest != null) {
                    ChestSheet chestSheet = ChestSheetLoader.load(ModConfig.chestSheetFile);
                    ChestPopulator pop = new ChestPopulator(chestSheet);
                    List containers = (List)pop.getMap().get((Object)category);
                    Dungeons2.log.debug("Containers found:" + containers.size());
                    if (containers != null && !containers.isEmpty()) {
                        Dungeons2.log.info("Selected chest containers:" + containers);
                        RandomProbabilityCollection chestProbCol = new RandomProbabilityCollection((Collection)containers);
                        ChestContainer container = (ChestContainer)chestProbCol.next();
                        Dungeons2.log.info("Chosen chest container:" + container);
                        pop.populate(new Random(), (IInventory)chest, container);
                    }
                }
            }
        }
        catch (Exception e) {
            player.func_145747_a((ITextComponent)new TextComponentString("Error:  " + e.getMessage()));
            Dungeons2.log.error("Error generating Dungeons2! chest:", (Throwable)e);
            e.printStackTrace();
        }
    }
}

