/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.generator;

import com.someguyssoftware.dungeons2.generator.AbstractRoomGenerator;
import com.someguyssoftware.dungeons2.generator.strategy.IRoomGenerationStrategy;
import com.someguyssoftware.dungeons2.model.Door;
import com.someguyssoftware.dungeons2.model.Hallway;
import com.someguyssoftware.dungeons2.model.LevelConfig;
import com.someguyssoftware.dungeons2.model.Room;
import com.someguyssoftware.dungeons2.style.StyleSheet;
import com.someguyssoftware.dungeons2.style.Theme;
import com.someguyssoftware.dungeonsengine.config.ILevelConfig;
import com.someguyssoftware.gottschcore.enums.Alignment;
import com.someguyssoftware.gottschcore.enums.Direction;
import com.someguyssoftware.gottschcore.positional.ICoords;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HallwayGenerator
extends AbstractRoomGenerator {
    private IRoomGenerationStrategy roomGenerationStrategy;

    public HallwayGenerator(IRoomGenerationStrategy generator) {
        this.setGenerationStrategy(generator);
    }

    @Override
    public void generate(World world, Random random, Room room, Theme theme, StyleSheet styleSheet, ILevelConfig config) {
        this.getGenerationStrategy().generate(world, random, room, theme, styleSheet, config);
        Hallway hw = (Hallway)room;
        for (Door door : hw.getDoors()) {
            if (hw.getAlignment() == Alignment.HORIZONTAL) {
                if (door.getCoords().getX() == hw.getMinX()) {
                    if (door.getCoords().getZ() == door.getRoom().getMinZ()) {
                        this.buildDoorway(world, door.getCoords(), Direction.WEST, Direction.SOUTH);
                    } else if (door.getCoords().getZ() == door.getRoom().getMaxZ()) {
                        this.buildDoorway(world, door.getCoords(), Direction.WEST, Direction.NORTH);
                    } else {
                        this.buildDoorway(world, door.getCoords(), Direction.WEST);
                    }
                }
                if (door.getCoords().getX() != hw.getMaxX()) continue;
                if (door.getCoords().getZ() == door.getRoom().getMinZ()) {
                    this.buildDoorway(world, door.getCoords(), Direction.EAST, Direction.SOUTH);
                    continue;
                }
                if (door.getCoords().getZ() == door.getRoom().getMaxZ()) {
                    this.buildDoorway(world, door.getCoords(), Direction.EAST, Direction.NORTH);
                    continue;
                }
                this.buildDoorway(world, door.getCoords(), Direction.EAST);
                continue;
            }
            if (door.getCoords().getZ() == hw.getMinZ()) {
                if (door.getCoords().getX() == door.getRoom().getMinX()) {
                    this.buildDoorway(world, door.getCoords(), Direction.NORTH, Direction.EAST);
                } else if (door.getCoords().getX() == door.getRoom().getMaxX()) {
                    this.buildDoorway(world, door.getCoords(), Direction.NORTH, Direction.WEST);
                } else {
                    this.buildDoorway(world, door.getCoords(), Direction.NORTH);
                }
            }
            if (door.getCoords().getZ() != hw.getMaxZ()) continue;
            if (door.getCoords().getX() == door.getRoom().getMinX()) {
                this.buildDoorway(world, door.getCoords(), Direction.SOUTH, Direction.EAST);
                continue;
            }
            if (door.getCoords().getX() == door.getRoom().getMaxX()) {
                this.buildDoorway(world, door.getCoords(), Direction.SOUTH, Direction.WEST);
                continue;
            }
            this.buildDoorway(world, door.getCoords(), Direction.SOUTH);
        }
    }

    @Override
    @Deprecated
    public void generate(World world, Random random, Room room, Theme theme, StyleSheet styleSheet, LevelConfig config) {
        this.getGenerationStrategy().generate(world, random, room, theme, styleSheet, config);
        Hallway hw = (Hallway)room;
        for (Door door : hw.getDoors()) {
            if (hw.getAlignment() == Alignment.HORIZONTAL) {
                if (door.getCoords().getX() == hw.getMinX()) {
                    if (door.getCoords().getZ() == door.getRoom().getMinZ()) {
                        this.buildDoorway(world, door.getCoords(), Direction.WEST, Direction.SOUTH);
                    } else if (door.getCoords().getZ() == door.getRoom().getMaxZ()) {
                        this.buildDoorway(world, door.getCoords(), Direction.WEST, Direction.NORTH);
                    } else {
                        this.buildDoorway(world, door.getCoords(), Direction.WEST);
                    }
                }
                if (door.getCoords().getX() != hw.getMaxX()) continue;
                if (door.getCoords().getZ() == door.getRoom().getMinZ()) {
                    this.buildDoorway(world, door.getCoords(), Direction.EAST, Direction.SOUTH);
                    continue;
                }
                if (door.getCoords().getZ() == door.getRoom().getMaxZ()) {
                    this.buildDoorway(world, door.getCoords(), Direction.EAST, Direction.NORTH);
                    continue;
                }
                this.buildDoorway(world, door.getCoords(), Direction.EAST);
                continue;
            }
            if (door.getCoords().getZ() == hw.getMinZ()) {
                if (door.getCoords().getX() == door.getRoom().getMinX()) {
                    this.buildDoorway(world, door.getCoords(), Direction.NORTH, Direction.EAST);
                } else if (door.getCoords().getX() == door.getRoom().getMaxX()) {
                    this.buildDoorway(world, door.getCoords(), Direction.NORTH, Direction.WEST);
                } else {
                    this.buildDoorway(world, door.getCoords(), Direction.NORTH);
                }
            }
            if (door.getCoords().getZ() != hw.getMaxZ()) continue;
            if (door.getCoords().getX() == door.getRoom().getMinX()) {
                this.buildDoorway(world, door.getCoords(), Direction.SOUTH, Direction.EAST);
                continue;
            }
            if (door.getCoords().getX() == door.getRoom().getMaxX()) {
                this.buildDoorway(world, door.getCoords(), Direction.SOUTH, Direction.WEST);
                continue;
            }
            this.buildDoorway(world, door.getCoords(), Direction.SOUTH);
        }
    }

    protected void buildDoorway(World world, ICoords coords, Direction direction, Direction doubleSide) {
        int touching = 0;
        int x = 0;
        int z = 0;
        int dx = 0;
        int dz = 0;
        int failSafe = 0;
        switch (doubleSide) {
            case NORTH: {
                --dz;
                break;
            }
            case EAST: {
                ++dx;
                break;
            }
            case SOUTH: {
                ++dz;
                break;
            }
            case WEST: {
                --dx;
                break;
            }
        }
        do {
            touching = 0;
            world.func_180501_a(coords.add(x, 1, z).toPos(), Blocks.field_150350_a.func_176223_P(), 3);
            world.func_180501_a(coords.add(x, 2, z).toPos(), Blocks.field_150350_a.func_176223_P(), 3);
            world.func_180501_a(coords.add(dx, 1, dz).toPos(), Blocks.field_150350_a.func_176223_P(), 3);
            world.func_180501_a(coords.add(dx, 2, dz).toPos(), Blocks.field_150350_a.func_176223_P(), 3);
            BlockPos pos = coords.add(dx, 1, dz).toPos();
            if (world.func_180495_p(pos.func_177978_c()) == Blocks.field_150350_a.func_176223_P()) {
                ++touching;
            }
            if (world.func_180495_p(pos.func_177968_d()) == Blocks.field_150350_a.func_176223_P()) {
                ++touching;
            }
            if (world.func_180495_p(pos.func_177974_f()) == Blocks.field_150350_a.func_176223_P()) {
                ++touching;
            }
            if (world.func_180495_p(pos.func_177976_e()) == Blocks.field_150350_a.func_176223_P()) {
                ++touching;
            }
            switch (direction) {
                case NORTH: {
                    --z;
                    --dz;
                    break;
                }
                case EAST: {
                    ++x;
                    ++dx;
                    break;
                }
                case SOUTH: {
                    ++z;
                    ++dz;
                    break;
                }
                case WEST: {
                    --x;
                    --dx;
                    break;
                }
            }
        } while (touching < 3 && ++failSafe < 5);
    }

    @Override
    public IRoomGenerationStrategy getGenerationStrategy() {
        return this.roomGenerationStrategy;
    }

    public void setGenerationStrategy(IRoomGenerationStrategy roomGenerationStrategy) {
        this.roomGenerationStrategy = roomGenerationStrategy;
    }
}

