/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.generator;

import com.google.common.collect.Multimap;
import com.someguyssoftware.dungeons2.generator.BossRoomGenerator;
import com.someguyssoftware.dungeons2.generator.EntranceRoomGenerator;
import com.someguyssoftware.dungeons2.generator.HallwayGenerator;
import com.someguyssoftware.dungeons2.generator.IRoomGenerator;
import com.someguyssoftware.dungeons2.generator.RoomGenerator;
import com.someguyssoftware.dungeons2.generator.blockprovider.BossRoomBlockProvider;
import com.someguyssoftware.dungeons2.generator.blockprovider.CheckedFloorRoomBlockProvider;
import com.someguyssoftware.dungeons2.generator.blockprovider.EndRoomBlockProvider;
import com.someguyssoftware.dungeons2.generator.blockprovider.EntranceRoomBlockProvider;
import com.someguyssoftware.dungeons2.generator.blockprovider.HallwayBlockProvider;
import com.someguyssoftware.dungeons2.generator.blockprovider.PillarRingRoomBlockProvider;
import com.someguyssoftware.dungeons2.generator.blockprovider.ShaftBlockProvider;
import com.someguyssoftware.dungeons2.generator.blockprovider.SinglePillarRoomBlockProvider;
import com.someguyssoftware.dungeons2.generator.blockprovider.StandardBlockProvider;
import com.someguyssoftware.dungeons2.generator.blockprovider.StartRoomBlockProvider;
import com.someguyssoftware.dungeons2.generator.strategy.StandardHallwayGenerationStrategy;
import com.someguyssoftware.dungeons2.generator.strategy.StandardRoomGenerationStrategy;
import com.someguyssoftware.dungeons2.generator.strategy.SupportedHallwayGenerationStrategy;
import com.someguyssoftware.dungeons2.generator.strategy.SupportedRoomGenerationStrategy;
import com.someguyssoftware.dungeons2.model.Hallway;
import com.someguyssoftware.dungeons2.model.Room;
import java.util.List;
import java.util.Random;

public class RoomGeneratorFactory {
    Multimap<String, IRoomGenerator> registry;

    public RoomGeneratorFactory() {
    }

    public RoomGeneratorFactory(Multimap<String, IRoomGenerator> registry) {
        this.registry = registry;
        registry.put((Object)"standard-room", (Object)new RoomGenerator(new StandardRoomGenerationStrategy(new StandardBlockProvider())));
        registry.put((Object)"standard-room", (Object)new RoomGenerator(new StandardRoomGenerationStrategy(new PillarRingRoomBlockProvider())));
        registry.put((Object)"standard-room", (Object)new RoomGenerator(new StandardRoomGenerationStrategy(new SinglePillarRoomBlockProvider())));
        registry.put((Object)"standard-room", (Object)new RoomGenerator(new StandardRoomGenerationStrategy(new CheckedFloorRoomBlockProvider())));
        registry.put((Object)"standard-entrance", (Object)new EntranceRoomGenerator(new StandardRoomGenerationStrategy(new EntranceRoomBlockProvider())));
        registry.put((Object)"supported-room", (Object)new RoomGenerator(new SupportedRoomGenerationStrategy(new StandardBlockProvider())));
        registry.put((Object)"supported-room", (Object)new RoomGenerator(new SupportedRoomGenerationStrategy(new PillarRingRoomBlockProvider())));
        registry.put((Object)"supported-room", (Object)new RoomGenerator(new SupportedRoomGenerationStrategy(new SinglePillarRoomBlockProvider())));
        registry.put((Object)"supported-room", (Object)new RoomGenerator(new SupportedRoomGenerationStrategy(new CheckedFloorRoomBlockProvider())));
        registry.put((Object)"supported-entrance", (Object)new EntranceRoomGenerator(new SupportedRoomGenerationStrategy(new EntranceRoomBlockProvider())));
    }

    public IRoomGenerator createRoomGenerator(Random random, Room room, Boolean useSupport) {
        if (useSupport.booleanValue()) {
            return this.createSupportedRoomGenerator(random, room);
        }
        return this.createStandardRoomGenerator(random, room);
    }

    public IRoomGenerator createHallwayGenerator(Hallway hallway, List<Room> rooms, List<Hallway> hallways, Boolean useSupport) {
        if (useSupport.booleanValue()) {
            return this.createSupportedHallwayGenerator(hallway, rooms, hallways);
        }
        return this.createStandardHallwayGenerator(hallway, rooms, hallways);
    }

    public IRoomGenerator createShaftGenerator(Room shaft, Boolean useSupport) {
        if (useSupport.booleanValue()) {
            return this.createSupportedShaftGenerator(shaft);
        }
        return this.createStandardShaftGenerator(shaft);
    }

    public IRoomGenerator createStandardRoomGenerator(Random random, Room room) {
        IRoomGenerator gen = null;
        if (room.getType() == Room.Type.ENTRANCE) {
            gen = new EntranceRoomGenerator(new StandardRoomGenerationStrategy(new EntranceRoomBlockProvider()));
        } else if (room.isStart()) {
            gen = new RoomGenerator(new StandardRoomGenerationStrategy(new StartRoomBlockProvider()));
        } else if (room.isEnd() && room.getType() != Room.Type.BOSS) {
            gen = new RoomGenerator(new StandardRoomGenerationStrategy(new EndRoomBlockProvider()));
        } else if (room.getType() == Room.Type.BOSS) {
            gen = new BossRoomGenerator(new StandardRoomGenerationStrategy(new BossRoomBlockProvider()));
        } else if (this.registry != null && this.registry.containsKey((Object)"standard-room")) {
            List list = (List)this.registry.get((Object)"standard-room");
            gen = (IRoomGenerator)list.get(random.nextInt(list.size()));
        } else {
            gen = new RoomGenerator(new StandardRoomGenerationStrategy(new StandardBlockProvider()));
        }
        return gen;
    }

    public IRoomGenerator createSupportedRoomGenerator(Random random, Room room) {
        IRoomGenerator gen = null;
        if (room.getType() == Room.Type.ENTRANCE) {
            gen = new EntranceRoomGenerator(new SupportedRoomGenerationStrategy(new EntranceRoomBlockProvider()));
        } else if (room.isStart()) {
            gen = new RoomGenerator(new SupportedRoomGenerationStrategy(new StartRoomBlockProvider()));
        } else if (room.isEnd() && room.getType() != Room.Type.BOSS) {
            gen = new RoomGenerator(new SupportedRoomGenerationStrategy(new EndRoomBlockProvider()));
        } else if (room.getType() == Room.Type.BOSS) {
            gen = new BossRoomGenerator(new SupportedRoomGenerationStrategy(new BossRoomBlockProvider()));
        } else if (this.registry != null && this.registry.containsKey((Object)"supported-room")) {
            List list = (List)this.registry.get((Object)"supported-room");
            gen = (IRoomGenerator)list.get(random.nextInt(list.size()));
        } else {
            gen = new RoomGenerator(new SupportedRoomGenerationStrategy(new StandardBlockProvider()));
        }
        return gen;
    }

    public IRoomGenerator createStandardHallwayGenerator(Hallway hallway, List<Room> rooms, List<Hallway> hallways) {
        HallwayGenerator gen = null;
        gen = new HallwayGenerator(new StandardHallwayGenerationStrategy(new HallwayBlockProvider(), rooms, hallways));
        return gen;
    }

    public IRoomGenerator createSupportedHallwayGenerator(Hallway hallway, List<Room> rooms, List<Hallway> hallways) {
        HallwayGenerator gen = new HallwayGenerator(new SupportedHallwayGenerationStrategy(new HallwayBlockProvider(), rooms, hallways));
        return gen;
    }

    public IRoomGenerator createStandardShaftGenerator(Room shaft) {
        RoomGenerator gen = null;
        gen = new RoomGenerator(new StandardRoomGenerationStrategy(new ShaftBlockProvider()));
        return gen;
    }

    public IRoomGenerator createSupportedShaftGenerator(Room shaft) {
        RoomGenerator gen = new RoomGenerator(new SupportedRoomGenerationStrategy(new ShaftBlockProvider()));
        return gen;
    }
}

