/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.generator.blockprovider;

import com.someguyssoftware.dungeons2.generator.blockprovider.IExteriorDungeonsBlockProvider;
import com.someguyssoftware.dungeons2.model.Room;
import com.someguyssoftware.dungeons2.style.DesignElement;
import com.someguyssoftware.dungeons2.style.Layout;
import com.someguyssoftware.gottschcore.positional.ICoords;

public class EntranceRoomBlockProvider
implements IExteriorDungeonsBlockProvider {
    private static final int INSET_WALL_EXTERIOR_MIN_WIDTH = 7;

    @Override
    public DesignElement getDesignElement(ICoords coords, Room room, Layout layout) {
        int ceilingHeight = this.getCeilingHeight(room, layout);
        int corniceHeight = this.getCorniceHeight(room, layout);
        if (this.isLadderElement(coords, room, layout)) {
            return DesignElement.LADDER;
        }
        if ((room.hasPlinth() || room.hasColumn() || room.hasCornice()) && room.getWidth() >= 7) {
            if (this.isInsetWallElement(coords, room, layout)) {
                if (this.isFacadeSupport(coords, room, layout)) {
                    return DesignElement.FACADE_SUPPORT;
                }
                return DesignElement.WALL;
            }
            DesignElement element = null;
            if (this.isPlinthElement(coords, room, layout)) {
                element = DesignElement.PLINTH;
            } else if (this.isCorniceElement(coords, room, layout)) {
                element = DesignElement.CORNICE;
            }
            if (this.isColumnElement(coords, room, layout)) {
                element = this.isBaseElement(coords, room, layout) ? DesignElement.BASE : (this.isCapitalElement(coords, room, layout) ? DesignElement.CAPITAL : DesignElement.COLUMN);
            }
            if (element != null) {
                return element;
            }
        } else {
            if (this.isWindowElement(coords, room, layout)) {
                return DesignElement.WINDOW;
            }
            if (this.isFacadeSupport(coords, room, layout)) {
                return DesignElement.FACADE_SUPPORT;
            }
            if (this.isWallElement(coords, room, layout)) {
                return DesignElement.WALL;
            }
        }
        if (this.isFloorElement(coords, room, layout)) {
            return DesignElement.FLOOR;
        }
        if (room.hasTrim() && this.isTrimElement(coords, room, layout)) {
            return DesignElement.TRIM;
        }
        if (room.hasCrown() && this.isCrownElement(coords, room, layout)) {
            return DesignElement.CROWN;
        }
        if (this.isCeilingElement(coords, room, layout)) {
            return DesignElement.CEILING;
        }
        if (room.hasCrenellation()) {
            if (this.isCrenellationElement(coords, room, layout)) {
                if (this.isParapetElement(coords, room, layout)) {
                    return DesignElement.PARAPET;
                }
                if (this.isMerlonElement(coords, room, layout)) {
                    return DesignElement.MERLON;
                }
            }
        } else {
            if (room.hasMerlon() && this.isMerlonElement(coords, room, layout)) {
                return DesignElement.MERLON;
            }
            if (room.hasParapet() && this.isParapetElement(coords, room, layout)) {
                return DesignElement.PARAPET;
            }
        }
        return DesignElement.AIR;
    }

    @Override
    public boolean isFacadeSupport(ICoords coords, Room room, Layout layout) {
        int h = this.getCeilingHeight(room, layout);
        return coords.getY() == h || coords.getY() == h - 1 || coords.getY() == this.getCorniceHeight(room, layout);
    }
}

