/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.generator.blockprovider;

import com.someguyssoftware.dungeons2.generator.blockprovider.IDungeonsBlockProvider;
import com.someguyssoftware.dungeons2.model.Room;
import com.someguyssoftware.dungeons2.style.DesignElement;
import com.someguyssoftware.dungeons2.style.Layout;
import com.someguyssoftware.gottschcore.enums.Direction;
import com.someguyssoftware.gottschcore.positional.ICoords;

public class StartRoomBlockProvider
implements IDungeonsBlockProvider {
    @Override
    public DesignElement getDesignElement(ICoords coords, Room room, Layout layout) {
        if (this.isFloorElement(coords, room, layout)) {
            return DesignElement.FLOOR;
        }
        if (this.isWallElement(coords, room, layout)) {
            if (this.isFacadeSupport(coords, room, layout)) {
                return DesignElement.FACADE_SUPPORT;
            }
            return DesignElement.WALL;
        }
        if (this.isLadderPillarElement(coords, room, layout)) {
            return DesignElement.LADDER_PILLAR;
        }
        if (this.isLadderElement(coords, room, layout)) {
            return DesignElement.LADDER;
        }
        if (room.hasPillar() && this.isPillarElement(coords, room, layout)) {
            if (this.isBaseElement(coords, room, layout)) {
                return DesignElement.PILLAR_BASE;
            }
            if (this.isCapitalElement(coords, room, layout)) {
                return DesignElement.PILLAR_CAPITAL;
            }
            return DesignElement.PILLAR;
        }
        if (room.hasCrown() && this.isCrownElement(coords, room, layout)) {
            return DesignElement.CROWN;
        }
        if (room.hasTrim() && this.isTrimElement(coords, room, layout)) {
            return DesignElement.TRIM;
        }
        if (this.isCeilingElement(coords, room, layout)) {
            return DesignElement.CEILING;
        }
        return DesignElement.AIR;
    }

    public boolean isLadderPillarElement(ICoords coords, Room room, Layout layout) {
        ICoords center = room.getCenter();
        return coords.getX() == center.getX() && coords.getZ() == center.getZ() && coords.getY() > room.getMinY();
    }

    @Override
    public boolean isLadderElement(ICoords coords, Room room, Layout layout) {
        ICoords center = room.getCenter();
        Direction direction = room.getDirection();
        switch (direction) {
            case NORTH: {
                if (coords.getX() != center.getX() || coords.getZ() != center.getZ() + 1 || coords.getY() <= room.getMinY()) break;
                return true;
            }
            case EAST: {
                if (coords.getX() != center.getX() - 1 || coords.getZ() != center.getZ() || coords.getY() <= room.getMinY()) break;
                return true;
            }
            case SOUTH: {
                if (coords.getX() != center.getX() || coords.getZ() != center.getZ() - 1 || coords.getY() <= room.getMinY()) break;
                return true;
            }
            case WEST: {
                if (coords.getX() != center.getX() + 1 || coords.getZ() != center.getZ() || coords.getY() <= room.getMinY()) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPillarElement(ICoords coords, Room room, Layout layout) {
        int x = coords.getX();
        int y = coords.getY();
        int z = coords.getZ();
        if (!room.hasPillar() || Math.min(room.getWidth(), room.getDepth()) < 7 || y == room.getMaxY()) {
            return false;
        }
        return !(x != room.getMinX() + 2 && x != room.getMaxX() - 2 || z != room.getMinZ() + 2 && z != room.getMaxZ() - 2);
    }
}

