/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.generator.strategy;

import com.google.common.collect.Multimap;
import com.someguyssoftware.dungeons2.generator.AbstractRoomGenerationStrategy;
import com.someguyssoftware.dungeons2.generator.Arrangement;
import com.someguyssoftware.dungeons2.generator.blockprovider.IDungeonsBlockProvider;
import com.someguyssoftware.dungeons2.model.LevelConfig;
import com.someguyssoftware.dungeons2.model.Room;
import com.someguyssoftware.dungeons2.style.DesignElement;
import com.someguyssoftware.dungeons2.style.StyleSheet;
import com.someguyssoftware.dungeons2.style.Theme;
import com.someguyssoftware.dungeonsengine.config.ILevelConfig;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.World;

public class StandardRoomGenerationStrategy
extends AbstractRoomGenerationStrategy {
    public StandardRoomGenerationStrategy(IDungeonsBlockProvider blockProvider) {
        super(blockProvider);
    }

    @Override
    public void generate(World world, Random random, Room room, Theme theme, StyleSheet styleSheet, ILevelConfig config) {
        IBlockState blockState = null;
        Multimap<DesignElement, ICoords> blueprint = room.getFloorMap();
        HashMap<ICoords, Arrangement> postProcessMap = new HashMap<ICoords, Arrangement>();
        for (int y = 0; y < room.getHeight(); ++y) {
            for (int z = 0; z < room.getDepth(); ++z) {
                for (int x = 0; x < room.getWidth(); ++x) {
                    Coords indexCoords = new Coords(x, y, z);
                    ICoords worldCoords = room.getCoords().add((ICoords)indexCoords);
                    Arrangement arrangement = this.getBlockProvider().getArrangement(worldCoords, room, room.getLayout());
                    if (worldCoords.getY() == room.getMinY() + 1 || arrangement.getElement().getFamily() == DesignElement.SURFACE_AIR) {
                        blueprint.put((Object)arrangement.getElement(), (Object)worldCoords);
                    }
                    if (this.isPostProcessed(arrangement, worldCoords, postProcessMap) || (blockState = this.getBlockProvider().getBlockState(random, worldCoords, room, arrangement, theme, styleSheet, config)) == null || blockState == IDungeonsBlockProvider.NULL_BLOCK) continue;
                    world.func_180501_a(worldCoords.toPos(), blockState, 3);
                }
            }
        }
        this.postProcess(world, random, postProcessMap, room.getLayout(), theme, styleSheet, config);
    }

    @Override
    @Deprecated
    public void generate(World world, Random random, Room room, Theme theme, StyleSheet styleSheet, LevelConfig config) {
        IBlockState blockState = null;
        Multimap<DesignElement, ICoords> blueprint = room.getFloorMap();
        HashMap<ICoords, Arrangement> postProcessMap = new HashMap<ICoords, Arrangement>();
        for (int y = 0; y < room.getHeight(); ++y) {
            for (int z = 0; z < room.getDepth(); ++z) {
                for (int x = 0; x < room.getWidth(); ++x) {
                    Coords indexCoords = new Coords(x, y, z);
                    ICoords worldCoords = room.getCoords().add((ICoords)indexCoords);
                    Arrangement arrangement = this.getBlockProvider().getArrangement(worldCoords, room, room.getLayout());
                    if (worldCoords.getY() == room.getMinY() + 1 || arrangement.getElement().getFamily() == DesignElement.SURFACE_AIR) {
                        blueprint.put((Object)arrangement.getElement(), (Object)worldCoords);
                    }
                    if (this.isPostProcessed(arrangement, worldCoords, postProcessMap) || (blockState = this.getBlockProvider().getBlockState(random, worldCoords, room, arrangement, theme, styleSheet, config)) == null || blockState == IDungeonsBlockProvider.NULL_BLOCK) continue;
                    world.func_180501_a(worldCoords.toPos(), blockState, 3);
                }
            }
        }
        this.postProcess(world, random, postProcessMap, room.getLayout(), theme, styleSheet, config);
    }
}

