/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.model;

import com.someguyssoftware.dungeons2.chest.ChestCategory;
import com.someguyssoftware.gottschcore.Quantity;
import java.util.ArrayList;
import java.util.List;

public class LevelConfig {
    private Quantity numberOfRooms;
    private Quantity width;
    private Quantity depth;
    private Quantity height;
    private Quantity xDistance;
    private Quantity zDistance;
    private Quantity yRange;
    @Deprecated
    private Quantity yVariance;
    private Quantity degrees;
    private int decayMultiplier;
    private Integer surfaceBuffer;
    private Quantity spawnerFrequency;
    private Quantity chestFrequency;
    private List<String> chestCategories;
    private Quantity webFrequency;
    private Quantity numberOfWebs;
    private Quantity vineFrequency;
    private Quantity numberOfVines;
    private Quantity anywhereDecorationFrequency;
    private Quantity numberOfAnywhereDecorations;
    private Quantity bloodFrequency;
    private Quantity numberOfBlood;
    private Quantity puddleFrequency;
    private Quantity numberOfPuddles;
    private boolean decorationsOn = true;
    private boolean minecraftConstraintsOn = true;
    private int seaLevel;
    private boolean supportOn = true;

    public LevelConfig() {
        this.setNumberOfRooms(new Quantity(25.0, 35.0));
        this.setNumberOfEdges(new Quantity(2.0, 4.0));
        this.setWidth(new Quantity(5.0, 15.0));
        this.setDepth(new Quantity(5.0, 15.0));
        this.setHeight(new Quantity(5.0, 8.0));
        this.setXDistance(new Quantity(-100.0, 100.0));
        this.setZDistance(new Quantity(-100.0, 100.0));
        this.setYRange(new Quantity(3.0, 230.0));
        this.setDegrees(new Quantity(3.0, 4.0));
        this.setYVariance(new Quantity(0.0, 0.0));
        this.setSurfaceBuffer(10);
        this.setDecayMultiplier(5);
        this.setSpawnerFrequency(new Quantity(5.0, 10.0));
        this.setChestFrequency(new Quantity(5.0, 10.0));
        this.chestCategories = new ArrayList<String>();
        this.chestCategories.add(ChestCategory.COMMON.name().toLowerCase());
        this.chestCategories.add(ChestCategory.UNCOMMON.name().toLowerCase());
        this.chestCategories.add(ChestCategory.RARE.name().toLowerCase());
        this.setWebFrequency(new Quantity(10.0, 20.0));
        this.setNumberOfWebs(new Quantity(10.0, 10.0));
        this.setVineFrequency(new Quantity(10.0, 20.0));
        this.setNumberOfVines(new Quantity(10.0, 10.0));
        this.setAnywhereDecorationFrequency(new Quantity(20.0, 30.0));
        this.setNumberOfAnywhereDecorations(new Quantity(20.0, 20.0));
        this.setBloodFrequency(new Quantity(10.0, 20.0));
        this.setNumberOfBlood(new Quantity(5.0, 5.0));
        this.setPuddleFrequency(new Quantity(10.0, 20.0));
        this.setNumberOfPuddles(new Quantity(5.0, 5.0));
        this.setDecorationsOn(true);
        this.setSeaLevel(63);
        this.setMinecraftConstraintsOn(true);
        this.setSupportOn(true);
    }

    public LevelConfig(LevelConfig config) {
        this.setNumberOfEdges(config.getNumberOfEdges());
        this.setNumberOfRooms(config.getNumberOfRooms());
        this.setWidth(new Quantity(config.getWidth()));
        this.setDepth(new Quantity(config.getDepth()));
        this.setHeight(new Quantity(config.getHeight()));
        this.setXDistance(new Quantity(config.getXDistance()));
        this.setZDistance(new Quantity(config.getZDistance()));
        this.setYRange(new Quantity(config.getYRange()));
        this.setYVariance(new Quantity(config.getYVariance()));
        this.setDegrees(new Quantity(config.getDegrees()));
        this.setSurfaceBuffer(config.getSurfaceBuffer());
        this.setDecayMultiplier(config.getDecayMultiplier());
        this.setChestFrequency(config.getChestFrequency());
        this.getChestCategories().addAll(config.getChestCategories());
        this.setSpawnerFrequency(config.getSpawnerFrequency());
        this.setWebFrequency(config.getWebFrequency());
        this.setNumberOfWebs(config.getNumberOfWebs());
        this.setVineFrequency(config.getVineFrequency());
        this.setNumberOfVines(config.getNumberOfVines());
        this.setAnywhereDecorationFrequency(config.getAnywhereDecorationFrequency());
        this.setNumberOfAnywhereDecorations(config.getNumberOfAnywhereDecorations());
        this.setBloodFrequency(config.getBloodFrequency());
        this.setNumberOfBlood(config.getNumberOfBlood());
        this.setPuddleFrequency(config.getPuddleFrequency());
        this.setNumberOfPuddles(config.getNumberOfPuddles());
        this.setDecorationsOn(config.isDecorationsOn());
        this.setSeaLevel(config.getSeaLevel());
        this.setMinecraftConstraintsOn(config.isMinecraftConstraintsOn());
        this.setSupportOn(config.isSupportOn());
    }

    public LevelConfig copy() {
        return new LevelConfig(this);
    }

    public Quantity getNumberOfRooms() {
        return this.numberOfRooms;
    }

    public void setNumberOfRooms(Quantity numberOfRooms) {
        this.numberOfRooms = numberOfRooms;
    }

    public Quantity getWidth() {
        return this.width;
    }

    public void setWidth(Quantity width) {
        this.width = width;
    }

    public Quantity getDepth() {
        return this.depth;
    }

    public void setDepth(Quantity depth) {
        this.depth = depth;
    }

    public Quantity getHeight() {
        return this.height;
    }

    public void setHeight(Quantity height) {
        this.height = height;
    }

    public Quantity getXDistance() {
        return this.xDistance;
    }

    public void setXDistance(Quantity distance) {
        this.xDistance = distance;
    }

    public Quantity getNumberOfEdges() {
        return this.degrees;
    }

    public void setNumberOfEdges(Quantity numberOfEdges) {
        this.degrees = numberOfEdges;
    }

    public Quantity getDegrees() {
        return this.degrees;
    }

    public void setDegrees(Quantity degrees) {
        this.degrees = degrees;
    }

    public Quantity getZDistance() {
        return this.zDistance;
    }

    public void setZDistance(Quantity zDistance) {
        this.zDistance = zDistance;
    }

    public Quantity getYVariance() {
        return this.yVariance;
    }

    public void setYVariance(Quantity yVariance) {
        this.yVariance = yVariance;
    }

    public Integer getSurfaceBuffer() {
        return this.surfaceBuffer;
    }

    public void setSurfaceBuffer(Integer surfaceBuffer) {
        this.surfaceBuffer = surfaceBuffer;
    }

    public boolean isMinecraftConstraintsOn() {
        return this.minecraftConstraintsOn;
    }

    public void setMinecraftConstraintsOn(boolean minecraftConstraintsOn) {
        this.minecraftConstraintsOn = minecraftConstraintsOn;
    }

    public int getDecayMultiplier() {
        return this.decayMultiplier;
    }

    public void setDecayMultiplier(int decayMultiplier) {
        this.decayMultiplier = decayMultiplier;
    }

    public boolean isSupportOn() {
        return this.supportOn;
    }

    public void setSupportOn(boolean supportOn) {
        this.supportOn = supportOn;
    }

    public Quantity getSpawnerFrequency() {
        return this.spawnerFrequency;
    }

    public void setSpawnerFrequency(Quantity spawnerFrequency) {
        this.spawnerFrequency = spawnerFrequency;
    }

    public Quantity getChestFrequency() {
        return this.chestFrequency;
    }

    public void setChestFrequency(Quantity chestFrequency) {
        this.chestFrequency = chestFrequency;
    }

    public boolean isDecorationsOn() {
        return this.decorationsOn;
    }

    public void setDecorationsOn(boolean decorationsOn) {
        this.decorationsOn = decorationsOn;
    }

    public Quantity getWebFrequency() {
        return this.webFrequency;
    }

    public void setWebFrequency(Quantity webFrequency) {
        this.webFrequency = webFrequency;
    }

    public Quantity getVineFrequency() {
        return this.vineFrequency;
    }

    public void setVineFrequency(Quantity vineFrequency) {
        this.vineFrequency = vineFrequency;
    }

    public Quantity getNumberOfWebs() {
        return this.numberOfWebs;
    }

    public void setNumberOfWebs(Quantity numberOfWebs) {
        this.numberOfWebs = numberOfWebs;
    }

    public Quantity getNumberOfVines() {
        return this.numberOfVines;
    }

    public void setNumberOfVines(Quantity numberOfVines) {
        this.numberOfVines = numberOfVines;
    }

    public List<String> getChestCategories() {
        if (this.chestCategories == null) {
            this.chestCategories = new ArrayList<String>();
        }
        return this.chestCategories;
    }

    public void setChestCategories(List<String> chestCategories) {
        this.chestCategories = chestCategories;
    }

    public Quantity getAnywhereDecorationFrequency() {
        return this.anywhereDecorationFrequency;
    }

    public Quantity getNumberOfAnywhereDecorations() {
        return this.numberOfAnywhereDecorations;
    }

    public void setAnywhereDecorationFrequency(Quantity anywhereDecorationFrequency) {
        this.anywhereDecorationFrequency = anywhereDecorationFrequency;
    }

    public void setNumberOfAnywhereDecorations(Quantity numberOfAnywhereDecorations) {
        this.numberOfAnywhereDecorations = numberOfAnywhereDecorations;
    }

    public Quantity getBloodFrequency() {
        return this.bloodFrequency;
    }

    public Quantity getNumberOfBlood() {
        return this.numberOfBlood;
    }

    public void setBloodFrequency(Quantity bloodFrequency) {
        this.bloodFrequency = bloodFrequency;
    }

    public void setNumberOfBlood(Quantity numberOfBlood) {
        this.numberOfBlood = numberOfBlood;
    }

    public Quantity getPuddleFrequency() {
        return this.puddleFrequency;
    }

    public Quantity getNumberOfPuddles() {
        return this.numberOfPuddles;
    }

    public void setPuddleFrequency(Quantity puddleFrequency) {
        this.puddleFrequency = puddleFrequency;
    }

    public void setNumberOfPuddles(Quantity numberOfPuddles) {
        this.numberOfPuddles = numberOfPuddles;
    }

    public String toString() {
        return "LevelConfig [numberOfRooms=" + this.numberOfRooms + ", width=" + this.width + ", depth=" + this.depth + ", height=" + this.height + ", xDistance=" + this.xDistance + ", zDistance=" + this.zDistance + ", yVariance=" + this.yVariance + ", degrees=" + this.degrees + ", decayMultiplier=" + this.decayMultiplier + ", surfaceBuffer=" + this.surfaceBuffer + ", spawnerFrequency=" + this.spawnerFrequency + ", chestFrequency=" + this.chestFrequency + ", chestCategories=" + this.chestCategories + ", webFrequency=" + this.webFrequency + ", numberOfWebs=" + this.numberOfWebs + ", vineFrequency=" + this.vineFrequency + ", numberOfVines=" + this.numberOfVines + ", anywhereDecorationFrequency=" + this.anywhereDecorationFrequency + ", numberOfAnywhereDecorations=" + this.numberOfAnywhereDecorations + ", bloodFrequency=" + this.bloodFrequency + ", numberOfBlood=" + this.numberOfBlood + ", puddleFrequency=" + this.puddleFrequency + ", numberOfPuddles=" + this.numberOfPuddles + ", decorationsOn=" + this.decorationsOn + ", minecraftConstraintsOn=" + this.minecraftConstraintsOn + ", supportOn=" + this.supportOn + "]";
    }

    public Quantity getYRange() {
        return this.yRange;
    }

    public void setYRange(Quantity yRange) {
        this.yRange = yRange;
    }

    public int getSeaLevel() {
        return this.seaLevel;
    }

    public void setSeaLevel(int seaLevel) {
        this.seaLevel = seaLevel;
    }
}

