/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.persistence;

import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.config.BuildDirection;
import com.someguyssoftware.dungeons2.config.BuildPattern;
import com.someguyssoftware.dungeons2.config.BuildSize;
import com.someguyssoftware.dungeons2.model.DungeonInfo;
import com.someguyssoftware.dungeons2.registry.DungeonRegistry;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class DungeonsGenSavedData
extends WorldSavedData {
    public static final String DUNGEONS_GEN_DATA_KEY = "dungeons2GenData";

    public DungeonsGenSavedData() {
        super(DUNGEONS_GEN_DATA_KEY);
    }

    public DungeonsGenSavedData(String key) {
        super(key);
    }

    public void func_76184_a(NBTTagCompound tag) {
        Dungeons2.log.debug("Loading Dungeons2! saved gen data...");
        NBTTagCompound dungeonGen = tag.func_74775_l("dungeonGenerator");
        Dungeons2.dungeonsWorldGen.setChunksSinceLastDungeon(dungeonGen.func_74762_e("chunksSinceLastDungeon"));
        NBTTagCompound pos = tag.func_74775_l("lastDungeonBlockPos");
        int x = pos.func_74762_e("x");
        int y = pos.func_74762_e("y");
        int z = pos.func_74762_e("z");
        Dungeons2.dungeonsWorldGen.setLastDungeonCoords((ICoords)new Coords(x, y, z));
        NBTTagList registryTagList = tag.func_150295_c("registry", 10);
        for (int i = 0; i < registryTagList.func_74745_c(); ++i) {
            NBTTagCompound infoTag = registryTagList.func_150305_b(i);
            int dx = infoTag.func_74762_e("x");
            int dy = infoTag.func_74762_e("y");
            int dz = infoTag.func_74762_e("z");
            int minX = infoTag.func_74762_e("minX");
            int minY = infoTag.func_74762_e("minY");
            int minZ = infoTag.func_74762_e("minZ");
            int maxX = infoTag.func_74762_e("maxX");
            int maxY = infoTag.func_74762_e("maxY");
            int maxZ = infoTag.func_74762_e("maxZ");
            int levels = infoTag.func_74762_e("levels");
            String theme = infoTag.func_74779_i("theme");
            String pattern = infoTag.func_74779_i("pattern");
            String size = infoTag.func_74779_i("size");
            String levelSize = infoTag.func_74779_i("levelSize");
            String direction = infoTag.func_74779_i("direction");
            int bossX = infoTag.func_74762_e("bossChestX");
            int bossY = infoTag.func_74762_e("bossChestY");
            int bossZ = infoTag.func_74762_e("bossChestZ");
            try {
                DungeonInfo info = new DungeonInfo();
                info.setCoords((ICoords)new Coords(dx, dy, dz));
                info.setMinX(minX);
                info.setMinY(minY);
                info.setMinZ(minZ);
                info.setMaxX(maxX);
                info.setMaxY(maxY);
                info.setMaxZ(maxZ);
                info.setLevels(levels);
                info.setThemeName(theme);
                if (!pattern.equals("")) {
                    info.setPattern(BuildPattern.valueOf(pattern));
                }
                if (!size.equals("")) {
                    info.setSize(BuildSize.valueOf(size));
                }
                if (!levelSize.equals("")) {
                    info.setLevelSize(BuildSize.valueOf(levelSize));
                }
                if (!direction.equals("")) {
                    info.setDirection(BuildDirection.valueOf(direction));
                }
                info.setBossChestCoords((ICoords)new Coords(bossX, bossY, bossZ));
                DungeonRegistry.getInstance().register(info.getCoords().toShortString(), info);
                continue;
            }
            catch (Exception e) {
                Dungeons2.log.error((Object)e);
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tag) {
        try {
            NBTTagCompound dungeonGen = new NBTTagCompound();
            dungeonGen.func_74768_a("chunksSinceLastDungeon", Dungeons2.dungeonsWorldGen.getChunksSinceLastDungeon());
            tag.func_74782_a("dungeonGenerator", (NBTBase)dungeonGen);
            NBTTagCompound pos = new NBTTagCompound();
            if (Dungeons2.dungeonsWorldGen.getLastDungeonCoords() != null) {
                pos.func_74768_a("x", Dungeons2.dungeonsWorldGen.getLastDungeonCoords().getX());
                pos.func_74768_a("y", Dungeons2.dungeonsWorldGen.getLastDungeonCoords().getY());
                pos.func_74768_a("z", Dungeons2.dungeonsWorldGen.getLastDungeonCoords().getZ());
                tag.func_74782_a("lastDungeonBlockPos", (NBTBase)pos);
            }
            NBTTagList registryTagList = new NBTTagList();
            for (DungeonInfo info : DungeonRegistry.getInstance().getEntries()) {
                NBTTagCompound infoTag = new NBTTagCompound();
                if (info != null) {
                    if (info.getCoords() != null) {
                        infoTag.func_74768_a("x", info.getCoords().getX());
                        infoTag.func_74768_a("y", info.getCoords().getY());
                        infoTag.func_74768_a("z", info.getCoords().getZ());
                    }
                    infoTag.func_74768_a("minX", info.getMinX());
                    infoTag.func_74768_a("minY", info.getMinY());
                    infoTag.func_74768_a("minZ", info.getMinZ());
                    infoTag.func_74768_a("maxX", info.getMaxX());
                    infoTag.func_74768_a("maxY", info.getMaxY());
                    infoTag.func_74768_a("maxZ", info.getMaxZ());
                    infoTag.func_74768_a("levels", info.getLevels());
                    if (info.getThemeName() != null) {
                        infoTag.func_74778_a("theme", info.getThemeName());
                    }
                    if (info.getPattern() != null) {
                        infoTag.func_74778_a("pattern", info.getPattern().name());
                    }
                    if (info.getSize() != null) {
                        infoTag.func_74778_a("size", info.getSize().name());
                    }
                    if (info.getLevelSize() != null) {
                        infoTag.func_74778_a("levelSize", info.getLevelSize().name());
                    }
                    if (info.getDirection() != null) {
                        infoTag.func_74778_a("direction", info.getDirection().name());
                    }
                    if (info.getBossChestCoords() != null) {
                        infoTag.func_74768_a("bossChestX", info.getBossChestCoords().getX());
                        infoTag.func_74768_a("bossChestY", info.getBossChestCoords().getY());
                        infoTag.func_74768_a("bossChestZ", info.getBossChestCoords().getZ());
                    }
                }
                registryTagList.func_74742_a((NBTBase)infoTag);
            }
            tag.func_74782_a("registry", (NBTBase)registryTagList);
        }
        catch (Exception e) {
            e.printStackTrace();
            Dungeons2.log.error("An exception occurred:", (Throwable)e);
        }
        return tag;
    }

    public static DungeonsGenSavedData get(World world) {
        DungeonsGenSavedData data = (DungeonsGenSavedData)world.func_72943_a(DungeonsGenSavedData.class, DUNGEONS_GEN_DATA_KEY);
        if (data == null) {
            data = new DungeonsGenSavedData();
            world.func_72823_a(DUNGEONS_GEN_DATA_KEY, (WorldSavedData)data);
        }
        return data;
    }
}

