/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.printer;

import com.someguyssoftware.dungeons2.model.Door;
import com.someguyssoftware.dungeons2.model.Room;
import java.util.Arrays;

public class RoomPrettyPrinter {
    private static final String div;
    private static final String sub;
    private static String format;
    private static String format2;
    private static String heading;
    private static String heading2;

    public String print(Room room) {
        return this.print(room, "Room");
    }

    public String print(Room room, String title) {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(div).append(String.format(heading, title)).append(div).append(String.format(heading, "[Properties]")).append(String.format(format, "ID", room.getId())).append(String.format(format, "Name", room.getName()));
            if (room.getCoords() != null) {
                sb.append(String.format(format, "Location", room.getBottomCenter().toShortString()));
            }
            sb.append(String.format(format, new Object[]{"Type", room.getType()})).append(String.format(format, "Direction", room.getDirection())).append(String.format(format, "Degrees", room.getDegrees())).append(String.format(format, "Is Anchor", room.isAnchor())).append(String.format(format, "Is Obstacle", room.isObstacle())).append(String.format(format, "Is Rejected", room.isReject()));
            if (room.getLayout() != null) {
                sb.append(String.format(format, "Layout", room.getLayout().getName()));
            }
            sb.append(String.format(format, "X Dimensions", String.format("%s <--> %s", room.getMinX(), room.getMaxX()))).append(String.format(format, "Y Dimensions", String.format("%s <--> %s", room.getMinY(), room.getMaxY()))).append(String.format(format, "Z Dimensions", String.format("%s <--> %s", room.getMinZ(), room.getMaxZ())));
            if (room.getDoors() != null) {
                sb.append(String.format(format, "# of Doors", room.getDoors().size()));
                for (Door d : room.getDoors()) {
                    sb.append(sub).append(String.format(heading2, "[Door]")).append(String.format(format2, "Location", d.getCoords().toShortString())).append(String.format(format2, "Direction", d.getDirection()));
                    if (d.getHallway() == null) continue;
                    sb.append(String.format(format2, "Leads To Hallway", d.getHallway().getId()));
                    if (d.getHallway().getDoors().size() > 1) {
                        sb.append(String.format(heading2, "[Hallway]"));
                        Door d2 = null;
                        d2 = d.getHallway().getDoors().get(0).getRoom() != room ? d.getHallway().getDoors().get(0) : d.getHallway().getDoors().get(1);
                        sb.append(String.format(format2, "Leads To Room", d2.getRoom().getId()));
                        continue;
                    }
                    sb.append("Error with hallway.");
                }
            }
            sb.append(div);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return sb.toString();
    }

    static {
        format = "**    %1$-33s: %2$-30s  **\n";
        format2 = "**++    %1$-31s: %2$-28s  ++**\n";
        heading = "**  %1$-67s  **\n";
        heading2 = "**++  %1$-63s  ++**\n";
        char[] chars = new char[75];
        Arrays.fill(chars, '*');
        div = new String(chars) + "\n";
        Arrays.fill(chars, '+');
        chars[74] = 42;
        chars[73] = 42;
        chars[1] = 42;
        chars[0] = 42;
        sub = new String(chars) + "\n";
    }
}

