/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.rotate;

import com.google.common.base.Predicate;
import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.block.BasicFacadeBlock;
import com.someguyssoftware.dungeons2.block.CorniceFacadeBlock;
import com.someguyssoftware.dungeons2.block.CrownMoldingFacadeBlock;
import com.someguyssoftware.dungeons2.block.FlutePillarBlock;
import com.someguyssoftware.dungeons2.block.FlutePillarFacadeBlock;
import com.someguyssoftware.dungeons2.block.SevenEightsPillarFacadeBlock;
import com.someguyssoftware.dungeons2.block.TeePillarFacadeBlock;
import com.someguyssoftware.dungeons2.block.TeeThinPillarFacadeBlock;
import com.someguyssoftware.dungeons2.rotate.CardinalDirectionRotator;
import com.someguyssoftware.dungeons2.rotate.DirectionalRotator;
import com.someguyssoftware.dungeons2.rotate.IRotator;
import com.someguyssoftware.dungeons2.rotate.LeverRotator;
import com.someguyssoftware.dungeons2.rotate.LogRotator;
import com.someguyssoftware.dungeons2.rotate.RelativeDirectionRotator;
import com.someguyssoftware.dungeons2.rotate.RotatorRegistry;
import com.someguyssoftware.dungeons2.rotate.VineRotator;
import com.someguyssoftware.gottschcore.block.CardinalDirectionBlock;
import com.someguyssoftware.gottschcore.block.CardinalDirectionFacadeBlock;
import com.someguyssoftware.gottschcore.block.RelativeDirectionBlock;
import com.someguyssoftware.gottschcore.block.RelativeDirectionFacadeBlock;
import com.someguyssoftware.gottschcore.enums.Direction;
import com.someguyssoftware.gottschcore.enums.Rotate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;

public class RotatorHelper {
    private static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static IRotator facingRotator = new DirectionalRotator();
    private static IRotator logRotator = new LogRotator();
    private static IRotator leverRotator = new LeverRotator();

    private RotatorHelper() {
    }

    private static void registerBlocks() {
        RelativeDirectionRotator relativeDirectionBlockRotator = new RelativeDirectionRotator();
        CardinalDirectionRotator cardinalDirectionBlockRotator = new CardinalDirectionRotator();
        VineRotator vineRotator = new VineRotator();
        RotatorRegistry registry = RotatorRegistry.getInstance();
        registry.registerBlockRotator(BlockLog.class, logRotator, (Object)Dungeons2.instance);
        registry.registerBlockRotator(BlockOldLog.class, logRotator, (Object)Dungeons2.instance);
        registry.registerBlockRotator(BlockLever.class, leverRotator, (Object)Dungeons2.instance);
        registry.registerBlockRotator(BlockVine.class, vineRotator, (Object)Dungeons2.instance);
        registry.registerBlockRotator(RelativeDirectionBlock.class, relativeDirectionBlockRotator, (Object)Dungeons2.instance);
        registry.registerBlockRotator(RelativeDirectionFacadeBlock.class, relativeDirectionBlockRotator, (Object)Dungeons2.instance);
        registry.registerBlockRotator(CardinalDirectionBlock.class, cardinalDirectionBlockRotator, (Object)Dungeons2.instance);
        registry.registerBlockRotator(CardinalDirectionFacadeBlock.class, cardinalDirectionBlockRotator, (Object)Dungeons2.instance);
        registry.registerBlockRotator(BasicFacadeBlock.class, cardinalDirectionBlockRotator, (Object)Dungeons2.instance);
        registry.registerBlockRotator(FlutePillarFacadeBlock.class, cardinalDirectionBlockRotator, (Object)Dungeons2.instance);
        registry.registerBlockRotator(CrownMoldingFacadeBlock.class, cardinalDirectionBlockRotator, (Object)Dungeons2.instance);
        registry.registerBlockRotator(CorniceFacadeBlock.class, cardinalDirectionBlockRotator, (Object)Dungeons2.instance);
        registry.registerBlockRotator(TeeThinPillarFacadeBlock.class, cardinalDirectionBlockRotator, (Object)Dungeons2.instance);
        registry.registerBlockRotator(TeePillarFacadeBlock.class, cardinalDirectionBlockRotator, (Object)Dungeons2.instance);
        registry.registerBlockRotator(FlutePillarBlock.class, cardinalDirectionBlockRotator, (Object)Dungeons2.instance);
        registry.registerBlockRotator(FlutePillarFacadeBlock.class, cardinalDirectionBlockRotator, (Object)Dungeons2.instance);
        registry.registerBlockRotator(SevenEightsPillarFacadeBlock.class, cardinalDirectionBlockRotator, (Object)Dungeons2.instance);
    }

    public static IBlockState rotateBlock(IBlockState blockState, Direction direction) {
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_150350_a || block instanceof BlockSlab) {
            return blockState;
        }
        IRotator rotator = null;
        if (RotatorRegistry.getInstance().has(block.getClass())) {
            rotator = RotatorRegistry.getInstance().get(block.getClass());
        } else if (blockState.func_177228_b().containsKey((Object)FACING)) {
            rotator = facingRotator;
        } else {
            Dungeons2.log.debug("Can not locate rotator for block: " + block.getClass().getName());
        }
        if (rotator == null) {
            Dungeons2.log.debug("Rotator is null.");
            return blockState;
        }
        return rotator.rotate(blockState, direction);
    }

    public static IBlockState rotateBlock(IBlockState blockState, Rotate rotate) {
        Block block = blockState.func_177230_c();
        IRotator rotator = null;
        if (blockState.func_177228_b().containsKey((Object)FACING)) {
            rotator = facingRotator;
        } else if (RotatorRegistry.getInstance().has(block.getClass())) {
            rotator = RotatorRegistry.getInstance().get(block.getClass());
        }
        if (rotator == null) {
            return blockState;
        }
        int rotatedMeta = 0;
        rotatedMeta = rotator.rotate(blockState, rotate);
        IBlockState rotatedBlockState = block.func_176203_a(rotatedMeta);
        return rotatedBlockState;
    }

    static {
        RotatorHelper.registerBlocks();
    }
}

