/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.style;

import com.someguyssoftware.dungeons2.style.Face;
import com.someguyssoftware.gottschcore.enums.IEnum;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum DesignElement implements IEnum
{
    NONE(-1, "none", 0, 0),
    AIR(0, "air", 0, 0),
    SURFACE_AIR(1, "surface_air", 0, 0),
    FLOOR_AIR((Integer)2, "floor_air", (Integer)0, (Integer)0, SURFACE_AIR),
    WALL_AIR((Integer)3, "wall_air", (Integer)0, (Integer)0, SURFACE_AIR),
    CEILING_AIR((Integer)4, "ceiling_air", (Integer)0, (Integer)0, SURFACE_AIR),
    FACADE(5, "facade", 100, 0),
    FLOOR(101, "floor", 100, 50),
    WALL(102, "wall", 100, 50),
    CEILING(103, "ceiling", 100, 50),
    CROWN(104, "crown", 100, 0, Face.INTERIOR, FACADE),
    TRIM(105, "trim", 0, 0, Face.INTERIOR, FACADE),
    CORNICE(106, "cornice", 100, 0, Face.EXTERIOR, FACADE),
    PLINTH(107, "plinth", 0, 0, Face.EXTERIOR, FACADE),
    PILLAR((Integer)108, "pillar", (Integer)100, (Integer)100, Face.INTERIOR),
    PILASTER((Integer)109, "pilaster", (Integer)100, (Integer)100, Face.INTERIOR),
    COLUMN((Integer)110, "column", (Integer)100, (Integer)100, Face.EXTERIOR),
    BASE((Integer)111, "base", (Integer)100, (Integer)0, Face.EXTERIOR),
    CAPITAL((Integer)112, "capital", (Integer)100, (Integer)0, Face.EXTERIOR),
    COFFERED_MIDBEAM((Integer)113, "coffered_mid_beam", (Integer)100, (Integer)100, Face.INTERIOR),
    COFFERED_CROSSBEAM((Integer)114, "coffered_crossbeam", (Integer)100, (Integer)100, Face.INTERIOR),
    GUTTER(115, "gutter", 100, 50),
    GRATE(116, "grate", 100, 50),
    SCONCE(117, "sconce", 0, 0),
    DOOR(118, "door", 100, 50),
    LADDER(119, "ladder", 100, 0),
    LADDER_PILLAR(120, "ladder_pillar", 100, 100),
    CHEST(122, "chest", 100, 0),
    SPAWNER(123, "spawner", 100, 0),
    CRENELLATION((Integer)124, "crenellation", (Integer)100, (Integer)50, Face.EXTERIOR),
    PARAPET((Integer)125, "parapet", (Integer)100, (Integer)50, Face.EXTERIOR),
    MERLON((Integer)126, "merlon", (Integer)100, (Integer)50, Face.EXTERIOR),
    PILASTER_CAPITAL((Integer)127, "pilaster_capital", (Integer)100, (Integer)0, Face.INTERIOR),
    PILASTER_BASE((Integer)128, "pilaster_base", (Integer)100, (Integer)0, Face.INTERIOR),
    PILLAR_CAPITAL((Integer)129, "pillar_capital", (Integer)100, (Integer)0, Face.INTERIOR),
    PILLAR_BASE((Integer)130, "pillar_base", (Integer)100, (Integer)0, Face.INTERIOR),
    WINDOW(131, "widow", 100, 0),
    FLOOR_ALT((Integer)132, "floor_alt", (Integer)100, (Integer)50, FLOOR),
    WALL_BASE((Integer)133, "wall_base", (Integer)100, (Integer)50, WALL),
    WALL_CAPITAL((Integer)134, "wall_capital", (Integer)10, (Integer)50, WALL),
    FACADE_SUPPORT((Integer)6, "facade_support", (Integer)100, (Integer)100, WALL);

    private static final Map<Integer, IEnum> codes;
    private static final Map<String, IEnum> values;
    private Integer code;
    private String value;
    private Integer horizontalSupport;
    private Integer verticalSupport;
    private Face face;
    private DesignElement family;

    private DesignElement(Integer code, String value, Integer vSupport, Integer hSupport) {
        this.code = code;
        this.value = value;
        this.horizontalSupport = hSupport;
        this.verticalSupport = vSupport;
    }

    private DesignElement(Integer code, String value, Integer vSupport, Integer hSupport, Face face) {
        this.code = code;
        this.value = value;
        this.horizontalSupport = hSupport;
        this.verticalSupport = vSupport;
        this.face = face;
    }

    private DesignElement(Integer code, String value, Integer vSupport, Integer hSupport, DesignElement family) {
        this.code = code;
        this.value = value;
        this.horizontalSupport = hSupport;
        this.verticalSupport = vSupport;
        this.family = family;
    }

    private DesignElement(Integer code, String value, Integer vSupport, Integer hSupport, Face face, DesignElement family) {
        this.code = code;
        this.value = value;
        this.horizontalSupport = hSupport;
        this.verticalSupport = vSupport;
        this.face = face;
        this.family = family;
    }

    public String getName() {
        return this.name();
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static DesignElement getByCode(Integer code) {
        return (DesignElement)codes.get(code);
    }

    public static DesignElement getByValue(String value) {
        return (DesignElement)values.get(value);
    }

    public Map<Integer, IEnum> getCodes() {
        return codes;
    }

    public Map<String, IEnum> getValues() {
        return values;
    }

    public Integer getHorizontalSupport() {
        return this.horizontalSupport;
    }

    public void setHorizontalSupport(Integer support) {
        this.horizontalSupport = support;
    }

    public Integer getVerticalSupport() {
        return this.verticalSupport;
    }

    public void setVerticalSupport(Integer verticalSupport) {
        this.verticalSupport = verticalSupport;
    }

    public Face getFace() {
        return this.face;
    }

    public void setFace(Face face) {
        this.face = face;
    }

    public DesignElement getFamily() {
        return this.family;
    }

    public void setFamily(DesignElement family) {
        this.family = family;
    }

    static {
        codes = new HashMap<Integer, IEnum>();
        values = new HashMap<String, IEnum>();
        for (DesignElement x : EnumSet.allOf(DesignElement.class)) {
            codes.put(x.getCode(), x);
            values.put(x.getValue(), x);
        }
    }
}

