/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.style;

import com.someguyssoftware.dungeons2.generator.Location;
import com.someguyssoftware.dungeons2.generator.blockprovider.IDungeonsBlockProvider;
import com.someguyssoftware.dungeons2.model.LevelConfig;
import com.someguyssoftware.dungeons2.model.Room;
import com.someguyssoftware.dungeons2.style.DesignElement;
import com.someguyssoftware.dungeonsengine.config.ILevelConfig;
import com.someguyssoftware.gottschcore.Quantity;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public interface IRoomDecorator {
    public void decorate(World var1, Random var2, IDungeonsBlockProvider var3, Room var4, LevelConfig var5);

    public void decorate(World var1, Random var2, IDungeonsBlockProvider var3, Room var4, ILevelConfig var5);

    default public void addBlock(World world, Random random, IDungeonsBlockProvider provider, Room room, List<Map.Entry<DesignElement, ICoords>> zone, IBlockState[] states, Quantity frequency, Quantity number, ILevelConfig config) {
        IBlockState state = null;
        double freq = RandomHelper.randomDouble((Random)random, (double)frequency.getMin(), (double)frequency.getMax());
        int scaledNum = this.scaleNumForSizeOfRoom(room, RandomHelper.randomInt((Random)random, (int)number.getMinInt(), (int)number.getMaxInt()), config);
        for (int i = 0; i < scaledNum; ++i) {
            double n = random.nextDouble() * 100.0;
            if (!(n < freq) || zone.size() <= 0) continue;
            int zoneIndex = random.nextInt(zone.size());
            Map.Entry<DesignElement, ICoords> entry = zone.get(zoneIndex);
            DesignElement elem = zone.get(zoneIndex).getKey();
            ICoords coords = entry.getValue();
            if (!this.hasSupport(world, coords, elem, provider.getLocation(coords, room, room.getLayout()))) continue;
            state = states.length == 1 ? states[0] : states[random.nextInt(states.length)];
            world.func_180501_a(coords.toPos(), state, 3);
            zone.remove(entry);
        }
    }

    @Deprecated
    default public void addBlock(World world, Random random, IDungeonsBlockProvider provider, Room room, List<Map.Entry<DesignElement, ICoords>> zone, IBlockState[] states, Quantity frequency, Quantity number, LevelConfig config) {
        IBlockState state = null;
        double freq = RandomHelper.randomDouble((Random)random, (double)frequency.getMin(), (double)frequency.getMax());
        int scaledNum = this.scaleNumForSizeOfRoom(room, RandomHelper.randomInt((Random)random, (int)number.getMinInt(), (int)number.getMaxInt()), config);
        for (int i = 0; i < scaledNum; ++i) {
            double n = random.nextDouble() * 100.0;
            if (!(n < freq) || zone.size() <= 0) continue;
            int zoneIndex = random.nextInt(zone.size());
            Map.Entry<DesignElement, ICoords> entry = zone.get(zoneIndex);
            DesignElement elem = zone.get(zoneIndex).getKey();
            ICoords coords = entry.getValue();
            if (!this.hasSupport(world, coords, elem, provider.getLocation(coords, room, room.getLayout()))) continue;
            state = states.length == 1 ? states[0] : states[random.nextInt(states.length)];
            world.func_180501_a(coords.toPos(), state, 3);
            zone.remove(entry);
        }
    }

    default public boolean hasSupport(World world, ICoords coords, DesignElement elem, Location location) {
        BlockPos pos = coords.toPos();
        IBlockState blockState = null;
        Block block = null;
        if (elem == DesignElement.FLOOR_AIR) {
            blockState = world.func_180495_p(pos.func_177982_a(0, -1, 0));
        } else if (elem == DesignElement.CEILING_AIR) {
            blockState = world.func_180495_p(pos.func_177982_a(0, 1, 0));
        } else if (elem == DesignElement.WALL_AIR) {
            switch (location) {
                case NORTH_SIDE: {
                    blockState = world.func_180495_p(pos.func_177982_a(0, 0, -1));
                    break;
                }
                case EAST_SIDE: {
                    blockState = world.func_180495_p(pos.func_177982_a(1, 0, 0));
                    break;
                }
                case SOUTH_SIDE: {
                    blockState = world.func_180495_p(pos.func_177982_a(0, 0, 1));
                    break;
                }
                case WEST_SIDE: {
                    blockState = world.func_180495_p(pos.func_177982_a(-1, 0, 0));
                    break;
                }
            }
        }
        return blockState != null && !(block = blockState.func_177230_c()).isAir(blockState, (IBlockAccess)world, pos) && !block.isLeaves(blockState, (IBlockAccess)world, pos) && !block.isFoliage((IBlockAccess)world, pos) && !blockState.func_185904_a().func_76222_j();
    }

    default public int scaleNumForSizeOfRoom(Room room, int numDecorations, ILevelConfig config) {
        int size = (room.getWidth() - 2) * (room.getDepth() - 2) * (room.getHeight() - 2);
        int halfOfMax = (config.getWidth().getMaxInt() - 2) * (config.getDepth().getMaxInt() - 2) * (config.getHeight().getMaxInt() - 2) / 2;
        float factor = 1.0f;
        if (size <= 27) {
            factor = 0.25f;
        } else if (size < halfOfMax) {
            factor = 0.5f;
        }
        int num = (int)((float)numDecorations * factor);
        return num;
    }

    @Deprecated
    default public int scaleNumForSizeOfRoom(Room room, int numDecorations, LevelConfig config) {
        int size = (room.getWidth() - 2) * (room.getDepth() - 2) * (room.getHeight() - 2);
        int halfOfMax = (config.getWidth().getMaxInt() - 2) * (config.getDepth().getMaxInt() - 2) * (config.getHeight().getMaxInt() - 2) / 2;
        float factor = 1.0f;
        if (size <= 27) {
            factor = 0.25f;
        } else if (size < halfOfMax) {
            factor = 0.5f;
        }
        int num = (int)((float)numDecorations * factor);
        return num;
    }

    default public EnumFacing orientChest(Location location) {
        EnumFacing facing = null;
        switch (location) {
            case NORTH_SIDE: {
                facing = EnumFacing.SOUTH;
                break;
            }
            case SOUTH_SIDE: {
                facing = EnumFacing.NORTH;
                break;
            }
            case EAST_SIDE: {
                facing = EnumFacing.WEST;
                break;
            }
            case WEST_SIDE: {
                facing = EnumFacing.EAST;
                break;
            }
            default: {
                facing = EnumFacing.NORTH;
            }
        }
        return facing;
    }
}

