/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.style;

import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.style.DesignElement;
import com.someguyssoftware.dungeons2.style.Layout;
import com.someguyssoftware.dungeons2.style.Style;
import com.someguyssoftware.dungeons2.style.Theme;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class StyleSheet {
    private Map<String, Theme> themes;
    private Map<String, Style> styles = new LinkedHashMap<String, Style>();
    private Map<String, Layout> layouts = new LinkedHashMap<String, Layout>();

    public StyleSheet() {
        this.themes = new LinkedHashMap<String, Theme>();
    }

    public boolean hasFrame(Layout layout, DesignElement element) {
        boolean hasFrame = false;
        ArrayList<String> layoutRefs = null;
        do {
            if (layout.getFrames().containsKey(element.name())) {
                hasFrame = true;
                return hasFrame;
            }
            if (layout.getRef() != null) {
                if (layoutRefs == null) {
                    layoutRefs = new ArrayList<String>(5);
                }
                if (layoutRefs.contains(layout.getRef())) {
                    Dungeons2.log.warn(String.format("Stylesheet layout circular dependency: %s. Using defaults.", layout.getRef()));
                    break;
                }
                if (layoutRefs.size() == 5) {
                    Dungeons2.log.warn("Too many Stylesheet layout references (5 max allowed. Using defaults.");
                    break;
                }
                layoutRefs.add(layout.getRef());
                layout = this.getLayouts().get(layout.getRef());
                continue;
            }
            layout = null;
        } while (!hasFrame && layout != null);
        return hasFrame;
    }

    public Map<String, Style> getStyles() {
        return this.styles;
    }

    public void setStyles(Map<String, Style> styles) {
        this.styles = styles;
    }

    public Map<String, Layout> getLayouts() {
        return this.layouts;
    }

    public void setLayouts(Map<String, Layout> layouts) {
        this.layouts = layouts;
    }

    public Map<String, Theme> getThemes() {
        return this.themes;
    }

    public void setThemes(Map<String, Theme> themes) {
        this.themes = themes;
    }

    public String toString() {
        return "StyleSheet [styles=" + this.styles + ", layouts=" + this.layouts + ", themes=" + this.themes + "]";
    }
}

