/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.worldgen;

import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.builder.DungeonBuilderTopDown;
import com.someguyssoftware.dungeons2.builder.IDungeonBuilder;
import com.someguyssoftware.dungeons2.builder.LevelBuilder;
import com.someguyssoftware.dungeons2.config.BuildPattern;
import com.someguyssoftware.dungeons2.config.BuildSize;
import com.someguyssoftware.dungeons2.config.ModConfig;
import com.someguyssoftware.dungeons2.generator.DungeonGenerator;
import com.someguyssoftware.dungeons2.model.Dungeon;
import com.someguyssoftware.dungeons2.model.DungeonInfo;
import com.someguyssoftware.dungeons2.persistence.DungeonsGenSavedData;
import com.someguyssoftware.dungeons2.printer.DungeonPrettyPrinter;
import com.someguyssoftware.dungeons2.registry.DungeonRegistry;
import com.someguyssoftware.dungeons2.spawner.SpawnSheet;
import com.someguyssoftware.dungeons2.spawner.SpawnSheetLoader;
import com.someguyssoftware.dungeons2.style.StyleSheet;
import com.someguyssoftware.dungeons2.style.StyleSheetLoader;
import com.someguyssoftware.dungeons2.style.Theme;
import com.someguyssoftware.dungeonsengine.config.IDungeonConfig;
import com.someguyssoftware.gottschcore.biome.BiomeHelper;
import com.someguyssoftware.gottschcore.biome.BiomeTypeHolder;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.IRandomProbabilityItem;
import com.someguyssoftware.gottschcore.random.RandomProbabilityCollection;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class DungeonsWorldGen
implements IWorldGenerator {
    public static final int CHUNK_RADIUS = 8;
    private static final double DEFAULT_GENERATION_PROXIMITY_SQAURED = 6400.0;
    private int chunksSinceLastDungeon = 0;
    private ICoords lastDungeonCoords = null;
    private boolean isGenerating = false;
    private List<BiomeTypeHolder> biomeWhiteList;
    private List<BiomeTypeHolder> biomeBlackList;
    private DungeonGenerator generator;
    private StyleSheet styleSheet;
    private SpawnSheet spawnSheet;
    private static RandomProbabilityCollection<IRandomProbabilityItem> patterns = new RandomProbabilityCollection();
    private static RandomProbabilityCollection<IRandomProbabilityItem> levelSizes = new RandomProbabilityCollection();
    private static RandomProbabilityCollection<IRandomProbabilityItem> dungeonSizes = new RandomProbabilityCollection();

    public DungeonsWorldGen() {
        try {
            this.generator = new DungeonGenerator();
            this.init();
        }
        catch (Exception e) {
            Dungeons2.log.error("Unable to instantiate DungeonGenerator:", (Throwable)e);
        }
    }

    public void init() {
        this.biomeWhiteList = new ArrayList<BiomeTypeHolder>(5);
        this.biomeBlackList = new ArrayList<BiomeTypeHolder>(5);
        BiomeHelper.loadBiomeList((String[])ModConfig.generalDungeonBiomeWhiteList, this.biomeWhiteList);
        BiomeHelper.loadBiomeList((String[])ModConfig.generalDungeonBiomeBlackList, this.biomeBlackList);
        patterns.add(76, (IRandomProbabilityItem)new RandomBuildPattern(BuildPattern.SQUARE));
        patterns.add(12, (IRandomProbabilityItem)new RandomBuildPattern(BuildPattern.HORZ));
        patterns.add(12, (IRandomProbabilityItem)new RandomBuildPattern(BuildPattern.VERT));
        levelSizes.add(50, (IRandomProbabilityItem)new RandomBuildSize(BuildSize.SMALL));
        levelSizes.add(25, (IRandomProbabilityItem)new RandomBuildSize(BuildSize.MEDIUM));
        levelSizes.add(15, (IRandomProbabilityItem)new RandomBuildSize(BuildSize.LARGE));
        levelSizes.add(10, (IRandomProbabilityItem)new RandomBuildSize(BuildSize.VAST));
        dungeonSizes.add(30, (IRandomProbabilityItem)new RandomBuildSize(BuildSize.SMALL));
        dungeonSizes.add(25, (IRandomProbabilityItem)new RandomBuildSize(BuildSize.MEDIUM));
        dungeonSizes.add(25, (IRandomProbabilityItem)new RandomBuildSize(BuildSize.LARGE));
        dungeonSizes.add(20, (IRandomProbabilityItem)new RandomBuildSize(BuildSize.VAST));
        try {
            Path folder = Paths.get(ModConfig.dungeonsFolder, "/styleSheets/");
            try {
                Files.createDirectory(folder, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            folder = Paths.get(ModConfig.dungeonsFolder, "/spawnSheets/");
            try {
                Files.createDirectory(folder, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            this.styleSheet = StyleSheetLoader.loadAll();
            if (this.styleSheet == null || this.styleSheet.getStyles() == null || this.styleSheet.getStyles().size() == 0) {
                Dungeons2.log.debug("Stylesheet empty, loading default style sheet...");
                this.styleSheet = StyleSheetLoader.load();
            }
            this.spawnSheet = SpawnSheetLoader.loadAll();
            if (this.spawnSheet == null || this.spawnSheet.getGroups() == null || this.spawnSheet.getGroups().size() == 0) {
                Dungeons2.log.debug("Spawnsheet empty, loading default spawn sheet...");
                this.spawnSheet = SpawnSheetLoader.load();
            }
        }
        catch (Exception e) {
            Dungeons2.log.error("Error loading Style/Chest/Spawn sheet: ", (Throwable)e);
            return;
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        DungeonsGenSavedData savedData;
        if (this.generator == null) {
            return;
        }
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                break;
            }
            default: {
                return;
            }
        }
        boolean isGenerated = false;
        ++this.chunksSinceLastDungeon;
        if (!this.isGenerating() && this.chunksSinceLastDungeon > ModConfig.minChunksPerDungeon) {
            Dungeons2.log.debug(String.format("Gen: pass first test: chunksSinceLast: %d, minChunks: %d", this.chunksSinceLastDungeon, ModConfig.minChunksPerDungeon));
            this.chunksSinceLastDungeon = 0;
            int xSpawn = chunkX * 16 + 8;
            int zSpawn = chunkZ * 16 + 8;
            Coords coords = new Coords(xSpawn, 64, zSpawn);
            if (this.lastDungeonCoords == null || this.lastDungeonCoords.getDistanceSq((ICoords)coords) > (double)(ModConfig.minDistancePerDungeon * ModConfig.minDistancePerDungeon)) {
                if (random.nextInt(100) > ModConfig.dungeonGenProbability) {
                    Dungeons2.log.debug("Dungeon fail generate probability.");
                    return;
                }
                Biome biome = world.func_180494_b(coords.toPos());
                if (WorldInfo.isClientSide((World)world)) {
                    Dungeons2.log.debug("biome -> {}", (Object)biome.func_185359_l());
                }
                if (!BiomeHelper.isBiomeAllowed((Biome)biome, this.biomeWhiteList, this.biomeBlackList)) {
                    if (WorldInfo.isClientSide((World)world)) {
                        Dungeons2.log.debug(String.format("[%s] is not a valid biome.", biome.func_185359_l()));
                    }
                    return;
                }
                if (this.isRegisteredDungeonWithinDistance(world, (ICoords)coords, ModConfig.minDistancePerDungeon)) {
                    Dungeons2.log.debug("The distance to the nearest dungeon is less than the minimun required.");
                    return;
                }
                this.setGenerating(true);
                Integer biomeID = Biome.func_185362_a((Biome)biome);
                Dungeons2.log.debug("biome ID -> {}", (Object)biomeID);
                List<IDungeonConfig> dcList = Dungeons2.CONFIG_MANAGER.getByBiome(biomeID);
                if (dcList == null || dcList.size() == 0) {
                    Dungeons2.log.debug("could not find any dungeon configs for biomeID -> {}", (Object)biomeID);
                    this.setGenerating(false);
                    return;
                }
                IDungeonConfig dc = dcList.get(random.nextInt(dcList.size()));
                Dungeons2.log.debug("selected dungeon config -> {}", (Object)dc);
                Theme theme = this.styleSheet.getThemes().get(this.styleSheet.getThemes().keySet().toArray()[random.nextInt(this.styleSheet.getThemes().size())]);
                LevelBuilder levelBuilder = new LevelBuilder();
                DungeonBuilderTopDown builder = new DungeonBuilderTopDown(levelBuilder);
                Dungeons2.log.debug("Starting BUILD process...");
                Dungeon dungeon = builder.build(world, random, (ICoords)coords, dc);
                Dungeons2.log.debug("BUILD process complete.");
                dungeon.setTheme(theme);
                if (dungeon != null && dungeon != IDungeonBuilder.EMPTY_DUNGEON) {
                    try {
                        Dungeons2.log.debug("Start GENERATE process...");
                        isGenerated = this.generator.generate(world, random, dungeon, this.styleSheet, null, this.spawnSheet);
                        Dungeons2.log.debug("GENERATE process complete.");
                    }
                    catch (FileNotFoundException e) {
                        Dungeons2.log.error("Error generating dungeon @ " + coords.toShortString(), (Throwable)e);
                    }
                }
                if (isGenerated) {
                    DungeonInfo info = new DungeonInfo(dungeon, null, null, null, null);
                    coords = info.getCoords();
                    DungeonRegistry.getInstance().register(coords.toShortString(), info);
                    this.lastDungeonCoords = coords;
                    Dungeons2.log.info("Dungeon generated @ " + coords.toShortString());
                    if (ModConfig.enableDumps) {
                        this.dump(dungeon);
                    }
                }
                this.setGenerating(false);
            }
        }
        if ((savedData = DungeonsGenSavedData.get(world)) != null) {
            savedData.func_76185_a();
        }
    }

    public void dump(Dungeon dungeon) {
        DungeonPrettyPrinter printer = new DungeonPrettyPrinter();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyymmdd");
        String filename = String.format("dungeon-%s-%s.txt", formatter.format(new Date()), dungeon.getEntrance().getBottomCenter().toShortString().replaceAll(" ", "-"));
        Path path = Paths.get(ModConfig.dungeonsFolder, "dumps").toAbsolutePath();
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            Dungeons2.log.error("Couldn't create directories for dump files:", (Throwable)e);
            return;
        }
        String s = printer.print(dungeon, Paths.get(path.toString(), filename).toString());
    }

    private ICoords getReduxCoords(World world, ICoords coords) {
        double closestDistSq = -1.0;
        Coords closestCoords = null;
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer player = (EntityPlayer)world.field_73010_i.get(i);
            Coords playerCoords = new Coords(player.func_180425_c());
            double dist = coords.getDistanceSq((ICoords)playerCoords);
            if (closestDistSq != -1.0 && !(dist < closestDistSq)) continue;
            closestDistSq = dist;
            closestCoords = playerCoords;
        }
        if (closestCoords != null) {
            Dungeons2.log.debug(String.format("The closest player is %s squared blocks away at pos %s", String.valueOf(closestDistSq), closestCoords.toShortString()));
        }
        if (closestDistSq > 6400.0) {
            Dungeons2.log.debug("Closest player is outside of generation proximity. Moving to a closer position.");
            double ratio = 6400.0 / closestDistSq;
            ICoords delta = coords.delta(closestCoords);
            double redux = 1.0 - ratio;
            double xRedux = (double)delta.getX() * redux;
            double zRedux = (double)delta.getZ() * redux;
            int xSpawn = coords.getX() - (int)Math.floor(xRedux);
            int zSpawn = coords.getZ() - (int)Math.floor(zRedux);
            int ySpawn = WorldInfo.getHeightValue((World)world, (ICoords)new Coords(xSpawn, 255, zSpawn));
            coords = new Coords(xSpawn, ySpawn, zSpawn);
        }
        return coords;
    }

    public boolean isRegisteredDungeonWithinDistance(World world, ICoords coords, int minDistance) {
        double minDistanceSq = minDistance * minDistance;
        List<DungeonInfo> infos = DungeonRegistry.getInstance().getEntries();
        if (infos == null || infos.size() == 0) {
            Dungeons2.log.debug("Unable to locate the Dungeon Registry or the Registry doesn't contain any values");
            return false;
        }
        for (DungeonInfo info : infos) {
            double distance = coords.getDistanceSq(info.getCoords());
            if (!(distance < minDistanceSq)) continue;
            return true;
        }
        return false;
    }

    public int getChunksSinceLastDungeon() {
        return this.chunksSinceLastDungeon;
    }

    public void setChunksSinceLastDungeon(int chunksSinceLastDungeon) {
        this.chunksSinceLastDungeon = chunksSinceLastDungeon;
    }

    public ICoords getLastDungeonCoords() {
        return this.lastDungeonCoords;
    }

    public void setLastDungeonCoords(ICoords lastDungeonBlockPos) {
        this.lastDungeonCoords = lastDungeonBlockPos;
    }

    public synchronized boolean isGenerating() {
        return this.isGenerating;
    }

    public synchronized void setGenerating(boolean isGenerating) {
        this.isGenerating = isGenerating;
    }

    private class RandomBuildSize
    implements IRandomProbabilityItem {
        public BuildSize size;
        public int prob = 0;

        public RandomBuildSize(BuildSize bs) {
            this.size = bs;
        }

        public int getProbability() {
            return this.prob;
        }
    }

    private class RandomBuildPattern
    implements IRandomProbabilityItem {
        public BuildPattern pattern;
        public int prob = 0;

        public RandomBuildPattern(BuildPattern bp) {
            this.pattern = bp;
        }

        public int getProbability() {
            return this.prob;
        }
    }
}

