/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeonsengine.builder;

import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeonsengine.builder.GenUtil;
import com.someguyssoftware.dungeonsengine.builder.ILevelBuilder;
import com.someguyssoftware.dungeonsengine.builder.LevelBuilder;
import com.someguyssoftware.dungeonsengine.config.DungeonConfigManager;
import com.someguyssoftware.dungeonsengine.config.IDungeonConfig;
import com.someguyssoftware.dungeonsengine.model.Boundary;
import com.someguyssoftware.dungeonsengine.model.Dungeon;
import com.someguyssoftware.gottschcore.positional.BBox;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class DungeonBuilder {
    private static int MIN_BOUNDARY_RADIUS = 25;
    private static int MAX_BOUNDARY_RADIUS = 256;
    public Dungeon EMPTY_DUNGEON = new Dungeon();
    public Boundary EMPTY_BOUNDARY = new Boundary(new BBox((ICoords)new Coords(0, 0, 0)));
    private World world;
    private Random random;
    private IDungeonConfig config;
    private Boundary boundary;
    private ILevelBuilder levelBuilder;
    private ICoords spawnCoords;
    private ICoords startPoint;
    private int numLevels;

    public DungeonBuilder(World world) {
        this.world = world;
        this.random = new Random();
    }

    public DungeonBuilder(World world, Random random) {
        this.world = world;
        this.random = random;
    }

    public DungeonBuilder with(IDungeonConfig config) {
        this.config = config;
        return this;
    }

    public DungeonBuilder with(Boundary boundary) {
        this.boundary = boundary;
        return this;
    }

    public DungeonBuilder with(ILevelBuilder builder) {
        this.levelBuilder = builder;
        return this;
    }

    public DungeonBuilder withSpawnPoint(ICoords spawnCoords) {
        this.spawnCoords = spawnCoords;
        return this;
    }

    public DungeonBuilder withStartPoint(ICoords coords) {
        this.startPoint = coords;
        return this;
    }

    public Dungeon build() {
        Dungeon dungeon = this.EMPTY_DUNGEON;
        if (this.spawnCoords == null) {
            Dungeons2.log.error("A spawn coordinate is required to build a dungeon.");
            return this.EMPTY_DUNGEON;
        }
        if (this.config == null) {
            Dungeons2.log.debug("A dungeon config was not provided. Using default config.");
            this.config = DungeonConfigManager.DEFAULT_CONFIG;
        }
        if (this.levelBuilder == null) {
            Dungeons2.log.debug("A level builder was not provided. Creating level builder...");
            this.levelBuilder = new LevelBuilder(this.getWorld(), this.getRandom()).with(this.getConfig().getLevelConfigs()[0]);
        }
        if (this.boundary == null) {
            Dungeons2.log.debug("Calculating dungeon boundary...");
            this.boundary = this.calculateDungeonBoundary();
            if (this.boundary == this.EMPTY_BOUNDARY) {
                return this.EMPTY_DUNGEON;
            }
        }
        Boundary levelBoundary = this.boundary.resize(this.config.getLevelConfigs()[0].getBoundaryFactor(), 25);
        Dungeons2.log.debug("init level boundary -> {}, factor -> {}", (Object)levelBoundary, (Object)this.config.getLevelConfigs()[0].getBoundaryFactor());
        Boundary spawnBoundary = levelBoundary.resize(this.config.getLevelConfigs()[0].getSpawnBoundaryFactor(), 25);
        Dungeons2.log.debug("init spawn boundary -> {}, factor -> {}", (Object)spawnBoundary, (Object)this.config.getLevelConfigs()[0].getSpawnBoundaryFactor());
        if (this.getStartPoint() == null) {
            ICoords startPoint = GenUtil.randomizeCoords(this.getRandom(), spawnBoundary);
            ChunkPos startChunk = startPoint.toChunkPos();
            if (!this.world.func_190526_b(startChunk.field_77276_a, startChunk.field_77275_b)) {
                Dungeons2.log.debug("startPoint is not in a loaded chunk -> {}", (Object)startChunk);
                return this.EMPTY_DUNGEON;
            }
            this.startPoint = startPoint.resetY(WorldInfo.getHeightValue((World)this.world, (ICoords)startPoint));
        }
        return dungeon;
    }

    public Boundary calculateDungeonBoundary() {
        Boundary dungeonBoundary = null;
        ICoords closestCoords = null;
        if (this.getBoundary() == null) {
            closestCoords = WorldInfo.getClosestPlayerCoords((World)this.world, (ICoords)this.spawnCoords);
            if (closestCoords == null) {
                Dungeons2.log.warn("Unable to locate closest player - using World spawn point");
                closestCoords = new Coords(this.world.func_175694_M());
            }
            if ((dungeonBoundary = this.calculateDungeonBoundary(closestCoords)) == null) {
                Dungeons2.log.warn("Unable to calculate dungeon boundary from spawn pos-> {}, and player pos -> {}", (Object)this.spawnCoords.toShortString(), (Object)closestCoords.toShortString());
                return this.EMPTY_BOUNDARY;
            }
            this.boundary = dungeonBoundary;
        } else {
            dungeonBoundary = this.getBoundary();
        }
        Dungeons2.log.debug("Dungeon boundary -> {}", (Object)dungeonBoundary);
        Dungeons2.log.debug("Dungeon boundary factor -> {}", (Object)this.config.getBoundaryFactor());
        if (this.config.getBoundaryFactor() > 0.0 && this.config.getBoundaryFactor() < 1.0) {
            int xAmount = (int)((double)(dungeonBoundary.getMaxCoords().getX() - dungeonBoundary.getMinCoords().getX()) * (1.0 - this.config.getBoundaryFactor()) / 2.0);
            int zAmount = (int)((double)(dungeonBoundary.getMaxCoords().getZ() - dungeonBoundary.getMinCoords().getZ()) * (1.0 - this.config.getBoundaryFactor()) / 2.0);
            dungeonBoundary = dungeonBoundary.grow(-xAmount, 0, -zAmount);
            Dungeons2.log.debug("Dungeon shrunk by factor -> {} [{} {}], to new size -> {}", (Object)this.config.getBoundaryFactor(), (Object)xAmount, (Object)zAmount, (Object)dungeonBoundary);
            this.boundary = dungeonBoundary;
        }
        return dungeonBoundary;
    }

    protected Boundary calculateDungeonBoundary(ICoords coords) {
        Boundary dungeonBoundary = null;
        ICoords deltaCoords = this.spawnCoords.delta(coords);
        Dungeons2.log.debug("spawnCoords -> {}", (Object)this.spawnCoords);
        Dungeons2.log.debug("deltaCoords -> {}", (Object)deltaCoords.toShortString());
        int dist = Math.max(Math.min(Math.max(Math.abs(deltaCoords.getX()), Math.abs(deltaCoords.getZ())), MAX_BOUNDARY_RADIUS), MIN_BOUNDARY_RADIUS);
        Dungeons2.log.debug("dist from player to spawn -> {}", (Object)dist);
        dungeonBoundary = new Boundary(coords, coords.add(1, 1, 1));
        EnumFacing fieldFacing = null;
        if (Math.abs(deltaCoords.getX()) >= Math.abs(deltaCoords.getZ())) {
            Dungeons2.log.debug("deltaX -> {} >= deltaZ -> {}", (Object)Math.abs(deltaCoords.getX()), (Object)Math.abs(deltaCoords.getZ()));
            if (deltaCoords.getX() < 0) {
                Dungeons2.log.debug("field facing west");
                fieldFacing = EnumFacing.WEST;
                dungeonBoundary = dungeonBoundary.expand(-dist, 0, 0).grow(0, 0, dist);
            } else {
                Dungeons2.log.debug("field facing east");
                fieldFacing = EnumFacing.EAST;
                dungeonBoundary = dungeonBoundary.expand(dist, 0, 0).grow(0, 0, dist);
            }
        } else {
            Dungeons2.log.debug("deltaX -> {} < deltaZ -> {}", (Object)Math.abs(deltaCoords.getX()), (Object)Math.abs(deltaCoords.getZ()));
            if (deltaCoords.getZ() < 0) {
                Dungeons2.log.debug("field facing north");
                fieldFacing = EnumFacing.NORTH;
                dungeonBoundary = dungeonBoundary.expand(0, 0, -dist).grow(dist, 0, 0);
            } else {
                Dungeons2.log.debug("field facing south");
                fieldFacing = EnumFacing.SOUTH;
                dungeonBoundary = dungeonBoundary.expand(0, 0, dist).grow(dist, 0, 0);
            }
        }
        return dungeonBoundary;
    }

    public World getWorld() {
        return this.world;
    }

    public Boundary getBoundary() {
        return this.boundary;
    }

    public ILevelBuilder getLevelBuilder() {
        return this.levelBuilder;
    }

    public void setLevelBuilder(ILevelBuilder levelBuilder) {
        this.levelBuilder = levelBuilder;
    }

    public Random getRandom() {
        return this.random;
    }

    public IDungeonConfig getConfig() {
        return this.config;
    }

    public ICoords getStartPoint() {
        return this.startPoint;
    }
}

