/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeonsengine.builder;

import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeonsengine.builder.ILevelBuilder;
import com.someguyssoftware.dungeonsengine.builder.IRoomBuilder;
import com.someguyssoftware.dungeonsengine.config.ILevelConfig;
import com.someguyssoftware.dungeonsengine.model.Boundary;
import com.someguyssoftware.dungeonsengine.model.ILevel;
import com.someguyssoftware.dungeonsengine.model.IRoom;
import com.someguyssoftware.dungeonsengine.model.Level;
import com.someguyssoftware.gottschcore.positional.ICoords;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LevelBuilder
implements ILevelBuilder {
    public static Logger logger = LogManager.getLogger((String)"DungeonsEngine");
    public static final ILevel EMPTY_LEVEL = new Level();
    public static final List<IRoom> EMPTY_ROOMS = new ArrayList<IRoom>(1);
    private static final double DEFAULT_FORCE_MODIFIER = 0.85;
    private World world;
    private Random random;
    private ILevelConfig config;
    private Boundary boundary;
    private ICoords startPoint;
    private IRoomBuilder roomBuilder;
    private List<IRoom> plannedRooms;
    int roomLossToDistanceBuffering = 0;
    int roomLossToValidation = 0;

    public LevelBuilder(World world) {
        this.world = world;
        this.random = new Random();
    }

    public LevelBuilder(World world, Random random) {
        this.world = world;
        this.random = random;
    }

    @Override
    public ILevel build() {
        Object start = null;
        Object end = null;
        Level level = new Level();
        if (this.startPoint == null) {
            Dungeons2.log.error("A start coordinate is required to build a dungeon.");
            return EMPTY_LEVEL;
        }
        return level;
    }

    @Override
    public ILevelConfig getConfig() {
        return this.config;
    }

    @Override
    public ILevelBuilder with(ILevelConfig config) {
        if (config != null) {
            this.config = config;
        }
        return this;
    }

    @Override
    public IRoomBuilder getRoomBuilder() {
        return this.roomBuilder;
    }

    @Override
    public ILevelBuilder with(IRoomBuilder builder) {
        if (builder != null) {
            this.roomBuilder = builder;
        }
        return this;
    }

    @Override
    public List<IRoom> getPlannedRooms() {
        if (this.plannedRooms == null) {
            this.plannedRooms = new ArrayList<IRoom>();
        }
        return this.plannedRooms;
    }

    @Override
    public ILevelBuilder with(IRoom room) {
        this.getPlannedRooms().add(room);
        return this;
    }

    @Override
    public void reset() {
    }

    public World getWorld() {
        return this.world;
    }

    public Random getRandom() {
        return this.random;
    }

    public Boundary getBoundary() {
        return this.boundary;
    }

    public ILevelBuilder with(Boundary boundary) {
        if (boundary != null) {
            this.boundary = boundary;
        }
        return this;
    }

    public ICoords getStartPoint() {
        return this.startPoint;
    }

    public ILevelBuilder with(ICoords startPoint) {
        this.startPoint = startPoint;
        return this;
    }
}

